# $Id: AliasMap.rb,v 1.2 2004/08/09 13:57:58 toki Exp $

class AliasMap < WPM::PageContext
  include WPM::CheckUtil

  def init_context
    @driver = driver
    @control = page_option(:control)
    @alias_list = @control.aliases
    @alias_index = nil
    @alias = nil
    @edit_alias_call_index = nil
    @del_alias_call_index = nil
    @entry_up_call_index = nil
    @entry_down_call_index = nil
  end

  def modified_count
    @alias_list.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @alias_list.modified_count = modified_count.to_i
    modified_count
  end

  def has_aliases?
    ! @alias_list.empty?
  end

  attr_reader :alias_list
  attr_writer :alias
  attr_accessor :alias_index

  def alias_path
    @alias['alias_path']
  end

  def orig_path
    @alias['orig_path']
  end

  def virtual_host
    @alias['virtual_host']
  end

  def add_alias
    pos = @alias_list.length.to_s
    @driver.redirect('SetupAlias', { 'pos' => pos.to_s })
    nil
  end

  def edit_alias
    pos = @edit_alias_call_index
    @driver.redirect('SetupAlias', { 'pos' => pos.to_s })
    nil
  end

  attr_writer :edit_alias_call_index

  def del_alias
    pos = @del_alias_call_index
    @alias_list.delete_at(pos)
    @control.set_aliases(@alias_list)
    nil
  end

  attr_writer :del_alias_call_index

  def entry_up
    unless (entry_up_disabled?) then
      i = @entry_up_call_index
      j = i - 1
      @alias_list.swap(i, j)
      @control.set_aliases(@alias_list)
    end
    nil
  end

  def entry_up_disabled?
    pos = @entry_up_call_index
    pos < 1 || @alias_list.length <= pos
  end

  attr_writer :entry_up_call_index

  def entry_down
    unless (entry_down_disabled?) then
      i = @entry_down_call_index
      j = i + 1
      @alias_list.swap(i, j)
      @control.set_aliases(@alias_list)
    end
    nil
  end

  def entry_down_disabled?
    pos = @entry_down_call_index
    pos < 0 || @alias_list.length - 1 <= pos
  end

  attr_writer :entry_down_call_index
end
