# $Id: Administrator.rb,v 1.5 2004/09/15 15:10:37 toki Exp $

require 'forwardable'

class Administrator < WPM::PageContext
  extend Forwardable

  def init_context
    @driver = driver
    @control = page_option(:control)
    @admin_params = @control.admin_params
  end

  def_delegator(:@admin_params, :modified_count)
  def_delegator(:@admin_params, :modified_count=)
  def_delegator(:@admin_params, :admin_user, :username)
  def_delegator(:@admin_params, :admin_password, :password)
  def_delegator(:@admin_params, :localhost_only)
  def_delegator(:@admin_params, :localhost_only=)
  def_delegator(:@admin_params, :japanese_handling)
  def_delegator(:@admin_params, :japanese_handling=)

  def empty_password?
    password = @admin_params.admin_password
    if (! password || password.strip.empty?) then
      return true
    else
      return false
    end
  end

  def edit_user
    @driver.redirect('AdminPassword')
    nil
  end

  def commit
    @control.set_admin_params(@admin_params)
    nil
  end
end
