# $Id: About.rb,v 1.3 2004/10/14 15:43:45 toki Exp $

require 'time'
require 'forwardable'

class About < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @base_dir = page_option(:base_dir)
  end

  def_delegator :@control, :start_time
  def_delegator :@control, :restart_count
  def_delegator :@control, :restart_time

  def restarted?
    @control.restart_count > 0
  end

  def run_time
    Time.now - @control.start_time
  end

  def restarted_run_time
    Time.now - @control.restart_time
  end

  def licence
    File.open(File.join(@base_dir, 'LICENCE')) {|input|
      input.read
    }
  end
end
