#!/usr/bin/env perl -w

use strict;
use Encode;
use Encode::Guess qw/euc-jp shift-jis utf8 jis/;
use Jcode;

#
# rss2imap_unicode - rss2imap unicode related module.
#
# Copyright (C) 2004 Taku Kudo <taku@chasen.org>
#               2005 Yoshinari Takaoka <mumumu@mumumu.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of the
# GPL2, GNU General Public License version 2.
#
# $Id: Unicode.pm,v 1.1 2005/10/01 06:51:34 mumumu-org Exp $
#


package RSS2IMAPLIB::Unicode;
{

    sub to_utf7 {

        my $s = shift;
        utf8::decode ($s); # set utf8 flag
        $s = Encode::encode ("UTF-7", $s);
        $s =~ s/\+([^\/&\-]*)\/([^\/\-&]*)\-/\+$1,$2\-/g;
        $s =~ s/&/&\-/g;
        $s =~ s/\+([^+\-]+)?\-/&$1\-/g;
        $s =~ s#/#,#g; # '/' cannot be used in courier/dovecot
        return $s;
    }


    sub to_utf8 {

        my $s       = shift;
        my $fromenc = lc(shift);

        return $s if( $fromenc =~ /utf.*8/i );

        if( $fromenc ) {
            Encode::from_to($s, $fromenc,'utf8');
        } else {
            Encode::encode('utf8',$s);
        }

        utf8::decode ($s); # set utf8 flag
        return $s;
    }


    sub to_mime {

        my $string = shift;
        my $fromenc  = lc(shift);
        my $return_str = undef;
        my $utf8 = undef;

        #    if we can, MIME encode with UTF-8. unless we can, use iso-2022-jp.
        if( $fromenc ) {

            $utf8 = Encode::from_to( $string, $fromenc, 'utf8');
            eval {
                $return_str = Jcode->new ( $utf8 )->MIME_Header;
            };

            if($@) {
                return Jcode->new ( $utf8 )->mime_encode;
            } else {
                return $return_str;
            }

        } else {

            $utf8 = Encode::encode('utf8',$string);
            eval {
                $return_str = Jcode->new ( $utf8 )->MIME_Header;
            };

            if($@) {
                return Jcode->new ( $utf8 )->mime_encode;
            } else {
                return $return_str;
            }

        }
    }

}

1;
