# 
# test_link_link.rb
# 
# Author : Mitsuyoshi Yoshida
# This program is freely distributable under the terms of an MIT-style license.
# 

require 'i18n'


class TestLinkKeyInfo
  attr_reader :linkstr, :idno, :formatno, :enable_formats

  def initialize(linkstr, idno=1, formatno=nil, enable_formats = nil)
    @linkstr = linkstr
    @idno = idno
    @formatno = formatno
    @enable_formats = enable_formats
  end

end



class TestLinkLink

  private
  
  KeyTable = {
    'case' => TestLinkKeyInfo.new('testcases/archiveData.php?targetTestCase=%s&edit=testcase'),
    'suite' => TestLinkKeyInfo.new('testcases/archiveData.php?print_scope=test_specification&edit=testsuite&level=testsuite&id=%s'),
    'project' => TestLinkKeyInfo.new('project/projectEdit.php?doAction=edit&tprojectID=%s'),
    'plan' => TestLinkKeyInfo.new('plan/planEdit.php?do_action=edit&tplan_id=%s'),
    'milestone' => TestLinkKeyInfo.new('plan/planMilestonesEdit.php?doAction=edit&id=%s'),
    'build' => TestLinkKeyInfo.new('plan/buildEdit.php?do_action=edit&build_id=%s'),
    'cfield' => TestLinkKeyInfo.new('cfields/cfieldsEdit.php?do_action=edit&cfield_id=%s'),
    'keyword' => TestLinkKeyInfo.new('keywords/keywordsEdit.php?doAction=edit&id=%s'),
    'user' => TestLinkKeyInfo.new('usermanagement/usersEdit.php?doAction=edit&user_id=%s'),
    'planreport' => TestLinkKeyInfo.new('results/printDocument.php?level=testsuite&id=%s&type=testplan&docTestPlanId=%s&', 2, 0, [1, 4]),
    'report' => TestLinkKeyInfo.new('results/printDocument.php?level=testsuite&id=%s&type=testreport&docTestPlanId=%s&', 2, 0, [1, 4]),
    'metrics' => TestLinkKeyInfo.new('results/resultsGeneral.php?&tplan_id=%s', 1, 0, [2,3]),
    'result' => TestLinkKeyInfo.new('results/resultsTC.php?&tplan_id=%s', 1, 0, [2,3]),
    'graph' => TestLinkKeyInfo.new('results/charts.php?&tplan_id=%s', 1, 0)
  }
  DefaultArgs = {
    "planreport" => ['summary'],
    "report" => ['summary', 'passfail']
  }
  FormatNameTable = {
    'oowriter' => 1,
    'oocalc' => 2,
    'msexcel' => 3,
    'msword' => 4
  }

  public
  
  def initialize(*args)
    @ids = []
    @key = nil
    @restargs = []
    @keyinfo = nil
    @isdl = nil
    @formatno = nil
    @formatname = nil
    args.each {|arg|
      val = nil
      if arg
        val = arg.strip
        val = nil 	if val.empty?
      end
      if (!@key)
        @key = val
        raise I18n.t('error.no_key')	unless val
        @keyinfo = KeyTable[val]
        unless @keyinfo
          raise I18n.t('error.invalid_key')
        end
        @formatno = @keyinfo.formatno
      elsif (@ids.size < @keyinfo.idno)
        raise I18n.t('error.no_id')	unless val
        @ids << val
      else
        @restargs << val	if val
      end
    }
  end


  def formatname=(fmtname)
    fmtno = FormatNameTable[fmtname]
    raise I18n.t('error.invalid_fmt')	unless fmtno
    unless @keyinfo.enable_formats.include?(fmtno)
      raise sprintf(I18n.t('error.not_report'), fmtname)
    end
    @formatno = fmtno
    @formatname = fmtname
  end

  
  def link
    idstr = @ids.join('-')
    viewstr = "TestLink:#{@key}##{idstr}"
    if (0 < @restargs.size)
      viewstr += "(#{@restargs.join(', ')})"
    end
    linkstr = sprintf(@keyinfo.linkstr, *@ids)
    if (@keyinfo.idno == 2)
      args = (0 < @restargs.size) ? @restargs : DefaultArgs[@key]
      linkstr += '&' + args.map{|e| e + '=y'}.join('&')
    elsif (@key == 'result' and (0 < @restargs.size))
      linkstr.gsub!('resultsTC', 'resultsByStatus')
      linkstr += '&type=' + @restargs[0]
    end
    linkstr += '&' + "format=#{@formatno}"	if @formatno

    linkstr = "lib/" + linkstr
    linkstr = File.join(Setting.plugin_redmine_testlinklink["testlink_address"], linkstr)

    windowstr = "target='_blank'"
    if (@formatname)
      windowstr = ""
      viewstr += ":#{@formatname}"
    end
    
    "<a class='testlinklink' href='#{linkstr}' #{windowstr}>#{viewstr}</a>"
  end
  

end
