/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.BollingerBand;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.SmaLine;
import jp.robotbrain.signal.StdevLine;

public class BollingerBandList
extends IndexObjectList<BollingerBand> {
    private static final long serialVersionUID = 1L;
    private final StdevLine m_stdevLine;
    private final SmaLine m_centerLine;
    private final double m_sigmaHigh;
    private final double m_sigmaLow;

    public BollingerBandList(int p_pcountCenter, int p_pcountStdev, double p_sigmaHigh, double p_sigmaLow) {
        this.m_centerLine = new SmaLine(p_pcountCenter);
        this.m_stdevLine = new StdevLine(p_pcountStdev);
        this.m_sigmaHigh = p_sigmaHigh;
        this.m_sigmaLow = p_sigmaLow;
    }

    @Override
    public void remove(String p_date) {
        super.remove(p_date);
        this.m_stdevLine.remove(p_date);
        this.m_centerLine.remove(p_date);
    }

    public void addObject(IndexLine p_src) {
        if (p_src == null) {
            return;
        }
        if (p_src.size() <= 0) {
            return;
        }
        this.m_centerLine.addPoint(p_src);
        this.m_stdevLine.addPoint(p_src);
        if (!this.m_centerLine.isExist()) {
            return;
        }
        if (!this.m_stdevLine.isExist()) {
            return;
        }
        BollingerBand b = new BollingerBand(((IndexPoint)p_src.getLast()).getTag(), ((IndexPoint)this.m_centerLine.getLast()).getValue(), ((IndexPoint)this.m_stdevLine.getLast()).getValue(), this.m_sigmaHigh, this.m_sigmaLow);
        this.add(b);
    }
}

