#!/bin/sh
"exec" "python" "$0" "$@"

import sys, re, string, cgi
from a2h import Header, HTMLMaker

class HTMLTitle (Header):
    "HTML title class."

    def __init__ (self, source):
        Header.__init__ (self, source)        
        obj = re.search ('___ (.+) ___', self.source)
        if obj:
            self.source = obj.group (1)
        else:
            sys.stderr.write ("%s: title text not found.\n" % sys.argv[0])
            sys.exit (1)

    def gettitle (self):
        return self.source
    
    def gethtml (self):
        return self.tagformat % (self.level , self.source, self.level)

if __name__ == '__main__':
    if len (sys.argv) == 2: 
        try:
            istream = open (sys.argv[1])
        except Exception, e:
            print e
            sys.exit (1)
    elif len (sys.argv) == 1: 
        istream = sys.stdin
    else:
        print """\
Usage: %s input-text-file

Report bugs to urago@users.sourceforge.net (enable Japanese)""" % (sys.argv[0])
        sys.exit (1)

    ht = HTMLTitle (istream.read ())
    print ht.gethtml ()
