#!/usr/bin/env python

import sys, string, cgi
from a2h import AsciiParagraphStream, HTMLMaker

class HTMLParagraphMaker (HTMLMaker):
    def __init__ (self, astream):
        self.ascii = astream

        self.ptagfmt = "<p>%s</p>"

    def make_paragraph (self):
        return self.ascii.getparagraph ()

    def gethtml (self):
        paragraph = self.make_paragraph ()
        paragraph = cgi.escape (paragraph)
        return self.ptagfmt % (paragraph)

if __name__ == '__main__':
    if len (sys.argv) == 2: 
        try:
            istream = open (sys.argv[1])
        except Exception, e:
            print e
            sys.exit (1)
    elif len (sys.argv) == 1: 
        istream = sys.stdin
    else:
        print """\
Usage: %s input-text-file

Report bugs to urago@users.sourceforge.net (enable Japanese)""" % (sys.argv[0])
        sys.exit (1)

    aps = AsciiParagraphStream (istream)
    htp = HTMLParagraphMaker (aps)
    print htp.gethtml ()
