#!/bin/sh
"exec" "python" "$0" "$@"

__all__ = ["ROAPData", "RegionData", "MatchData", "ROAPParser"]

"Reading XML type configuration file then define reading data method."

import sys, string, re, xmllib

class ROAPData:
    "The object which defined data."

    def __init__ (self):
        """
        Initalization.
        Followings are class variables.
    
        regions: region element object list.
        """

        self.regions = []

    def append (self, obj):
        "region object is added to a list."
        self.regions.append (obj)

    def getregions (self):
        "The list of region objects can be returned."
        return (self.regions)            

    def getmatches (self, regionname):
        "The list of match objects can be returned."
        return (self.regions[regionname])

    def dump (self):
        "Debugging dump."
        for region in self.regions:
            region.dump ()

class RegionData:
    "Region element object."

    def __init__ (self, atts):
        """
        Initialization.
        Followings are class variables.
        
        name: region element name.
        data: match element variables list.
        """
        self.MATCH = "match"
        self.atts = atts

    def get_param (self):
        "The key name in an object is returned."

        return self.atts

    def get_matchlist (self):
        "The list of match objects in an object is returned."

        matchlist = []
        for matchdata in self.atts[self.MATCH]:
            data = matchdata.getdata ()
            matchlist.append (data)
        return (matchlist)

    def setdata (self, data):
        """
        Data setting.
        A variable is set to a corresponding name.
        """

        self.atts[self.MATCH] = data
        return (self.atts)

    def dump (self):
        "Status dump for debugging."
        print "Region {"
        for data in self.atts[self.MATCH]:
            data.dump (2)
        print "}"

class MatchData:
    "Match element data object."

    def __init__ (self, atts):
        """
        Initialization.
        Followings are class variables.
    
        data: match element variables.
        """

        self.data = {"pattern" : "",
                     "range" : "1",
                     "content" : "yes"}

        for key in atts.keys ():
            self.data[key] = atts[key]

    def getdata (self):
        return (self.data)

    def setdata (self, key, data):
        self.data[key] = data

    def dump (self, space = 0):
        "Status dump for debugging."

        spc = ""
        for i in range (space):
            spc = spc + " " 

        print spc + "MatchData {"
        for key in self.data.keys ():
            print spc + "  %s: %s" % (key, self.data[key])
        print spc + "}"
        
class ROAPParser (xmllib.XMLParser):
    "ROAP parsing."

    def __init__ (self, file):
        """
        Initialization.
        Followings are class variables.
        
        file:       define data file stream.
        delimiters: default delimiter list.
        data:       variable data.
        """

        xmllib.XMLParser.__init__ (self)
        self.file = file
        self.delimiters = []
        self.data = ''
        
    def handle_xml (self, encoding, standalone):
        pass

    def handle_data (self, data):
        self.data = self.data + data

    def syntax_error (self, message):
        pass

    ######################################
    # Low level status dump for debugging.

    def dump_tagstart (self, elem, atts):
        print "<%s" % (elem)
        for key in atts.keys ():
            print '  %s="%s"' % (key, atts[key])
        print '>'

    def dump_tagend (self, elem):
        print "</%s>" % (elem)

    ######################################
    # <roap>: root element of document.
        
    def start_roap (self, atts):
        self.roapdata = ROAPData ()
        #print "# -------- Start of roapdata -------- #"

    def end_roap (self):
        #print "# -------- End of roapdata -------- #"
        pass

    ##########################
    # <region>: matching region.

    def start_region (self, atts):
        "The name attribute of region tag is registered.  "
        #self.dump_tagstart ("region", atts)
        self.region = RegionData (atts)
        self.matches = []

    def end_region (self):
        #print self.dump_tagend ("region")
        self.region.setdata (self.matches)
        self.roapdata.append (self.region)
        #self.region.dump ()
        #for data in self.matches:
        #    data.dump ()
        #pass

    ########################
    # <match>: text maching.
    
    def start_match (self, atts):
        #self.dump_tagstart ("match", atts)
        self.matchinfo = MatchData (atts)
        self.data = ''

    def end_match (self):
        #print "[match PCDATA]: '%s'" % self.data
        #self.dump_tagend ("match")
        self.matchinfo.setdata("pattern", self.data)
        #self.matchinfo.dump ()
        self.matches.append (self.matchinfo)

    #######################
    # Process unknown tags.

    def unknown_starttag (self, tag, atts):
        raise ValueError, 'Unknown start tag, line %d, "%s"' \
              % (self.lineno, tag)

    def unknown_endtag (self, tag):
        raise ValueError, 'Unknown end tag, line %d, "%s"' \
              % (self.lineno, tag)

    def unknown_charref(self, ref):
        raise ValueError, 'Unknown character reference: "%s"'\
              % (self.lineno, ref)

    def unknown_entityref(self, ref): 
        raise ValueError, 'Unknown entity reference: "%s"'\
              % (self.lineno, ref)

    def parse (self):
        "Parse data file."

        for c in self.file.read ():
            self.feed (c)

        return (self.roapdata)

###############################################################################
# Test routine.

if __name__ == "__main__":
    try:
        file = open ("./roap/ascii2html.roap")
    except Exception, e:
        print e
        sys.exit (1)

    defdata_parser = ROAPParser (file)
    roapdata = defdata_parser.parse ()
    roapdata.dump ()

    for reg in roapdata.getregions ():
        print reg.get_param ()
        print reg.get_matchlist ()
