<?php
/* SVN FILE: $Id: chart.php 613 2008-07-18 14:00:10Z bb_yujiro $ */
/**
 * YahooUI 円グラフ表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 613 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-18 23:00:10 +0900 (金, 18 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * YahooUI 円グラフ表示
 *
 * @access public
 * @param integer   $datas
 * @return void
 **/
function hitsuji_chart($datas)
{
    $sort = array();
    foreach ($datas as $id=>$row){
        $sort[$id] = $row['count'];
    }
    
    arsort($sort);
    
    $options = array();
    $row = 0;
    $other = 0;

?>
<ul class="horizontal listing">
	<li style="width:200px;">
		<div id="chart1"><a href="http://www.adobe.com/go/getflashplayer">Adobe Flash Player Download</a></div>
	</li>
	<li style="width:300px; text-align:left;">
		<ul id="legend">
<?php
    foreach ($sort as $id=> $count){
        if ($row < 5){
            $options[] = '{ response: "'.$datas[$id]['response'].
                            '", count: '.$datas[$id]['count'].' }';
            print ('<li class="chart0'.$row.'"><span class="categoryName">');
        } else {
            $other += $count;
            print ('<li class="chart05"><span class="categoryName">');
        }
        $row++;

        print ($datas[$id]['response']);
        print ('&nbsp;('.$datas[$id]['count'].')');
        print ('</span></li>');
    }
    if ($other != 0){
            $options[] = '{ response: "'._('Other').
                            '", count: '.$other.' }';
    }
?>		</ul>
	</li>
</ul>
<script type="text/javascript">
YAHOO.util.Event.onContentReady("chart1", function () {
	YAHOO.widget.Chart.SWFURL = "<?php e(BASE_URL); ?>resource/yui/charts/assets/charts.swf";
	YAHOO.example.publicOpinion =
	[
	    <?php e(implode(',', $options)); ?>
	]

	var opinionData = new YAHOO.util.DataSource( YAHOO.example.publicOpinion );
	opinionData.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
	opinionData.responseSchema = { fields: [ "response", "count" ] };

	var mychart = new YAHOO.widget.PieChart( "chart1", opinionData,
	{
		dataField: "count",
		categoryField: "response",
		series: [{}],
		expressInstall: "assets/expressinstall.swf"
	});

});
</script>
<?php
} // hitsuji_chart
?>
