<?php
/* SVN FILE: $Id: send.php 611 2008-07-17 13:02:52Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 611 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-17 22:02:52 +0900 (木, 17 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 611 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-17 22:02:52 +0900 (木, 17 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Private_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_message',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_message モデルオブジェクト
     * @var object 
     */
    public $fri_message = null;

    /**
     * 参照メッセージ
     * @var integer
     */
    protected $ref_message = 0;

    /**
     * ステータス
     * @var integer
     */
    protected $status = 0;

    /**
     * 送信相手
     * @var integer
     */
    protected $ref_to = 0;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/message.tpl');

        $this->fri_message->setCurId($this->id);
        
        $this->ref_message = empty($this->ref_message)? 0:$this->ref_message;

        $this->fri_message->setValue('status',      $this->status);
        $this->fri_message->setValue('ref_account', $this->account['id']);
        $this->fri_message->setValue('ref_to',      $this->ref_to);
        $this->fri_message->setValue('ref_from',    $this->account['id']);
        $this->fri_message->setValue('ref_message', $this->ref_message);
        $this->fri_message->setValue('flag',        FLAG_UNREAD);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->assign('status',  $this->fri_message->status);
        $munu_class = array(
            MESSAGE_INBOX=> '',
            MESSAGE_SENT=>  '',
            MESSAGE_DRAFT=> '',
            MESSAGE_TRASH=> '',
        );
        $this->objvew->assign('menu_class', $munu_class);
        $this->_setMessage();

        if ($this->account['id'] == $this->ref_to){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        $this->objvew->setRichEditor();
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'id'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'ref_message'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false,
            ),
            'status'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false
            ),
            'ref_to'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> false
            ),
        );
    }

    /**
     * メッセージの設定
     *
     * @access private
     * @return void
     **/
    private function _setMessage()
    {
        if (empty($this->ref_message)){
            $this->objvew->assign('subject', null);
            $this->objvew->assign('body',    null);
            return ;
        }
        $condition = array(
            'id'=>          $this->ref_message,
            'ref_account'=> $this->account['id']
        );
        $message = RKT_DB::getRow('fri_message', $condition);
        
        $message['subject'] = 'Re: '.$message['subject'];

        $body = explode("\r\n", $message['body']);
        $message['body'] = '';
        foreach ($body as $line){
            $message['body'] .= '&gt; '.$line."\r\n";
        }

        $this->objvew->assign('subject', $message['subject']);
        $this->objvew->assign('body',    $message['body']);
    }

} // class Controller
?>
