<?php
/* ========================================================================
 - [modules/setup/config.php]
 -      環境設定ファイルの更新
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/05] 画像取得順のNoticeを削除
 -      [2007/07/01] 絵文字用ウインドウデザインの追加
 -      [2006/09/30] コメントの誤字を修正
 -      [2006/09/29] 基礎URLの初期値自動入力追加と説明を変更
 -      [2006/09/29] モジュール等の読み込み内容を修正
 -      [2006/09/29] データベース処理のタイミング修正
 -      [2006/09/17] PDFサポート設定を追加
 -      [2006/09/12] SMARTY用定数名を変更
 -      [2006/09/05] MySQL用にデータベース設定を追加
 -      [2006/09/05] 定数書き換え正規表現の修正
 -      [2006/09/04] デザインテーマの設定を追加
 -      [2006/08/31] メールボックスパスの設定を追加
 -      [2006/08/24] 作成
 - ======================================================================== */
 
/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once LIB_DIR.'rkt_validate.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp
{
    /**
     * 入力値検査
     * @var object
     */
    var $objvld = null;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * 入力条件データ
     * @var array
     */
    var $conditions = array();

    /**
     * 入力データ
     * @var array
     */
    var $values = array();

    /**
     * configファイルの中身
     * @var string
     */
    var $buffer = '';

    /**
     * ファイル情報格納
     * @var array
     */
    var $fileinfos = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        if (!empty($_GET['complete'])){
            include_once LIB_DIR.'rkt_db.php';
            $this->objdb = RKT_db::getInstance();

            $this->update_theme();
            $this->Assign('complete', true);
        }

        // データ操作クラスの生成
        $this->objvld = new RKT_validate('_POST');
        if ($this->do_query()){
            header('Location: '.$_SERVER['PHP_SELF'].'?page=config&complete=1');
            exit();
        }

        $this->set_baseurl();
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     */
    function Assign($tpl_var,$value)
    {
        $GLOBALS[$tpl_var] = $value;
    }

    /**
     * 基礎URLの設定
     *
     * @access public
     * @return void
     */
    function set_baseurl()
    {
        $base_url = BASE_URL;
        if (!preg_match('/sns\.example\.com/i',$base_url)){
            return ;
        }

        $self = $_SERVER['PHP_SELF'];
        $pos = strrpos($self,'/');
        if (!empty($pos)){
            $self = substr($self,0,$pos);
        }
        $base_url = 'http://'.$_SERVER['HTTP_HOST'].$self.'/';
        $ssl_url = 'https://'.$_SERVER['HTTP_HOST'].$self.'/';

        $this->Assign('base_url', $base_url);
        $this->Assign('ssl_url', $ssl_url);
    }

    /**
     * 入力条件データの設定
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        $this->conditions = array (
            'wap_administrator'=> array(
                'type'=>     'email',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_system_name'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'copyright'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_invite'=> array(
                'type'=>     'number',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_pdf_support'=> array(
                'type'=>     'number',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_cookie_domain'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'base_url'=> array(
                'type'=>     'uri',
                'option'=>   null,
                'required'=> true,
            ),
            'ssl_url'=> array(
                'type'=>     'uri',
                'option'=>   null,
                'required'=> true,
            ),
            'path_info_key'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_db_driver'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_db_name'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'wap_db_host'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'wap_db_user'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'wap_db_passwd'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'use_set_names'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'wap_pass_seed'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'wap_pass_phrase'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'amazon_associateid'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'imagemagick_path'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'image_driver'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
            'pop3_host'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'pop3_account'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'pop3_password'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
            'mail_box_dir'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> false,
            ),
        );
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_validate()
    {
        $this->set_condition();
        foreach ($this->conditions as $key=>$condition){
            $this->objvld->validate(
                    $condition['type'], 
                    $key, 
                    $condition['option'], 
                    $condition['required']);
            $this->values[$key] = $this->objvld->getRequest($key);
        }
        $this->Assign('value', $this->values);

        $check = $this->objvld->getValidate();
        if (!$check){
            $this->objvld->displayAlert($this);
            return false;
        }

        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function replace_define()
    {
        $this->values['wap_invite'] = empty($this->values['wap_invite'])?'FALSE':'TRUE';
        $this->values['wap_pdf_support'] = empty($this->values['wap_pdf_support'])?'FALSE':'TRUE';

        foreach ($this->values as $key=>$value){
            $key = strtoupper($key);
            if ('WAP_INVITE' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                    "define('".$key."', ".$value.");",
                                    $this->buffer,
                                    1);
            } elseif ('WAP_PDF_SUPPORT' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                    "define('".$key."', ".$value.");",
                                    $this->buffer,
                                    1);
            } elseif ('COPYRIGHT' === $key){
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*\".*\"\);/",
                                    "define('".$key."', \"".$value."\");",
                                    $this->buffer,
                                    1);
            } else {
                $this->buffer = preg_replace(
                                    "/define\s*\('".$key."',\s*'.*'\);/",
                                    "define('".$key."', '".$value."');",
                                    $this->buffer,
                                    1);
            }
        } // foreach ($this->values as $key=>$value)
        
        /* データベースDSNの設定 */
        $sns_dsn =  'SNS_DB_FILE';
        $blob_dsn = 'BLOB_DB_FILE';
        if ($this->values['wap_db_driver'] != 'sqlite'){
            $sns_dsn  = 'DB_NAME_HOST';
            $blob_dsn = 'DB_NAME_HOST';
        }
        $this->buffer = preg_replace(
                            "/define\s*\('RKT_DSN',\s*WAP_DB_DRIVER\.':'\..+\);/",
                            "define('RKT_DSN', WAP_DB_DRIVER.':'.".$sns_dsn.");",
                            $this->buffer,
                            1);
        $this->buffer = preg_replace(
                            "/define\s*\('RKT_BLOB_DSN',\s*WAP_DB_DRIVER\.':'\..+\);/",
                            "define('RKT_BLOB_DSN', WAP_DB_DRIVER.':'.".$blob_dsn.");",
                            $this->buffer,
                            1);

        /* PathInfoの設定 */
        $action_style  = '';
        $uri_separator = '?';
        $method        = 'get';
        if (preg_match('/QUERY_STRING/i',$this->values['path_info_key'])){
            $action_style  = '.php?';
            $uri_separator = '&';
            $method        = 'post';
        }
        $this->buffer = preg_replace(
                            "/define\s*\('WAP_ACTION_STYLE',\s*'.*'\);/",
                            "define('WAP_ACTION_STYLE', '".$action_style."');",
                            $this->buffer,
                            1);
        $this->buffer = preg_replace(
                            "/define\s*\('WAP_URI_SEPARATOR',\s*'.*'\);/",
                            "define('WAP_URI_SEPARATOR', '".$uri_separator."');",
                            $this->buffer,
                            1);
        $this->buffer = preg_replace(
                            "/define\s*\('WAP_METHOD',\s*'.*'\);/",
                            "define('WAP_METHOD', '".$method."');",
                            $this->buffer,
                            1);

        $filename = BASE_DIR.'sns_config.php';
        $handle = fopen($filename, 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $this->buffer);
        fclose($handle);

        return true;
    }


    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (empty($_POST['manip'])){
            return false;
        }

        if (!$this->do_validate()){
            return false;
        }

        $filename = BASE_DIR.'sns_config.php';

        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $this->buffer = fread($handle, filesize($filename));
        fclose($handle);
        
        return $this->replace_define();
    }

    /**
     * デザインテーマの設定
     *
     * @access private
     * @return void
     **/
    function update_theme()
    {
        $sql = 
            'SELECT '.
                'ref_common,'.
                'ref_admin,'.
                'ref_private,'.
                'ref_friend,'.
                'ref_community,'.
                'ref_public,'.
                'frame_width '.
            'FROM '.
                DB_PREFIX.'sys_design '.
            'WHERE '.
                'id = 1';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $this->copy_image($result['ref_common'],'top');
        $this->copy_image($result['ref_common'],'header');
        $this->copy_image($result['ref_common'],'common');
        $this->update_css($result['ref_common'],'common');
        $this->update_css($result['ref_common'],'common','yui_container');

        $this->copy_image($result['ref_admin'],'admin');
        $this->update_css($result['ref_admin'],'admin');

        $this->copy_image($result['ref_private'],'private');
        $this->update_css($result['ref_private'],'private');

        $this->copy_image($result['ref_friend'],'friend');
        $this->update_css($result['ref_friend'],'friend');

        $this->copy_image($result['ref_community'],'community');
        $this->update_css($result['ref_community'],'community');

        $this->copy_image($result['ref_public'],'public');
        $this->update_css($result['ref_public'],'public');
    }

    /**
     * 画像のコピー
     *
     * @access private
     * @param integer $id
     * @param string $target
     * @return void
     */
    function copy_image($id, $target)
    {
        $sort_func = array(
            'private'=>   'sort',
            'friend'=>    'rsort',
            'community'=> 'sort',
            'header'=>    'sort',
            'admin'=>     'rsort',
            'top'=>       'sort',
            'common'=>    'sort',
            'public'=>    'sort',
        );

        $dir = THEME_DIR.$id.DIRECTORY_SEPARATOR;
        $prefix = '{'.$target.'_,joker_}';
        if ($target === 'common'){
            $prefix = 'common_';
        } elseif ($target === 'top'){
            $prefix = 'top_';
        } elseif ($target === 'header'){
            $prefix = 'header_';
        }
        $files = glob($dir.$prefix.'{*.jpg,*.jpeg,*.gif}', GLOB_BRACE);
        eval($sort_func[$target].'($files);');

        $img_path = RESOURCE_DIR.'img'.DIRECTORY_SEPARATOR.$target.DIRECTORY_SEPARATOR;

        $infos = array();
        foreach ($files as $source){
            $file  = basename($source);
            $name  = preg_replace('/(^'.$target.'_|joker_)/','',$file);
            $split = explode('.', $name);
            copy($source, $img_path.$name);
            
            $size = getimagesize($img_path.$name);
            $infos[$split[0]] = array(
                'filename'=>  $target.'/'.$name,
                'extension'=> $split[1],
                'width'=>     $size[0],
                'height'=>    $size[1],
            );
        }
        $this->fileinfos[$target] = $infos;
    }

    /**
     * アンチエイリアス色の取得
     *
     * @access private
     * @param string $color
     * @return array
     */
    function anti_alias($color)
    {
        $colors = array();
        $colors[] = $color;

        $red   = hexdec(substr($color, 0, 2));
        $blue  = hexdec(substr($color, 2, 2));
        $green = hexdec(substr($color, 4, 2));
        $back  = hexdec('FF');

        $num_red   = ($back - $red);
        $num_blue  = ($back - $blue);
        $num_green = ($back - $green);

        $rates = array(
            1.767, 1.112, 5.375, 4.031,
        );

        foreach ($rates as $rate){
            $color = '';

            $round = empty($num_red)?0:round($num_red / $rate);
            $color .= dechex($round + $red);

            $round = empty($num_blue)?0:round($num_blue / $rate);
            $color .= dechex($round + $blue);

            $round = empty($num_green)?0:round($num_green / $rate);
            $color .= dechex($round + $green);

            $colors[] = $color;
        }

        return $colors;
    }

    /**
     * 色の計算
     *
     * @access private
     * @param string $color
     * @param integer $number
     * @return $color
     */
    function add_color($color, $number)
    {
        $red   = hexdec(substr($color, 0, 2));
        $green = hexdec(substr($color, 2, 2));
        $blue  = hexdec(substr($color, 4, 2));

        $red   += $number;
        $green += $number;
        $blue  += $number;

        $red   = ($red > 255)?255:$red;
        $green = ($green > 255)?255:$green;
        $blue  = ($blue > 255)?255:$blue;

        $red   = ($red < 0)?0:$red;
        $green = ($green < 0)?0:$green;
        $blue  = ($blue < 0)?0:$blue;

        return dechex($red).dechex($green).dechex($blue);
    }

    /**
     * テキスト色の取得
     *
     * @access private
     * @param strig $color
     * @return string
     */
    function get_text_color($color)
    {
        $red   = hexdec(substr($color, 0, 2));
        $blue  = hexdec(substr($color, 2, 2));
        $green = hexdec(substr($color, 4, 2));

        $color = 'white';
        if (165 < $red){
            $color = 'black';
        }
        if (165 < $blue){
            $color = 'black';
        }
        if (165 < $green){
            $color = 'black';
        }
        return $color;
    }

    /**
     * スタイルシートの書き込み
     *
     * @access private
     * @param integer $id
     * @param string $css
     * @param string $filename
     * @return void
     */
    function update_css($id,$css,$filename='')
    {
        $filename = empty($filename)?$css:$filename;
        $sql=
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'des_theme '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        include_once SMARTY_DIR.'Smarty.class.php';
        $smarty = new Smarty();

        $smarty->template_dir = SMARTY_TEMPLATE_DIR;
        $smarty->compile_dir = SMARTY_COMPILE_DIR;

        $smarty->assign('url', BASE_URL);

        $colors = $this->anti_alias($result['round']);
        $smarty->assign('round', $colors);
        $colors = $this->anti_alias($result['box']);
        $smarty->assign('box', $colors);

        $smarty->assign('border', $result['border']);
        $smarty->assign('text', $result['text']);
        $smarty->assign('column', $result['column']);
        $smarty->assign('button', $result['button']);
        $smarty->assign('focus', $result['focus']);
        $smarty->assign('header', $result['header']);
        $smarty->assign('background', $result['background']);
        $smarty->assign('copyright', $this->get_text_color($result['header']));

        $smarty->assign('bg_column',  $this->add_color($result['border'], 50));
        $smarty->assign('bg_title',   $this->add_color($result['box'],    40));
        $smarty->assign('bg_subject', $this->add_color($result['border'], 60));
        $smarty->assign('bg_list',    $this->add_color($result['background'], 25));

        $smarty->assign('fileinfo', $this->fileinfos);

        $output = $smarty->fetch('admin/design/css/'.$filename.'.tpl');
        $output = mb_convert_encoding($output, 'SJIS', ENCODE_TYPE);

        /* ファイルの読み込み */
        $filename = RESOURCE_DIR.'css'.DIRECTORY_SEPARATOR.$filename.'.css';
        $fp = fopen($filename, 'w');
        if (!$fp){
            return ;
        }
        fwrite($fp, $output);
        fclose($fp);
    }
} // webapp


/**
 * データ操作設定・実行
 *
 * @access private
 * @return integer  データ操作結果
 */
function setValue($key)
{
    $const = strtoupper($key);
    echo empty($GLOBALS['value'][$key])?constant($const):$GLOBALS['value'][$key];
}

/**
 * データ操作設定・実行
 *
 * @access private
 * @return integer  データ操作結果
 */
function checked($key,$check)
{
    $const = strtoupper($key);
    $value = empty($GLOBALS['value'][$key])?constant($const):$GLOBALS['value'][$key];
    
    if ($value != $check){
        return ;
    }
    echo ' checked="checked"';
}


$webapp = new webapp();
$webapp->execute();
?>
<html lang="ja">
	<head>
		<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
		<title>rktSNSセットアップ</title>
		<link rel="stylesheet" href="./resource/css/common.css" />
		<link rel="stylesheet" href="./resource/css/admin.css" />
        <style media="screen" type="text/css">
        <!--
    	.next {
            font-size:23px;
    		color: blue;
    	}
        -->
    	</style>
	</head>
	<body>
		<table id="frame" align="center" cellpadding="0" cellspacing="0"><tbody>
			<tr><td id="frame_main">
				<!-- start:ヘッダー -->
				<table id="header" align="center" cellpadding="0" cellspacing="0"><tbody>
					<tr>
						<td rowspan="2"><a href="./"><img src="./resource/img/header/logo.gif" width="163" height="94" alt="{$smarty.const.WAP_SYSTEM_NAME}" /></a></td>
						<td rowspan="2">
						</td>
						<td><a href="http://rakuto.net/rktSNS/"><img  src="./resource/img/sponsor/ads.gif" width="468" height="60" alt="広告" /></a></td>
					</tr>
					<tr>
						<td id="headerbar">
							<ul>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=check">Step1</a></li>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=config">Step2</a></li>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=admin">Step3</a></li>
							</ul>
						</td>
					</tr>
				<tbody></table>
				<!-- /finish:ヘッダー -->

		<!-- start:メインコンテンツ -->
		<div id="content">
<!-- start:オペレーション領域 -->
<div id="operation"> 
    <h1>ステップ２</h1>

	<!-- start:丸角 -->
	<div class="round"> 
		<div class="round1"><span></span></div><div class="round2"><span></span></div>
		<div class="round3"></div><div class="round4"></div><div class="round5"></div> 
	</div>
	<div class="round_content">
		<div class="column"><h2>環境設定</h2></div>
		<!-- start:アクション -->
		<div class="formlist">
			<form name="edit" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <input type="hidden" name="page" value="config" />
<?php if (!empty($_GET['complete'])): ?>
                <div class="formrow">
                    <strong class="alert">設定を更新しました。</strong><br />
<?php if (WAP_DB_DRIVER != 'sqlite'): ?>
                    <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=database"><strong class="next">データベースの初期化へ</strong></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<?php endif; ?>
                    <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=admin"><strong class="next">ステップ３へ</strong></a>
                </div>
<?php endif; ?>
				<div class="formrow"><strong>サイト情報URL</strong></div>
				<div class="formrow">
					<label class="column">管理者メールアドレス：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_administrator'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_administrator" value="<?php setValue('wap_administrator'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">システム名：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_system_name'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_system_name" value="<?php setValue('wap_system_name'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">制作著作：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['copyright'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="copyright" value="<?php setValue('copyright'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">招待制度:</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_invite'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="wap_invite" value="1" id="wap_invite1"<?php checked('wap_invite',1); ?> />
						<label for="wap_invite1">招待制</label>&nbsp;
						<input type="radio" name="wap_invite" value="0" id="wap_invite2"<?php checked('wap_invite',0); ?> />
						<label for="wap_invite2">自由参加</label>&nbsp;
					</div>
				</div>
				<div class="formrow">
					<label class="column">日記のPDF:</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_pdf_support'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="wap_pdf_support" value="1" id="wap_pdf_support1"<?php checked('wap_pdf_support',1); ?> />
						<label for="wap_pdf_support1">PDFの生成を許可する</label>&nbsp;
						<input type="radio" name="wap_pdf_support" value="0" id="wap_pdf_support2"<?php checked('wap_pdf_support',0); ?> />
						<label for="wap_pdf_support2">PDFの生成を許可しない</label>&nbsp;
					</div>
				</div>

				<div class="formrow"><strong>サイトURL</strong></div>
				<div class="formrow">
					<label class="column">クッキー発行ドメイン：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_cookie_domain'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_cookie_domain" value="<?php setValue('wap_cookie_domain'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">ベースURL：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['base_url'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="base_url" value="<?php if (!empty($GLOBALS['base_url'])){ echo $GLOBALS['base_url']; } else { setValue('base_url'); } ?>" size="60" /><br />
                        exec.phpのあるパスを指定下さい。<br />
                        例）http://sns.example.com/rktSNS/htdocs/<br />
					</div>
				</div>
				<div class="formrow">
					<label class="column">SSLURL：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['ssl_url'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="ssl_url" value="<?php if (!empty($GLOBALS['ssl_url'])){ echo $GLOBALS['ssl_url']; } else {  setValue('ssl_url'); } ?>" size="60" /><br />
                        exec.phpのあるパスを指定下さい。<br />
                        例）https://sns.example.com/rktSNS/htdocs/<br />
                        <span class="alert">※SSL通信を用意していない場合は、httpsでは無くhttpと変更してください。</span><br />
					</div>
				</div>
				<div class="formrow">
					<label class="column">URLの表記について<br />(PathInfo):</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['path_info_key'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="path_info_key" value="QUERY_STRING" id="path_info_key0"<?php checked('path_info_key','QUERY_STRING'); ?> />
						<label for="path_info_key0">PathInfo無効</label>：exec.phpの様に拡張子が表示されます。<br />
                        <input type="radio" name="path_info_key" value="PATH_INFO" id="path_info_key1"<?php checked('path_info_key','PATH_INFO'); ?> />
						<label for="path_info_key1">PathInfo有効</label>：WebサービスのモジュールとしてPHPが動作する。<br />
						<input type="radio" name="path_info_key" value="ORIG_PATH_INFO" id="path_info_key2"<?php checked('path_info_key','ORIG_PATH_INFO'); ?> />
						<label for="path_info_key2">PathInfo有効</label>：CGIとしてPHPが動作する。<br />
					</div>
				</div>

				<div class="formrow"><strong>データベース</strong></div>
				<div class="formrow">
					<label class="column">データベースドライバ：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_db_driver'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="wap_db_driver" value="sqlite" id="wap_db_driver1"<?php checked('wap_db_driver','sqlite'); ?> />
						<label for="wap_db_driver1">SQLite</label>&nbsp;
						<input type="radio" name="wap_db_driver" value="mysql"  id="wap_db_driver2"<?php checked('wap_db_driver','mysql'); ?> />
						<label for="wap_db_driver2">MySql</label>&nbsp;
						<input type="radio" name="wap_db_driver" value="pgsql"  id="wap_db_driver3"<?php checked('wap_db_driver','pgsql'); ?> />
						<label for="wap_db_driver3">PostgreSQL</label>&nbsp;
					</div>
				</div>
				<div class="formrow">
					<label class="column">データベース名：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_db_name'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_db_name" value="<?php setValue('wap_db_name'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">ホスト：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_db_host'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_db_host" value="<?php setValue('wap_db_host'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">ユーザー名：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_db_user'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_db_user" value="<?php setValue('wap_db_user'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">パスワード：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_db_passwd'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_db_passwd" value="<?php setValue('wap_db_passwd'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">MySQLバージョン：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['use_set_names'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="use_set_names" value="0" id="use_set_names1"<?php checked('use_set_names','0'); ?> />
						<label for="use_set_names1">MySQL4.1未満</label>&nbsp;&nbsp;&nbsp;
						<input type="radio" name="use_set_names" value="1" id="use_set_names2"<?php checked('use_set_names','1'); ?> />
						<label for="use_set_names2">MySQL4.1以上</label><br />
                        <span class="alert">※MySQL以外を利用している場合はこの項目は関係ありません。</span><br />
					</div>
				</div>

				<div class="formrow"><strong>暗号など</strong></div>
				<div class="formrow">
					<label class="column">暗号等に使われる種：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_pass_seed'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_pass_seed" value="<?php setValue('wap_pass_seed'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">パスフレーズ：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['wap_pass_phrase'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="wap_pass_phrase" value="<?php setValue('wap_pass_phrase'); ?>" size="60" />
					</div>
				</div>

				<div class="formrow"><strong>アマゾンアソシエーションサービス</strong></div>
				<div class="formrow">
					<label class="column">アクセスID：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['amazon_associateid'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="amazon_associateid" value="<?php setValue('amazon_associateid'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow"><strong>画像処理</strong></div>
				<div class="formrow">
					<label class="column">imagemagickのパス：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['imagemagick_path'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="imagemagick_path" value="<?php setValue('imagemagick_path'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">画像加工ドライバ:</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['image_driver'])?'':'入力エラー<br />'; ?></span>
                        <input type="radio" name="image_driver" value="gd" id="image_driver1"<?php checked('image_driver','gd'); ?> />
						<label for="image_driver1">GD</label>&nbsp;
						<input type="radio" name="image_driver" value="imagemagick" id="image_driver2"<?php checked('image_driver','imagemagick'); ?> />
						<label for="image_driver2">ImageMagick</label>&nbsp;
					</div>
				</div>

				<div class="formrow"><strong>インポート用メール設定</strong></div>
				<div class="formrow">
					<label class="column">POP3ホスト：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['pop3_host'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="pop3_host" value="<?php setValue('pop3_host'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">POP3アカウント：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['pop3_account'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="pop3_account" value="<?php setValue('pop3_account'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">POP3パスワード：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['pop3_password'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="pop3_password" value="<?php setValue('pop3_password'); ?>" size="60" />
					</div>
				</div>
				<div class="formrow">
					<label class="column">メールボックスパス：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['mail_box_dir'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="mail_box_dir" value="<?php setValue('mail_box_dir'); ?>" size="60" />
					</div>
				</div>
				<div class="formbutton">
					<input type="submit" name="manip" value="更新" style="width:120px;" />
				</div>
			</form>

		</div>
		<!-- /finish:アクション -->
	</div>
	<div class="round"> 
		<div class="round5"></div><div class="round4"></div><div class="round3"></div> 
		<div class="round2"><span></span></div><div class="round1"><span></span></div>
	</div>
	<!-- /finish:丸角 -->

</div>
<!-- /finish:オペレーション領域 -->
<br />

		</div>
		<!-- /finish:メインコンテンツ -->

				<!-- start:フッター -->
				<div id="footer">
					<div class="text-center">
					</div>
					<div class="copyright">rktSNS&nbsp;&nbsp;&nbsp;</div>
				</div>
				<!-- /finish:フッター -->
			</td></tr>
		</tbody></table>
	</body>
</html>