<?php
/* ========================================================================
 - [modules/setup/admin.php]
 -      管理者アカウントの設定
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/05/27] 管理者と初期ユーザーを統合 
 -      [2006/09/29] モジュール等の読み込み内容を修正
 -      [2006/09/14] アカウントの更新日時を設定
 -      [2006/08/24] 作成
 - ======================================================================== */
 
/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objvld = null;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * 入力条件データ
     * @var array
     */
    var $conditions = array();

    /**
     * 入力データ
     * @var array
     */
    var $values = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->objdb = RKT_db::getInstance();

        if (!empty($_GET['complete'])){
            $this->Assign('complete', true);
        }

        // データ操作クラスの生成
        $this->objvld = new RKT_validate('_POST');
        if ($this->do_query()){
            header('Location: '.$_SERVER['PHP_SELF'].'?page=admin&complete=1');
            exit();
        }
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     */
    function Assign($tpl_var,$value)
    {
        $GLOBALS[$tpl_var] = $value;
    }

    /**
     * 入力条件データの設定
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        $this->conditions = array (
            'admin'=> array(
                'type'=>     'email',
                'option'=>   null,
                'required'=> true,
            ),
            'passwd'=> array(
                'type'=>     'string',
                'option'=>   null,
                'required'=> true,
            ),
        );
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_validate()
    {
        $this->set_condition();
        foreach ($this->conditions as $key=>$condition){
            $this->objvld->validate(
                    $condition['type'], 
                    $key, 
                    $condition['option'], 
                    $condition['required']);
            $this->values[$key] = $this->objvld->getRequest($key);
        }
        $this->Assign('value', $this->values);

        $check = $this->objvld->getValidate();
        if (!$check){
            $this->objvld->displayAlert($this);
            return false;
        }

        return true;
    }

    /**
     * アカウント情報の更新
     *
     * @access private
     * @param array $value
     * @return integer  データ操作結果
     */
    function update_account($value)
    {
        $now = sql_query::now();
        $email = sql_query::encrypt($value['email']);
        $email_hash = sql_query::hash($value['email']);
        $password = RKT_auth::passwdHash($value['password']);
        
        $sql = 
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'modify = '.$now.','.
                "email = '".$email."',".
                "email_hash = '".$email_hash."',".
                "password = '".$password."' ".
            'WHERE '.
                'id = '.$value['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * プロフィール情報の更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_profile($ref_account,$first_name,$second_name)
    {
        $first_name  = sql_query::encrypt($first_name);
        $second_name = sql_query::encrypt($second_name);
        
        $sql = 
            'UPDATE '.
                DB_PREFIX.'act_profile '.
            'SET '.
                "first_name = '".$first_name."',".
                "second_name = '".$second_name."' ".
            'WHERE '.
                'ref_account = '.$ref_account;
        return $this->objdb->exec($sql);
    }

    /**
     * メール配信用雛形の更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_sys_mail()
    {
        $now = sql_query::now();
        $sql = 
            'UPDATE '.
                DB_PREFIX.'sys_mailtpl '.
            'SET '.
                'modify = '.$now.','.
                "email = '".WAP_ADMINISTRATOR."',".
                "name = '".WAP_SYSTEM_NAME."' ".
            'WHERE '.
                'modify < '.$now;
        return $this->objdb->exec($sql);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (empty($_POST['manip'])){
            return false;
        }

        if (!$this->do_validate()){
            return false;
        }
        
        $values = array(
            'id'=>       SNS_ACC_ADMIN,
            'email'=>    $this->values['admin'],
            'password'=> $this->values['passwd'],
        );
        $this->update_account($values);

        $this->update_profile(SNS_ACC_ADMIN,'SNS','管理者');        
        $this->update_sys_mail();
        
        return true;
    }
} // webapp


/**
 * データ操作設定・実行
 *
 * @access private
 * @return integer  データ操作結果
 */
function setValue($key)
{
    $const = strtoupper($key);
    echo empty($GLOBALS['value'][$key])?'':$GLOBALS['value'][$key];
}
$webapp = new webapp();
$webapp->execute();
?>
<html lang="ja">
	<head>
		<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
		<title>rktSNSセットアップ</title>
		<link rel="stylesheet" href="./resource/css/common.css" />
		<link rel="stylesheet" href="./resource/css/admin.css" />
        <style media="screen" type="text/css">
        <!--
    	.next {
            font-size:23px;
    		color: blue;
    	}
        -->
    	</style>
	</head>
	<body>
		<table id="frame" align="center" cellpadding="0" cellspacing="0"><tbody>
			<tr><td id="frame_main">
				<!-- start:ヘッダー -->
				<table id="header" align="center" cellpadding="0" cellspacing="0"><tbody>
					<tr>
						<td rowspan="2"><a href="./"><img src="./resource/img/header/logo.gif" width="163" height="94" alt="{$smarty.const.WAP_SYSTEM_NAME}" /></a></td>
						<td rowspan="2">
						</td>
						<td><a href="http://rakuto.net/rktSNS/"><img  src="./resource/img/sponsor/ads.gif" width="468" height="60" alt="広告" /></a></td>
					</tr>
					<tr>
						<td id="headerbar">
							<ul>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=check">Step1</a></li>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=config">Step2</a></li>
								<li><a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=admin">Step3</a></li>
							</ul>
						</td>
					</tr>
				<tbody></table>
				<!-- /finish:ヘッダー -->


		<!-- start:メインコンテンツ -->
		<div id="content">
<!-- start:オペレーション領域 -->
<div id="operation"> 
    <h1>ステップ３</h1>

	<!-- start:丸角 -->
	<div class="round"> 
		<div class="round1"><span></span></div><div class="round2"><span></span></div>
		<div class="round3"></div><div class="round4"></div><div class="round5"></div> 
	</div>
	<div class="round_content">
		<div class="column"><h2>アカウント設定</h2></div>
		<!-- start:アクション -->
		<div class="formlist">
			<form name="edit" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <input type="hidden" name="page" value="admin" />
<?php if (!empty($_GET['complete'])): ?>
                <div class="formrow">
                    <strong class="alert">設定を更新しました。</strong><br />
                    <a href="<?php echo BASE_URL; ?>"><strong class="next"><?php echo WAP_SYSTEM_NAME; ?>へ</strong></a>
                </div>
<?php endif; ?>
				<div class="formrow"><strong>管理者アカウント</strong></div>
				<div class="formrow">
					<label class="column">e-mail：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['admin'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="admin" value="<?php setValue('admin'); ?>" size="60" /><br />
					</div>
				</div>
				<div class="formrow">
					<label class="column">パスワード：</label>
					<div>
                        <span class="alert"><?php echo empty($GLOBALS['alert']['passwd'])?'':'入力エラー<br />'; ?></span>
                        <input type="text" name="passwd" value="<?php setValue('passwd'); ?>" size="60" /><br />
                        管理者アカウントは一般ユーザーと同じログインフォームからログインします。<br />
					</div>
				</div>


				<div class="formbutton">
					<input type="submit" name="manip" value="更新" style="width:120px;" />
				</div>
			</form>

		</div>
		<!-- /finish:アクション -->
	</div>
	<div class="round"> 
		<div class="round5"></div><div class="round4"></div><div class="round3"></div> 
		<div class="round2"><span></span></div><div class="round1"><span></span></div>
	</div>
	<!-- /finish:丸角 -->

</div>
<!-- /finish:オペレーション領域 -->
<br />

		</div>
		<!-- /finish:メインコンテンツ -->

				<!-- start:フッター -->
				<div id="footer">
					<div class="text-center">
					</div>
					<div class="copyright">rktSNS&nbsp;&nbsp;&nbsp;</div>
				</div>
				<!-- /finish:フッター -->
			</td></tr>
		</tbody></table>
	</body>
</html>