<?php
/* ========================================================================
 - [modules/public/friend/friends.php]
 -      友達一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] 表示整形の不具合修正
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達ID
     * @var integer
     */
    var $ref_friend = 0;

    /**
     * オフセット
     * @var integer
     */
    var $offset = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/friend/friends.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friend');
        $this->setPathInfo('offset', 1);
        $this->Assign('ref_friend', $this->ref_friend);

        $this->set_profile();
        $this->set_friend();
        $this->set_uri();
    }

    /**
     * 友達情報の設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('profile', $result);
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $visibility = '';
        if (!WAP_SNS_VISIBILITY){
            $visibility = 'pro.visibility = '.VISIBILITY_PUBLIC.' AND ';
        }

        $objpgr = new RKT_pager($this->objdb, $this->offset, LIMIT_TILE);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = fri.ref_friend AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                $visibility.
                'fri.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'act.last_login DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $row = count($result);        
        $inits = array (0,4,3,2,1);
        for ($row=$inits[$row%5]; $row; $row--){
            $result[] = array(
                'name'=> '',
                'friend_number'=>0,
                'subject'=> 'no photo',
                'src'=>    NOPHOTO_SMALL,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }
        $this->Assign('friends', $this->shape_friend($result));
    }

    /**
     * 友達情報の取得
     *
     * @access private
     * @return void
     */
    function get_friend($ref_account)
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            $result = array(
                'id'=> null,
                'name'=> '',
                'friend_number'=>0,
                'src'=>    BASE_URL.NOPHOTO_SMALL,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }
        $result['src'] = empty($result['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$result['src'];
        $result['width'] = empty($result['width'])?PHOTO_SMALL_SIZE:$result['width'];
        $result['height'] = empty($result['height'])?PHOTO_SMALL_SIZE:$result['height'];

        return $result;
    }

    /**
     * 友達情報の成形
     *
     * @access private
     * @return void
     */
    function shape_friend($friends)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($friends as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * ページャー用URIの設定
     *
     * @access private
     * @return void
     */
    function set_uri()
    {
        $pager_uri  = HTTP_ACTION.'public/friend/friends/';
        $pager_uri .= $this->ref_friend.'/';
        $pager_uri .= '%offset%/';

        $this->Assign('pager_uri', $pager_uri);
    }
} // webapp
?>
