<?php
/* ========================================================================
 - [modules/private/review/search.php]
 -      投稿レビュー検索
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/05] SQLでのround()関数を使用しないように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('private/review/search.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'private/review/search/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }

        $this->set_sort();
        $this->set_category();
        $this->set_condition();
        $this->set_list();
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_REVIEW.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * カテゴリリストの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'rev_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys', $list);
    }

    /**
     * レビューリストの絞込み
     *
     * @access private
     * @return void
     **/
    function set_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'ref_category'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );
        $conditions = $this->catchCondition($validates);

        // 絞込み条件の初期化
        $where = array();
        /* カテゴリ */
        if (!empty($conditions['ref_category'])){
            $where[] = "itm.ref_category='".$conditions['ref_category']."'";
        }

        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "itm.name like '%".$keyword."%'".' OR '.
                    "itm.creator like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }


        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }

        
        if (!count($where)){
            return '';
        }

        $this->where = ' AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * レビューリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = empty($_REQUEST['offset'])?0:$_REQUEST['offset'];
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_REVIEW);

        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.modify as modify,'.
                'itm.url as url,'.
                'itm.asin as asin,'.
                'itm.name as name,'.
                'cat.category as category,'.
                'itm.ref_category as ref_category,'.
                'itm.creator as creator,'.
                'itm.manufacturer as manufacturer,'.
                'itm.imagemedium as imagemedium,'.
                'itm.listprice as listprice,'.
                'itm.total as total,'.
                'itm.post as post '.
            'FROM '.
                DB_PREFIX.'rev_category cat,'.
                DB_PREFIX.'rev_item itm '.
            'WHERE '.
                'cat.id = itm.ref_category '.
                $this->where.' '.
                $this->order;
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $value['point'] = round($value['total']);

            $list[] = $value;
        }

        $this->Assign('list', $list);
    }
} // webapp
?>
