<?php
/* ========================================================================
 - [modules/admin/item/upload.php]
 -      コンテンツ添付ファイルアップロード
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/22] 画像のアップロード処理を修正
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_pager.php';
require_once LIB_DIR.'rkt_upload.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * 添付ファイルID
     * @var integer
     */
    var $id = null;

    /**
     * カテゴリID
     * @var integer
     */
    var $ref_category = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/item/upload.tpl');

        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM);
        $this->objfile->setUID($this->account['id']);

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('ref_category');
        $this->set_category();
        $this->Assign('ref_category', $this->ref_category);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'itm_fileinfo');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            $this->upload();
            header('Location: '.HTTP_ACTION.'admin/item/upload/complete/');
            exit();
        }
        // 削除
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/item/upload/complete/');
            exit();
        }
        // 新規作成フォームへ移動
        if (!empty($_POST['new'])){
            header('Location: '.HTTP_ACTION.'admin/item/upload/');
            exit();
        }

        $this->set_fileinfo();
        $this->set_list();
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'itm_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }

        $this->ref_category = empty($this->ref_category)?
                                $result[0]['id']:$this->ref_category;
        $this->Assign('categorys', $list);
    }

    /**
     * ファイル情報の設定
     *
     * @access public
     * @return void
     */
    function set_fileinfo()
    {
        $sql=
            'SELECT '.
                'subject,'.
                'filename href,'.
                'thumbnail src,'.
                't_width width,'.
                't_height height '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('fileinfo',$result);
    }

    /**
     * ジャンルリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql = 
            'SELECT '.
                'id,'.
                'mimetype,'.
                'subject,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'ref_category = '.$this->ref_category.' '.
            'ORDER BY '.
                'modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('list', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        }

        /* 直接入力 */        
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        // 更新しない項目名
        $skip = array(
            'mimetype',
            'filename',
            'width',
            'height',
            'thumbnail',
            't_width',
            't_height',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this);
    }

    /**
     * 画像のアップロード処理
     *
     * @access public
     * @return integer  データ操作結果
     */
    function upload()
    {
        /* 一覧用画像 */
        if (!$this->objfile->catchFile('file')) {
            return false;
        }

        // ファイルの保存
        $dir = ARCHIVES_UPLOAD_PATH;
        $extension = $this->objfile->getExtension();

        $large_path = ARCHIVES_PATH.'item/large/'.$this->id.'.'.$extension;
        $small_path = ARCHIVES_PATH.'item/small/'.$this->id.'.'.$extension;

        // ファイルの保存
        if ($this->objfile->isImage()){
            $large = $this->objfile->saveResize($large_path,PHOTO_LARGE_SIZE,PHOTO_LARGE_SIZE);
            $small = $this->objfile->saveResize($small_path,PHOTO_SMALL_SIZE,PHOTO_SMALL_SIZE);
        } else {
            $res = $this->objfile->saveUpfile($large_path);
            $large = array('width'=>0,'height'=>0);
            $small_path = 'resource/img/common/';
            $small_path .= preg_match("/pdf/i", $mime_type)?'pdf.gif':'other.gif';
            $small = array('width'=>52,'height'=>55);
        }

        $values = array(
            'filename'=> $large_path,
            'width'=> $large['width'],
            'height'=> $large['height'],
            'thumbnail'=> $small_path,
            't_width'=> $small['width'],
            't_height'=> $small['height'],
        );

        return $this->update($values);
    }

    /**
     * 添付画像を更新
     *
     * @access private
     * @param array $values
     * @return boolean  真偽値
     */
    function update($values)
    {
        $sql=
            'SELECT '.
                'mimetype,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!empty($result)){
            $this->objfile->unlink($result['filename']);
            if (preg_match('/image/i', $result['mimetype'])){
                $this->objfile->unlink($result['thumbnail']);
            }
        } // if (!empty($result))

        $sql =
            'UPDATE '.
                DB_PREFIX.'itm_fileinfo '.
            'SET '.
                "filename='".$values['filename']."',".
                'width='.$values['width'].','.
                'height='.$values['height'].','.
                "thumbnail='".$values['thumbnail']."',".
                't_width='.$values['t_width'].','.
                't_height='.$values['t_height'].' '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 連続データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['deletes'] as $value){
            $id   = RKT_validate::number($value['delete'])?$value['delete']:0;
            $id   = $this->objdb->quote($id);

            $this->delete_file($id);
        }
        return true;
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_file($id)
    {
        $sql=
            'SELECT '.
                'mimetype,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        if (preg_match('/image/i', $result['mimetype'])){
            $this->objfile->unlink($result['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'itm_fileinfo '.
            'WHERE '.
                'id ='.$id;
        return $this->objdb->exec($sql);
    }

} // webapp
?>
