<?php
/* ========================================================================
 - [webapp/libs/private/dia_pictures.php]
 -      グループ関連の添付画像クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/06/20] XSS対応
 -      [2006/07/25] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_upload.php';

/**
 * プライベート関連の添付画像クラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package dia_pictures
 * @access public
 * @version 1.0
 */
class dia_pictures
{
    /**
     * 添付ファイル画像ID
     * @var integer
     */
    var $ids = 0;

    /**
     * ID
     * @var integer
     */
    var $ref_entry = 0;

    /**
     * アカウントID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $ref_entry
     * @return void
     */
    function dia_pictures($ref_entry)
    {
        $this->objdb = RKT_db::getInstance();
        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM);

        $this->ref_entry = empty($ref_entry)?0:$ref_entry;

        $objact = account::getInstance();
        $this->ref_account = $objact->getInfo('id');
        $this->set_ids();

        /* 削除画像IDの引継ぎ */
        if (!empty($_POST['picture_delete'])){
            $deletes = array();
            foreach ($_POST['picture_delete'] as $id) {
                if (is_numeric($id)){
                    $deletes[$id] = $id;
                }
            }
            $_SESSION['picture_delete'] = $deletes;
        } // if (!empty($_POST['picture_delete']))
    }

    /**
     * 添付ファイルIDの取得
     *
     * @access private
     * @return void
     */
    function set_ids()
    {
        if (isSet($_SESSION['ref_pictures'])){
            $this->ids = $_SESSION['ref_pictures'];
            return ;
        } // if (isSet($_SESSION['ref_pictures']))
        
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_account = '.$this->ref_account.' AND '.
                'ref_entry = '.$this->ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->ids = array();
        if (empty($result)){
            return ;
        }
        foreach ($result as $value){
            $this->ids[$value['id']] = $value['id'];
        }
    }

    /**
     * 画像のアップロード処理
     *
     * @access public
     * @return integer  データ操作結果
     */
    function doUpload()
    {
        if (empty($_POST['ref_pictures'])){
            return ;
        }

        $this->ids = array();
        $row = 0;
        foreach ($_POST['ref_pictures'] as $id) {
            if (!empty($id)){
                $this->ids[$id] = is_numeric($id)?$id:0;
            }
            $this->upload($id, 'photo'.$row);
            $row++;
        }
        $_SESSION['ref_pictures'] = $this->ids;
    }

    /**
     * 画像のアップロード処理
     *
     * @access public
     * @return integer  データ操作結果
     */
    function upload($id, $name)
    {
        /* 一覧用画像 */
        if (!$this->objfile->catchFile($name)) {
            return false;
        }
        if (!$this->objfile->isImage()){
            return false;
        }

        // ファイルの保存
        $dir = ARCHIVES_UPLOAD_PATH;
        $filename = $this->objfile->getName();
        $extension = $this->objfile->getExtension();

        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        $large_path = $dir.'large/'.$name.'.'.$extension;
        $small_path = $dir.'small/'.$name.'.'.$extension;

        $large = $this->objfile->saveResize($large_path,PHOTO_MAX_SIZE,PHOTO_MAX_SIZE);
        $small = $this->objfile->saveResize($small_path,PHOTO_SMALL_SIZE,PHOTO_SMALL_SIZE);

        $values = array(
            'title'=> $filename,
            'filename'=> $large_path,
            'width'=> $large['width'],
            'height'=> $large['height'],
            'thumbnail'=> $small_path,
            't_width'=> $small['width'],
            't_height'=> $small['height'],
        );

        if (empty($id)){
            $this->insert($values);
        } else {
            $this->update($id,$values);
        }
        return true;
    }

    /**
     * 添付画像を新規登録
     *
     * @access private
     * @param array $values
     * @return boolean  真偽値
     */
    function insert($values)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'dia_picture('.
                    'modify,'.
                    'ref_account,'.
                    'title,'.
                    'filename,'.
                    'width,'.
                    'height,'.
                    'thumbnail,'.
                    't_width,'.
                    't_height'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $this->ref_account.','.
                    "'".$values['title']."',".
                    "'".$values['filename']."',".
                    $values['width'].','.
                    $values['height'].','.
                    "'".$values['thumbnail']."',".
                    $values['t_width'].','.
                    $values['t_height'].
                ')';
        $result = $this->objdb->exec($sql);
        if ($result){
            $id = $this->objdb->lastInsertId();
            $this->ids[$id] = $id;
        }
        return $result;
    }

    /**
     * 添付画像を更新
     *
     * @access private
     * @param integer $id
     * @param array $values
     * @return boolean  真偽値
     */
    function update($id,$values)
    {
        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!empty($result)){
            $this->objfile->unlink($result['filename']);
            $this->objfile->unlink($result['thumbnail']);
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_picture '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                "title='".$values['title']."',".
                "filename='".$values['filename']."',".
                'width='.$values['width'].','.
                'height='.$values['height'].','.
                "thumbnail='".$values['thumbnail']."',".
                't_width='.$values['t_width'].','.
                't_height='.$values['t_height'].' '.
            'WHERE '.
                'id = '.$id;
        $result = $this->objdb->exec($sql);
        if ($result){
            $this->ids[$id] = $id;
        }
        return $result;
    }

    /**
     * 画像の削除
     *
     * @access public
     * @param boolean $cahtch
     * @return integer  データ操作結果
     */
    function doDelete($catch=false)
    {
        if ($catch) {
            if (empty($_SESSION['picture_delete'])){
                return ;
            }
            $deletes = $_SESSION['picture_delete'];
            unset($_SESSION['picture_delete']);
        } // if ($catch)
        
        foreach ($deletes as $id){
            $this->delete($id);
        }
    }

    /**
     * 画像の削除
     *
     * @access public
     * @param integer $id
     * @return integer  データ操作結果
     */
    function delete($id)
    {
        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        $this->objfile->unlink($result['thumbnail']);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->exec($sql);
    }

    /**
     * 修正等を更新する
     *
     * @access public
     * @param integer $ref_entry
     * @return boolean  真偽値
     */
    function setFix($ref_entry)
    {
        foreach ($this->ids as $id){
            $this->fix($id,$ref_entry);
        }
    }

    /**
     * 修正等を更新する
     *
     * @access public
     * @param integer $ref_entry
     * @return boolean  真偽値
     */
    function fix($id,$ref_entry)
    {
        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            return 0;
        }
        
        // ファイルの保存
        $dir = ARCHIVES_MEMBER_PATH.$this->ref_account.'/';

        $large_path = ereg_replace(ARCHIVES_UPLOAD_PATH, $dir, $result['filename']);
        $small_path = ereg_replace(ARCHIVES_UPLOAD_PATH, $dir, $result['thumbnail']);

        $this->objfile->setUID($this->ref_account);
        $this->objfile->rename($result['filename'], $large_path);
        $this->objfile->rename($result['thumbnail'], $small_path);
        
        $this->ref_entry = $ref_entry;
        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_picture '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'ref_entry='.$this->ref_entry.','.
                "filename='".$large_path."',".
                "thumbnail='".$small_path."' ".
            'WHERE '.
                'id = '.$id;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像IDを削除
     *
     * @access public
     * @return void
     */
    function unSetPicture()
    {
        unset($_SESSION['ref_pictures']);
    }

    /**
     * 添付画像情報の取得
     *
     * @access public
     * @return array
     */
    function getImgInfos()
    {
        $ids = implode(',',$this->ids);

        $sql=
            'SELECT '.
                'id,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id in('.$ids.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row=0;
        foreach ($result as $value){
            $list[] = $value;
            $row++;
        }
        
        for ($row;$row<3;$row++) {
            $list[] = array(
                'id'=>       null,
                'src'=> NOPHOTO_SMALL,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }

        return $list;
    }
}
// dia_pictureの終了
?>
