<?php
/* ========================================================================
 - [libs/rkt_webapp.php]
 -      WebApplicationクラス
 -      Copyright (c) 2004-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/06/20] XSS対応
 -      [2006/09/26] $_SESSION['condition']のキー名を変更
 -      [2006/09/12] SMARTY用定数名を変更
 -      [2006/08/31] http_build_query()のPHP4用対応
 -      [2006/08/31] RKT_webapp::catchCondition()の修正多次元配列対応
 -      [2006/06/06] メンバ変数のvalidate処理を追加
 -      [2004/12/18] version 0.1
 -      [2004/11/08] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once SMARTY_DIR.'Smarty.class.php';

/**
 * HTMLのテンプレート出力
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_webapp
 * @access public
 * @version 1.1
 */
class RKT_webapp
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * smartyオブジェクト
     * @var array
     */
    var $smarty = array();

    /**
     * テンプレートファイル
     * @var string
     */
    var $template_file = '';

    /**
     * 基礎テンプレートファイル
     * @var string
     */
    var $template_base = 'base.tpl';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_webapp()
    {
        $this->objdb = RKT_db::getInstance();

        $this->smarty = new Smarty();

        $this->smarty->compile_check = true;
        $this->smarty->debugging = false;

        $this->smarty->template_dir = SMARTY_TEMPLATE_DIR;
        $this->smarty->compile_dir = SMARTY_COMPILE_DIR;
        $this->smarty->config_dir = SMARTY_CONFIG_DIR;
        $this->smarty->cache_dir = SMARTY_CACHE_DIR;
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     * @return void
     */
    function baseAssign($tpl_var,$value)
    {
        $this->base[$tpl_var] = $value;
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     * @return void
     */
    function Assign($tpl_var,$value)
    {
        $this->smarty->assign($tpl_var, $value);
    }

    /**
     * テンプレートファイルの設定
     *
     * @access public
     * @param string $template_file
     * @return void
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * 基礎テンプレートファイルの設定
     *
     * @access public
     * @param string $template_base
     * @return void
     */
    function setTemplateBase($template_base)
    {
        $this->template_base = $template_base;
    }

    /**
     * スタイルシート外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    function addCss($file)
    {
        $this->base['css'][]['file'] = $file;
    }

    /**
     * JavaScript外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    function addJavas($file)
    {
        $this->base['js'][]['file'] = $file;
    }

    /**
     * JavaScript外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    function setBodyAttribute($name,$value)
    {
        $this->arg['body'][]['attribute'] = "{$name}=\"{$value}\"";
    }

    /**
     * デザインの出力
     *
     * @access public
     * @return void
     */
    function Output()
    {
        $this->smarty->assign('base', $this->base);

        $this->smarty->display($this->template_file);
    }

    /**
     * デザインの出力
     *
     * @access public
     * @return void
     */
    function mixOutput()
    {
        $this->smarty->assign('base', $this->base);

        $this->smarty->assign('content', $this->template_file);

        $this->smarty->display($this->template_base);
    }

    /**
     * リクエスト情報の取得
     *
     * @access public
     * @params string $key メンバ変数名
     * @params string $request グローバルスコープ名
     * @parmas string $type チェック情報
     * @return void
     */
    function setSafety($key, $request='_REQUEST', $type='number')
    {
        $option = null;
        if ($type == 'date'){
            $option = array(
                'format'=> '%Y-%n-%d'
            );
        }
        $value = RKT_validate::getSafety($type, $key, $option, $request);
        $value = $this->objdb->quote($value);
        $value = trim($value, "'");
        $this->$key = strip_tags($value);
    }

    /**
     * パスインフォによるリクエスト情報の取得
     *
     * @access public
     * @params string $key メンバ変数名
     * @params integer $num 配列番号
     * @parmas string $type チェック情報
     * @return void
     */
    function setPathInfo($key,$num=0,$type='number')
    {
        /* パスインフォからIDを取得 */
        $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
        $num += WAP_DEFAULT_NUMBER;

        $args = explode('/',$path_info);
        $value= isSet($args[$num])?$args[$num]:null;
        
        $func = array('RKT_validate', $type);
        if (!call_user_func($func, $value, null)){
            $value = null;
        }
        $value = $this->objdb->quote($value);
        $this->$key = trim($value, "'");
    }

    /**
     * フォームから飛んでくる絞込み条件を取得
     *
     * @access private
     * @param array $validates
     * @retrun array
     */
    function __array_quote($param)
    {
        if (!is_array($param)){
            $param = $this->objdb->quote($param);
            return trim($param, "'");
        }
        $result = array();
        foreach ($param as $key=>$value){
            $result[$key] = $this->__array_quote($value);
        }
        return $result;
    }

    /**
     * フォームから飛んでくる絞込み条件を取得
     *
     * @access public
     * @param array $validates
     * @retrun array
     */
    function catchCondition($validates,$save=false)
    {
        $condition = array();

        if (empty($_REQUEST['load_condition'])){
            // 整合性チェック
            foreach ($validates as $key=>$validate) {
                $result = 
                    RKT_validate::getSafety($validate['type'], $key, $validate['option']);
                $condition[$key] = $result;
                $condition[$key] = $this->__array_quote($result);
            } // foreach ($validates as $key=>$validate)
        } else {
            $condition = $_SESSION['condition'];
        } // if (empty($_REQUEST['load_condition']))
        $this->Assign('condition', $condition);

        $param = http_build_query($condition);
        $param = preg_replace('/\[/','%5B',$param);
        $param = preg_replace('/\]/','%5D',$param);
        $this->Assign('param',$param);
        
        if ($save){
            $_SESSION['condition'] = $condition;
        }

        return $condition;
    }
}
// RKT_webappの終了

/**
 * vlad_mustafin at ukr dot net
 * 29-Sep-2005 08:31 
 *
 * My example of this function for PHP versions < PHP5 without any 
 * regular expressions, just cycles, recursion and standard functions. 
 * It can work with complex arrays or objects or both combined.
 *
 * @link http://jp.php.net/manual/ja/function.http-build-query.php
 */
if(!function_exists('http_build_query')) {
   function http_build_query( $formdata, $numeric_prefix = null, $key = null ) {
       $res = array();
       foreach ((array)$formdata as $k=>$v) {
           $tmp_key = urlencode(is_int($k) ? $numeric_prefix.$k : $k);
           if ($key) {
               $tmp_key = $key.'['.$tmp_key.']';
           }
           if ( is_array($v) || is_object($v) ) {
               $res[] = http_build_query($v, null, $tmp_key);
           } else {
               $res[] = $tmp_key."=".urlencode($v);
           }
       }
       return implode("&", $res);
   }
}
?>
