<?php
/* ========================================================================
 - [libs/rkt_template.php]
 -      簡易テンプレートクラス
 -      Copyright (c) 2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/06/08] 作成
 - ======================================================================== */

/**
 * 簡易テンプレートクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_template
 * @access public
 * @version 0.1
 */
class RKT_template
{
    /**
     * テンプレート
     * @var string
     */
    var $template = '';

    /**
     * 解析結果
     * @var string
     */
    var $parsed = '';

    /**
     * 置換変数
     * @var array
     */
    var $assign = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $filename テンプレートファイル名
     * @return void
     */
    function RKT_template($filename='')
    {
        if (!empty($filename)){
            $this->readTemplate($filename);
        }
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    function assign($key,$value)
    {
        $this->assign[$key] = $value;
    }

    /**
     * 変数の初期化
     *
     * @access public
     * @return void
     */
    function clearAassign()
    {
        $this->assign = array();
    }

    /**
     * 解析結果の取得
     *
     * @access public
     * @return string
     */
    function getParsed()
    {        
        return $this->parsed;
    }

    /**
     * テンプレートの解析
     *
     * @access public
     * @return void
     */
    function parse()
    {
        $parse = $this->template;

        /* phpタグの処理 */
        $parse = preg_replace('/(\<\?php|\?\>)/', '<?php echo "\\1\r\n"; ?>', $parse);

        /* 変数の設定  2次元配列まで有効 */
        $parse = preg_replace('/{\$(\w+)\.(\w+)\}/', "<?php echo \$this->assign['\\1']['\\2']; ?>", $parse);
        $parse = preg_replace('/{\$(\w+)\}/', "<?php echo \$this->assign['\\1']; ?>", $parse);

        /* foreachの設定 変数のキーは「_row」で決めうち */
        $parse = preg_replace('/{foreach \$(\w+)}/', "<?php \$_ary = \$this->assign['\\1'];\r\nforeach (\$_ary as \$this->assign['_row']): ?>", $parse);
        $parse = preg_replace('/{\/foreach}/', "<?php endforeach; unset(\$_ary); ?>", $parse);

        /* emptyによるif文の設定 */
        $parse = preg_replace('/{empty \$(\w+)}/', "<?php if (!empty(\$this->assign['\\1'])): ?>", $parse);
        $parse = preg_replace('/{\/empty}/', "<?php endif; ?>", $parse);

		ob_start();
        eval('?>'. $parse);
		$this->parsed = ob_get_contents();
		ob_end_clean();
    }

    /**
     * テンプレートファイルの読み込み
     *
     * @access public
     * @param string $filename ファイル名
     * @return boolean
     */
    function readTemplate($filename)
    {
        if (!file_exists ($filename)){
            return false;
        }

        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $this->template = fread($handle, filesize($filename));
        fclose($handle);

        return true;
    }

    /**
     * 解析結果の保存
     *
     * @access public
     * @param string $filename ファイル名
     * @return boolean
     */
    function save($filename)
    {
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $this->parsed);
        fclose($handle);
        
        return $result;
    }

    /**
     * テンプレートの設定
     *
     * @access public
     * @param string $template テンプレート
     * @return void
     */
    function setTemplate($template)
    {
        $this->template = $template;
    }
} // RKT_template
?>
