<?php
/* ========================================================================
 - [libs/rkt_emoji.php]
 -      絵文字変換
 -      Copyright (c) 2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2007/06/24] 作成
 - ======================================================================== */

/**
 * ベースディレクトリ設定
 */
define('RKT_EMOJI_DIR', dirname(__FILE__).DIRECTORY_SEPARATOR);

/**
 * ユーザー認証クラス Context
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_emoji
 * @access public
 * @version 0.1
 */
class RKT_emoji
{
    /**
     * 変換後エンコード
     * @var string
     */
    var $to_encoding = '';

    /**
     * 変換前エンコード
     * @var string
     */
    var $from_encoding = '';

    /**
     * 内部エンコード
     * @var string
     */
    var $internal_encoding = '';

    /**
     * 出力エンコード
     * @var string
     */
    var $output_encoding = '';

    /**
     * デフォルト代替文字
     * @var string
     */
    var $default_substrchar = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_emoji($output='SJIS',$internal='')
    {
        $this->default_substrchar = mb_substitute_character();

        $this->internal_encoding = empty($internal)?mb_internal_encoding():$internal;
        $this->output_encoding   = $output;

        $this->auto_from_encoding();
    }

    /**
     * from_encodingの自動設定
     *
     * @access public
     * @return void
     */
    function auto_from_encoding()
    {
        /* Net_UserAgent_Mobileより */
        static $mobileRegex;
        if (!isset($mobileRegex)) {
            $docomoRegex    = '^DoCoMo/\d\.\d[ /]';
            $vodafoneRegex  = '^(?:(?:SoftBank|Vodafone|J-PHONE)/\d\.\d|MOT-)';
            $ezwebRegex     = '^(?:KDDI-[A-Z]+\d+[A-Z]? )?UP\.Browser\/';
            $airhphoneRegex = '^Mozilla/3\.0\((?:DDIPOCKET|WILLCOM);';
            $mobileRegex =
                "(?:($docomoRegex)|($vodafoneRegex)|($ezwebRegex)|($airhphoneRegex))";
        }

        // parse User-Agent string
        $ua =  $_SERVER['HTTP_USER_AGENT'];
        $this->from_encoding = 'NonMobile';
        if (preg_match("!$mobileRegex!", $ua, $matches)) {
            $this->from_encoding = @$matches[1] ? 'DoCoMo' :
                (@$matches[2] ? 'Vodafone' :
                 (@$matches[3] ? 'EZweb' : 'Tag'));
        }
    }

    /**
     * from_encodingの自動設定
     *
     * @access public
     * @return string
     */
    function getFromEncoding()
    {
        return $this->from_encoding;
    }

    /**
     * 絵文字変換
     *
     * @access public
     * @param string $str
     * @param string $to_encoding
     * @param string $from_encoding
     * @access public
     */
    function convertEncoding($str, $to_encoding, $from_encoding=null)
    {
        $this->to_encoding   = $to_encoding;
        $this->from_encoding = empty($from_encoding)?$this->from_encoding:$from_encoding;
        include_once RKT_EMOJI_DIR.'rktEmoji/'.$this->from_encoding.'.php';

        /* HEX フォーマットを設定 */
        mb_substitute_character('long');

        /* 絵文字はBAD+16進数に変換 */
        $str = mb_convert_encoding($str, $this->output_encoding, $this->internal_encoding);
        mb_substitute_character($this->default_substrchar);

        $pattern = array(
            'tag'=>      '\[m\:(\d+)\]',
            'docomo'=>   'BAD\+([A-F0-9]{4})',
            'ezweb'=>    'BAD\+([A-F0-9]{4})',
            'vodafone'=> '\x1B\$([E-GO-Q][!-z])\x0F',
        );
        $key = strtolower($this->from_encoding);
        
        $callback = array(&$this, '__callback');
        return preg_replace_callback('/'.$pattern[$key].'/', $callback, $str);
    }

    /**
     * 絵文字変換
     *
     * @access public
     * @param string $str
     * @param string $to_encoding
     * @param string $from_encoding
     * @access public
     */
    function convert($str, $to_encoding, $from_encoding=null)
    {
        $this->to_encoding   = $to_encoding;
        $this->from_encoding = empty($from_encoding)?$this->from_encoding:$from_encoding;
        include_once RKT_EMOJI_DIR.'rktEmoji/'.$this->from_encoding.'.php';

        $pattern = array(
            'tag'=>      '\[m\:(\d+)\]',
            'docomo'=>   'BAD\+([A-F0-9]{4})',
            'ezweb'=>    'BAD\+([A-F0-9]{4})',
            'vodafone'=> '\x1B\$([E-GO-Q][!-z])\x0F',
        );
        $key = strtolower($this->from_encoding);
        
        $callback = array(&$this, '__callback');
        return preg_replace_callback('/'.$pattern[$key].'/', $callback, $str);
    }

    /**
     * コールバック関数
     *
     * @access private
     * @param array $matches
     * @return string
     */
    function __callback($matches)
    {
        $class  = 'emoji_'.$this->from_encoding;
        $method = $this->from_encoding.'2'.$this->to_encoding;
        $method = strtolower($method);

        return call_user_func(array($class,$method), $matches[1]);
    }
} // RKT_emojiの終了
?>
