<?php
/* ========================================================================
 - [libs/rktEmoji/Tag.php]
 -      独自タグ用絵文字変換
 -      Copyright (c) 2007 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 参考資料：
 -       [絵文字の相互変換リスト] http://labs.unoh.net/2007/02/post_65.html
 - 更新履歴：
 -      [2007/06/24] 作成
 - ======================================================================== */

/**
 * 独自タグ用絵文字変換
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package emoji_Tag
 * @access public
 * @version 0.1
 */
class emoji_Tag
{
    /**
     * 独自タグからDoCoMoへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    function tag2docomo($dec)
    {
        $map = array(
              '1'=>'&#63964;',        '2'=>'&#63911;',            '3'=>'？',              '4'=>'&#63878;',            '5'=>'<',
              '6'=>'>',               '7'=>'<<',                  '8'=>'>>',              '9'=>'■',                 '10'=>'■',
             '11'=>'[i]',            '12'=>'&#63995;',           '13'=>'[スピーカ]',     '14'=>'&#63930;',           '15'=>'&#63811;',
             '16'=>'&#63651;',       '17'=>'■',                 '18'=>'■',             '19'=>'◆',                 '20'=>'◆',
             '21'=>'■',             '22'=>'■',                 '23'=>'&#63808;',       '24'=>'&#63808;',           '25'=>'&#63940;',
             '26'=>'＋',             '27'=>'－',                 '28'=>'＊',             '29'=>'↑',                 '30'=>'↓',
             '31'=>'&#63965;',       '32'=>'▼',                 '33'=>'▲',             '34'=>'▼',                 '35'=>'▲',
             '36'=>'◆',             '37'=>'◆',                 '38'=>'■',             '39'=>'■',                 '40'=>'&#63808;',
             '41'=>'&#63808;',       '42'=>'&#63736;',           '43'=>'&#63735;',       '44'=>'&#63647;',           '45'=>'&#63668;',
             '46'=>'&#63838;',       '47'=>'&#63810;',           '48'=>'&#63928;',       '49'=>'φ',                 '50'=>'&#63893;',
             '51'=>'&#63889;',       '52'=>'&#63698;',           '53'=>'&#63974;',       '54'=>'&#63959;',           '55'=>'×',
             '56'=>'&#63722;',       '57'=>'&#63937;',           '58'=>'&#63937;',       '59'=>'[フロッピー]',       '60'=>'[雪結晶]',
             '61'=>'×',             '62'=>'×',                 '63'=>'→',             '64'=>'←',                 '65'=>'&#63699;',
             '66'=>'÷',             '67'=>'[カレンダー]',       '68'=>'&#63893;',       '69'=>'☆',                 '70'=>'&#63705;',
             '71'=>'&#63817;',       '72'=>'&#63936;',           '73'=>'[チェック]',     '74'=>'&#63813;',           '75'=>'☆彡',
             '76'=>'&#63903;',       '77'=>'&#63904;',           '78'=>'&#63988;',       '79'=>'[フォルダ]',         '80'=>'&#63893;',
             '81'=>'&#63958;',       '82'=>'&#63963;',           '83'=>'&#63715;',       '84'=>'[フォルダ]',         '85'=>'&#63720;',
             '86'=>'[フキダシ]',     '87'=>'[カード]',           '88'=>'▲',             '89'=>'▼',                 '90'=>'[USA]',
             '91'=>'&#63716;',       '92'=>'&#63722;',           '93'=>'&#63697;',       '94'=>'&#63714;',           '95'=>'&#63649;',
             '96'=>'[フットボール]', '97'=>'&#63716;',           '98'=>'&#63956;',       '99'=>'&#63694;',          '100'=>'&#63716;',
            '101'=>'&#63716;',      '102'=>'&#63716;',          '103'=>'&#63722;',      '104'=>'&#63702;',          '105'=>'[カレンダー]',
            '106'=>'&#63711;',      '107'=>'&#63648;',          '108'=>'&#63863;',      '109'=>'&#63866;',          '110'=>'&#63704;',
            '111'=>'&#63704;',      '112'=>'&#63684;',          '113'=>'&#63976;',      '114'=>'[包丁]',            '115'=>'[ビデオ]',
            '116'=>'&#63739;',      '117'=>'└→',              '118'=>'&#63870;',      '119'=>'&#63873;',          '120'=>'&#63869;',
            '121'=>'&#63716;',      '122'=>'&#63716;',          '123'=>'[ネジ]',        '124'=>'&#63701;',          '125'=>'&#63679;',
            '126'=>'[フロッピー]',  '127'=>'[グラフ]',          '128'=>'[グラフ]',      '129'=>'&#63686;',          '130'=>'&#63904;',
            '131'=>'&#63716;',      '132'=>'[チェックマーク]',  '133'=>'&#63980;',      '134'=>'&#63813;',          '135'=>'[電池]',
            '136'=>'&#63919;',      '137'=>'[画びょう]',        '138'=>'&#63869;',      '139'=>'&#63930;',          '140'=>'←',
            '141'=>'→',            '142'=>'&#63716;',          '143'=>'&#63957;',      '144'=>'&#63718;',          '145'=>'[名札]',
            '146'=>'&#63696;',      '147'=>'&#63716;',          '148'=>'[トラック]',    '149'=>'&#63934;',          '150'=>'[PDC]',
            '151'=>'&#63859;',      '152'=>'&#63933;',          '153'=>'[送信BOX]',     '154'=>'[受信BOX]',         '155'=>'&#63720;',
            '156'=>'&#63685;',      '157'=>'[定規]',            '158'=>'[三角定規]',    '159'=>'[グラフ]',          '160'=>'[肉]',
            '161'=>'&#63721;',      '162'=>'[コンセント]',      '163'=>'[家族]',        '164'=>'[リンク]',          '165'=>'&#63718;',
            '166'=>'&#63860;',      '167'=>'%i1%%i2%',          '168'=>'&#63683;',      '169'=>'&#63815;',          '170'=>'[サイコロ]',
            '171'=>'[新聞]',        '172'=>'&#63676;',          '173'=>'　',            '174'=>'',                  '175'=>'',
            '176'=>'&#63712;',      '177'=>'&#63713;',          '178'=>'&#63740;',      '179'=>'[若葉マーク]',      '180'=>'&#63879;',
            '181'=>'&#63880;',      '182'=>'&#63881;',          '183'=>'&#63882;',      '184'=>'&#63883;',          '185'=>'&#63884;',
            '186'=>'&#63885;',      '187'=>'&#63886;',          '188'=>'&#63887;',      '189'=>'[10]',              '190'=>'&#63652;',
            '191'=>'&#63650;',      '192'=>'&#63655;',          '193'=>'&#63656;',      '194'=>'&#63657;',          '195'=>'&#63658;',
            '196'=>'&#63659;',      '197'=>'&#63660;',          '198'=>'&#63661;',      '199'=>'&#63662;',          '200'=>'&#63663;',
            '201'=>'&#63664;',      '202'=>'&#63665;',          '203'=>'&#63666;',      '204'=>'[蛇使座]',          '205'=>'&#63689;',
            '206'=>'&#63691;',      '207'=>'&#63695;',          '208'=>'&#63693;',      '209'=>'[バス停]',          '210'=>'[アンテナ]',
            '211'=>'&#63682;',      '212'=>'&#63688;',          '213'=>'&#63692;',      '214'=>'[地図]',            '215'=>'&#63938;',
            '216'=>'&#63681;',      '217'=>'&#63678;',          '218'=>'&#63960;',      '219'=>'&#63671;',          '220'=>'&#63670;',
            '221'=>'&#63927;',      '222'=>'&#63674;',          '223'=>'[観覧車]',      '224'=>'&#63900;',          '225'=>'&#63984;',
            '226'=>'&#63824;',      '227'=>'&#63831;',          '228'=>'[東京タワー]',  '229'=>'[777]',             '230'=>'[オメデトウ]',
            '231'=>'[的中]',        '232'=>'&#63724;',          '233'=>'&#63930;',      '234'=>'&#63816;',          '235'=>'&#63981;',
            '236'=>'[お化け]',      '237'=>'[日の丸]',          '238'=>'[スイカ]',      '239'=>'&#63983;',          '240'=>'[フライパン]',
            '241'=>'&#63975;',      '242'=>'&#63990;',          '243'=>'[イチゴ]',      '244'=>'&#63982;',          '245'=>'&#63700;',
            '246'=>'[クジラ]',      '247'=>'[ウサギ]',          '248'=>'&#63993;',      '249'=>'[サル]',            '250'=>'[カエル]',
            '251'=>'&#63814;',      '252'=>'&#63989;',          '253'=>'[アリ]',        '254'=>'&#63994;',          '255'=>'[ビーチ]',
            '256'=>'[ひまわり]',    '257'=>'&#63893;',          '258'=>'&#63894;',      '259'=>'&#63954;',          '260'=>'&#63952;',
            '261'=>'&#63910;',      '262'=>'&#63905;',          '263'=>'&#63916;',      '264'=>'&#63949;',          '265'=>'&#63891;',
            '266'=>'&#63892;',      '267'=>'&#63903;',          '268'=>'&#63907;',      '269'=>'[炎]',              '270'=>'[SOS]',
            '271'=>'[力こぶ]',      '272'=>'&#63889;',          '273'=>'&#63902;',      '274'=>'[宇宙人]',          '275'=>'&#63652;',
            '276'=>'&#63737;',      '277'=>'[アクマ]',          '278'=>'[花丸]',        '279'=>'&#63961;',          '280'=>'[100点]',
            '281'=>'&#63906;',      '282'=>'&#63917;',          '283'=>'[ウンチ]',      '284'=>'[人差し指]',        '285'=>'[得]',
            '286'=>'[ドクロ]',      '287'=>'&#63948;',          '288'=>'&#63723;',      '289'=>'&#63703;',          '290'=>'&#63924;',
            '291'=>'&#63908;',      '292'=>'[ギター]',          '293'=>'[バイオリン]',  '294'=>'&#63707;',          '295'=>'&#63925;',
            '296'=>'[ピストル]',    '297'=>'[エステ]',          '298'=>'[EZ]',          '299'=>'&#63867;',          '300'=>'&#63725;',
            '301'=>'&#63923;',      '302'=>'[UFO]',             '303'=>'[UP!]',         '304'=>'[注射]',            '305'=>'&#63653;',
            '306'=>'&#63669;',      '307'=>'&#63673;',          '308'=>'&#63675;',      '309'=>'&#63708;',          '310'=>'[演劇]',
            '311'=>'&#63710;',      '312'=>'&#63717;',          '313'=>'&#63719;',      '314'=>'&#63727;',          '315'=>'&#63728;',
            '316'=>'&#63729;',      '317'=>'&#63730;',          '318'=>'&#63731;',      '319'=>'&#63733;',          '320'=>'&#63734;',
            '321'=>'&#63808;',      '322'=>'&#63809;',          '323'=>'&#63810;',      '324'=>'&#63872;',          '325'=>'&#63888;',
            '326'=>'&#63920;',      '327'=>'&#63897;',          '328'=>'&#63890;',      '329'=>'&#63914;',          '330'=>'&#63915;',
            '331'=>'[ezplus]',      '332'=>'[地球]',            '333'=>'&#63985;',      '334'=>'&#63874;',          '335'=>'&#63923;',
            '336'=>'&#63738;',      '337'=>'&#63931;',          '338'=>'[ラジオ]',      '339'=>'[バラ]',            '340'=>'[教会]',
            '341'=>'&#63677;',      '342'=>'&#63973;',          '343'=>'&#63899;',      '344'=>'[天使]',            '345'=>'[トラ]',
            '346'=>'[クマ]',        '347'=>'[ネズミ]',          '348'=>'&#63950;',      '349'=>'&#63947;',          '350'=>'&#63996;',
            '351'=>'&#63944;',      '352'=>'[タコ]',            '353'=>'[ロケット]',    '354'=>'&#63935;',          '355'=>'&#63902;',
            '356'=>'[ハンマー]',    '357'=>'[花火]',            '358'=>'&#63980;',      '359'=>'&#63715;',          '360'=>'[噴水]',
            '361'=>'[キャンプ]',    '362'=>'[麻雀]',            '363'=>'[VS]',          '364'=>'[トロフィー]',      '365'=>'[カメ]',
            '366'=>'[スペイン]',    '367'=>'[ロシア]',          '368'=>'[工事中]',      '369'=>'&#63900;',          '370'=>'[祝日]',
            '371'=>'[夕焼け]',      '372'=>'&#63988;',          '373'=>'[株価]',        '374'=>'[警官]',            '375'=>'&#63686;',
            '376'=>'&#63687;',      '377'=>'&#63971;',          '378'=>'&#63690;',      '379'=>'&#63682;',          '380'=>'[18禁]',
            '381'=>'[バリ3]',       '382'=>'[COOL]',            '383'=>'[割]',          '384'=>'[サービス]',        '385'=>'&#63868;',
            '386'=>'&#63968;',      '387'=>'&#63966;',          '388'=>'[指]',          '389'=>'[営]',              '390'=>'↑',
            '391'=>'↓',            '392'=>'[占い]',            '393'=>'[マナーモード]','394'=>'[ケータイOFF]',     '395'=>'&#63722;',
            '396'=>'[ネクタイ]',    '397'=>'[ハイビスカス]',    '398'=>'[花束]',        '399'=>'[サボテン]',        '400'=>'&#63984;',
            '401'=>'&#63699;',      '402'=>'[祝]',              '403'=>'[薬]',          '404'=>'[風船]',            '405'=>'[クラッカー]',
            '406'=>'[EZナビ]',      '407'=>'[帽子]',            '408'=>'[ブーツ]',      '409'=>'[マニキュア]',      '410'=>'[美容院]',
            '411'=>'[床屋]',        '412'=>'[着物]',            '413'=>'[ビキニ]',      '414'=>'&#63726;',          '415'=>'&#63889;',
            '416'=>'&#63889;',      '417'=>'&#63889;',          '418'=>'&#63889;',      '419'=>'&#63889;',          '420'=>'&#63903;',
            '421'=>'&#63672;',      '422'=>'&#63812;',          '423'=>'&#63939;',      '424'=>'&#63986;',          '425'=>'[ソフトクリーム]',
            '426'=>'[ポテト]',      '427'=>'[だんご]',          '428'=>'[せんべい]',    '429'=>'&#63985;',          '430'=>'[パスタ]',
            '431'=>'[カレー]',      '432'=>'[おでん]',          '433'=>'[すし]',        '434'=>'&#63978;',          '435'=>'[みかん]',
            '436'=>'[トマト]',      '437'=>'[ナス]',            '438'=>'[弁当]',        '439'=>'[鍋]',              '440'=>'&#63953;',
            '441'=>'&#63941;',      '442'=>'&#63992;',          '443'=>'&#63952;',      '444'=>'&#63896;',          '445'=>'&#63910;',
            '446'=>'&#63942;',      '447'=>'&#63996;',          '448'=>'[風邪ひき]',    '449'=>'[熱]',              '450'=>'&#63946;',
            '451'=>'&#63897;',      '452'=>'&#63944;',          '453'=>'&#63908;',      '454'=>'&#63893;',          '455'=>'(>３<)',
            '456'=>'(´３｀)',      '457'=>'[鼻]',              '458'=>'&#63902;',      '459'=>'(>人<)',            '460'=>'[拍手]',
            '461'=>'&#63920;',      '462'=>'&#63909;',          '463'=>'&#63734;',      '464'=>'&#63956;',          '465'=>'&#63920;',
            '466'=>'m(_ _)m',       '467'=>'&#63890;',          '468'=>'[バニー]',      '469'=>'[トランペット]',    '470'=>'[ビリヤード]',
            '471'=>'[水泳]',        '472'=>'[消防車]',          '473'=>'[救急車]',      '474'=>'[パトカー]',        '475'=>'[ジェットコースター]',
            '476'=>'[門松]',        '477'=>'[ひな祭り]',        '478'=>'[卒業式]',      '479'=>'[ランドセル]',      '480'=>'[こいのぼり]',
            '481'=>'&#63654;',      '482'=>'[花嫁]',            '483'=>'[カキ氷]',      '484'=>'[線香花火]',        '485'=>'[巻貝]',
            '486'=>'[風鈴]',        '487'=>'[ハロウィン]',      '488'=>'[お月見]',      '489'=>'[サンタ]',          '490'=>'&#63831;',
            '491'=>'[虹]',          '492'=>'&#63690;',          '493'=>'&#63647;',      '494'=>'&#63709;',          '495'=>'[デパート]',
            '496'=>'[城]',          '497'=>'[城]',              '498'=>'[工場]',        '499'=>'[フランス]',        '500'=>'[オープンウェブ]',
            '501'=>'[カギ]',        '502'=>'[ABCD]',            '503'=>'[abcd]',        '504'=>'[1234]',            '505'=>'[記号]',
            '506'=>'[可]',          '507'=>'[チェックマーク]',  '508'=>'&#63826;',      '509'=>'[ラジオボタン]',    '510'=>'&#63873;',
            '511'=>'[←BACK]',      '512'=>'[ブックマーク]',    '513'=>'&#63858;',      '514'=>'&#63684;',          '515'=>'&#63686;',
            '516'=>'&#63722;',      '517'=>'&#63869;',          '518'=>'&#63962;',      '700'=>'[ドイツ]',          '701'=>'[イタリア]',
            '702'=>'[イギリス]',    '703'=>'[中国]',            '704'=>'[韓国]',        '705'=>'[白人]',            '706'=>'[中国人]',
            '707'=>'[インド人]',    '708'=>'[おじいさん]',      '709'=>'[おばあさん]',  '710'=>'[赤ちゃん]',        '711'=>'[工事現場の人]',
            '712'=>'[お姫様]',      '713'=>'[イルカ]',          '714'=>'[ダンス]',      '715'=>'&#63990;',          '716'=>'[ゲジゲジ]',
            '717'=>'[ゾウ]',        '718'=>'[コアラ]',          '719'=>'[牛]',          '720'=>'[ヘビ]',            '721'=>'[ニワトリ]',
            '722'=>'[イノシシ]',    '723'=>'[ラクダ]',          '724'=>'[A]',           '725'=>'[B]',               '726'=>'[O]',
            '727'=>'[AB]',          '728'=>'&#63737;',          '729'=>'&#63738;',      '730'=>'&#63875;',          '731'=>'&#63898;',
            '732'=>'&#63909;',      '733'=>'&#63912;',          '734'=>'&#63913;',      '735'=>'&#63919;',          '736'=>'[メロン]',
            '737'=>'[パイナップル]','738'=>'[ブドウ]',          '739'=>'&#63977;',      '740'=>'[とうもろこし]',    '741'=>'[キノコ]',
            '742'=>'[栗]',          '743'=>'[モモ]',            '744'=>'[やきいも]',    '745'=>'[ピザ]',            '746'=>'[チキン]',
            '747'=>'[七夕]',        '748'=>'&#63698;',          '749'=>'[辰]',          '750'=>'[ピアノ]',          '751'=>'&#63927;',
            '752'=>'&#63990;',      '753'=>'[ボーリング]',      '754'=>'[なまはげ]',    '755'=>'[天狗]',            '756'=>'[パンダ]',
            '757'=>'&#63949;',      '758'=>'&#63994;',          '759'=>'[花]',          '760'=>'[アイスクリーム]',  '761'=>'[ドーナツ]',
            '762'=>'[クッキー]',    '763'=>'[チョコ]',          '764'=>'[キャンディ]',  '765'=>'[キャンディ]',      '766'=>'(/_＼)',
            '767'=>'(・×・)',      '768'=>'|(・×・)|',        '769'=>'[火山]',        '770'=>'&#63889;',          '771'=>'[ABC]',
            '772'=>'[プリン]',      '773'=>'[ミツバチ]',        '774'=>'[てんとう虫]',  '775'=>'[ハチミツ]',        '776'=>'&#63978;',
            '777'=>'[飛んでいく金]','778'=>'[クラクラ]',        '779'=>'&#63945;',      '780'=>'&#63945;',          '781'=>'&#63831;',
            '782'=>'(´３｀)',      '783'=>'&#63893;',          '784'=>'&#63859;',      '785'=>'&#63951;',          '786'=>'&#63951;',
            '787'=>'&#63947;',      '788'=>'&#63896;',          '789'=>'&#63896;',      '790'=>'&#63955;',          '791'=>'&#63955;',
            '792'=>'&#63992;',      '793'=>'[ドレス]',          '794'=>'[モアイ]',      '795'=>'[駅]',              '796'=>'[花札]',
            '797'=>'[ジョーカー]',  '798'=>'[エビフライ]',      '799'=>'&#63863;',      '800'=>'&#63960;',          '801'=>'[パトカー]',
            '802'=>'[EZムービー]',  '803'=>'&#63890;',          '804'=>'&#63988;',      '805'=>'&#63926;',          '806'=>'&#63932;',
            '807'=>'&#63962;',      '808'=>'&#63969;',          '809'=>'&#63970;',      '810'=>'&#63972;',          '811'=>'&#63979;',
            '812'=>'&#63987;',      '813'=>'&#63992;',          '814'=>'&#63992;',      '815'=>'[Cメール]',         '816'=>'&#63974;',
            '817'=>'&#63732;',      '818'=>'&#63877;',          '819'=>'(^-^)/',        '820'=>'＼(^o^)／',         '821'=>'&#63896;',
            '822'=>'&#63945;',
        );
        return empty($map[$dec])?'':$map[$dec];
    }

    /**
     * 独自タグからEZwebへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    function tag2ezweb($dec)
    {
        $map = array(
              '1'=>'F659',      '2'=>'F65A',      '3'=>'F65B',      '4'=>'F748',      '5'=>'F749',
              '6'=>'F74A',      '7'=>'F74B',      '8'=>'F74C',      '9'=>'F74D',     '10'=>'F74E',
             '11'=>'F74F',     '12'=>'F69A',     '13'=>'F6EA',     '14'=>'F796',     '15'=>'F65E',
             '16'=>'F65F',     '17'=>'F750',     '18'=>'F751',     '19'=>'F752',     '20'=>'F753',
             '21'=>'F754',     '22'=>'F755',     '23'=>'F756',     '24'=>'F757',     '25'=>'F797',
             '26'=>'F758',     '27'=>'F759',     '28'=>'F75A',     '29'=>'F75B',     '30'=>'F75C',
             '31'=>'F75D',     '32'=>'F75E',     '33'=>'F75F',     '34'=>'F760',     '35'=>'F761',
             '36'=>'F762',     '37'=>'F763',     '38'=>'F764',     '39'=>'F765',     '40'=>'F766',
             '41'=>'F767',     '42'=>'F768',     '43'=>'F769',     '44'=>'F660',     '45'=>'F693',
             '46'=>'F7B1',     '47'=>'F661',     '48'=>'F6EB',     '49'=>'F77C',     '50'=>'F6D3',
             '51'=>'F7B2',     '52'=>'F69B',     '53'=>'F6EC',     '54'=>'F76A',     '55'=>'F76B',
             '56'=>'F77D',     '57'=>'F798',     '58'=>'F654',     '59'=>'F77E',     '60'=>'F662',
             '61'=>'F76C',     '62'=>'F76D',     '63'=>'F76E',     '64'=>'F76F',     '65'=>'F69C',
             '66'=>'F770',     '67'=>'F780',     '68'=>'F6D4',     '69'=>'F663',     '70'=>'F771',
             '71'=>'F772',     '72'=>'F6ED',     '73'=>'F773',     '74'=>'F6B8',     '75'=>'F640',
             '76'=>'F644',     '77'=>'F64E',     '78'=>'F6B9',     '79'=>'F7AC',     '80'=>'F6D5',
             '81'=>'F774',     '82'=>'F775',     '83'=>'F674',     '84'=>'F7AD',     '85'=>'F7B3',
             '86'=>'F6D6',     '87'=>'F799',     '88'=>'F776',     '89'=>'F777',     '90'=>'F790',
             '91'=>'F675',     '92'=>'F781',     '93'=>'F7B4',     '94'=>'F6EE',     '95'=>'F664',
             '96'=>'F694',     '97'=>'F782',     '98'=>'F65C',     '99'=>'F642',    '100'=>'F783',
            '101'=>'F784',    '102'=>'F785',    '103'=>'F786',    '104'=>'F6EF',    '105'=>'F787',
            '106'=>'F676',    '107'=>'F665',    '108'=>'F6FA',    '109'=>'F79A',    '110'=>'F6F0',
            '111'=>'F79B',    '112'=>'F684',    '113'=>'F6BD',    '114'=>'F79C',    '115'=>'F79D',
            '116'=>'F6D7',    '117'=>'F778',    '118'=>'F779',    '119'=>'F6F1',    '120'=>'F6F2',
            '121'=>'F788',    '122'=>'F677',    '123'=>'F79E',    '124'=>'F6F3',    '125'=>'F68A',
            '126'=>'F79F',    '127'=>'F791',    '128'=>'F792',    '129'=>'F6F4',    '130'=>'F7A0',
            '131'=>'F789',    '132'=>'F77A',    '133'=>'F6A7',    '134'=>'F6BA',    '135'=>'F7A1',
            '136'=>'F77B',    '137'=>'F78A',    '138'=>'F6F5',    '139'=>'F7A2',    '140'=>'F6D8',
            '141'=>'F6D9',    '142'=>'F78B',    '143'=>'F678',    '144'=>'F6A8',    '145'=>'F6F6',
            '146'=>'F685',    '147'=>'F78C',    '148'=>'F68B',    '149'=>'F679',    '150'=>'F7A3',
            '151'=>'F7AE',    '152'=>'F7A4',    '153'=>'F7AF',    '154'=>'F7B0',    '155'=>'F6F7',
            '156'=>'F686',    '157'=>'F78D',    '158'=>'F67A',    '159'=>'F793',    '160'=>'F69D',
            '161'=>'F7A5',    '162'=>'F7A6',    '163'=>'F6DA',    '164'=>'F7A7',    '165'=>'F6F8',
            '166'=>'F6F9',    '167'=>'F666',    '168'=>'F68C',    '169'=>'F68D',    '170'=>'F6A1',
            '171'=>'F7A8',    '172'=>'F68E',    '173'=>'F7A9',    '174'=>'F7AA',    '175'=>'F7AB',
            '176'=>'F655',    '177'=>'F656',    '178'=>'F657',    '179'=>'F658',    '180'=>'F6FB',
            '181'=>'F6FC',    '182'=>'F740',    '183'=>'F741',    '184'=>'F742',    '185'=>'F743',
            '186'=>'F744',    '187'=>'F745',    '188'=>'F746',    '189'=>'F747',    '190'=>'F641',
            '191'=>'F65D',    '192'=>'F667',    '193'=>'F668',    '194'=>'F669',    '195'=>'F66A',
            '196'=>'F66B',    '197'=>'F66C',    '198'=>'F66D',    '199'=>'F66E',    '200'=>'F66F',
            '201'=>'F670',    '202'=>'F671',    '203'=>'F672',    '204'=>'F673',    '205'=>'F67B',
            '206'=>'F67C',    '207'=>'F67D',    '208'=>'F67E',    '209'=>'F680',    '210'=>'F681',
            '211'=>'F682',    '212'=>'F683',    '213'=>'F78E',    '214'=>'F78F',    '215'=>'F687',
            '216'=>'F688',    '217'=>'F689',    '218'=>'F643',    '219'=>'F68F',    '220'=>'F690',
            '221'=>'F691',    '222'=>'F692',    '223'=>'F645',    '224'=>'F695',    '225'=>'F696',
            '226'=>'F697',    '227'=>'F698',    '228'=>'F699',    '229'=>'F646',    '230'=>'F647',
            '231'=>'F69E',    '232'=>'F69F',    '233'=>'F6A0',    '234'=>'F6A2',    '235'=>'F6A3',
            '236'=>'F6A4',    '237'=>'F6A5',    '238'=>'F6A6',    '239'=>'F6A9',    '240'=>'F6AA',
            '241'=>'F6AB',    '242'=>'F6AC',    '243'=>'F6AD',    '244'=>'F6AE',    '245'=>'F6AF',
            '246'=>'F648',    '247'=>'F6B0',    '248'=>'F6B1',    '249'=>'F6B2',    '250'=>'F6B3',
            '251'=>'F6B4',    '252'=>'F6B5',    '253'=>'F6B6',    '254'=>'F6B7',    '255'=>'F6BB',
            '256'=>'F6BC',    '257'=>'F649',    '258'=>'F64A',    '259'=>'F64B',    '260'=>'F64C',
            '261'=>'F64D',    '262'=>'F6BE',    '263'=>'F6BF',    '264'=>'F6C0',    '265'=>'F64F',
            '266'=>'F650',    '267'=>'F651',    '268'=>'F652',    '269'=>'F653',    '270'=>'F6C1',
            '271'=>'F6C2',    '272'=>'F6C3',    '273'=>'F6C4',    '274'=>'F6C5',    '275'=>'F6C6',
            '276'=>'F6C7',    '277'=>'F6C8',    '278'=>'F6C9',    '279'=>'F6CA',    '280'=>'F6CB',
            '281'=>'F6CC',    '282'=>'F6CD',    '283'=>'F6CE',    '284'=>'F6CF',    '285'=>'F6D0',
            '286'=>'F6D1',    '287'=>'F6D2',    '288'=>'F6DB',    '289'=>'F6DC',    '290'=>'F6DD',
            '291'=>'F6DE',    '292'=>'F6DF',    '293'=>'F6E0',    '294'=>'F6E1',    '295'=>'F6E2',
            '296'=>'F6E3',    '297'=>'F6E4',    '298'=>'F794',    '299'=>'F795',    '300'=>'F6E5',
            '301'=>'F6E6',    '302'=>'F6E7',    '303'=>'F6E8',    '304'=>'F6E9',    '305'=>'F7B5',
            '306'=>'F7B6',    '307'=>'F7B7',    '308'=>'F7B8',    '309'=>'F7B9',    '310'=>'F7BA',
            '311'=>'F7BB',    '312'=>'F7BC',    '313'=>'F7BD',    '314'=>'F7BE',    '315'=>'F7BF',
            '316'=>'F7C0',    '317'=>'F7C1',    '318'=>'F7C2',    '319'=>'F7C3',    '320'=>'F7C4',
            '321'=>'F7C5',    '322'=>'F7C6',    '323'=>'F7C7',    '324'=>'F7C8',    '325'=>'F7C9',
            '326'=>'F7CA',    '327'=>'F7CB',    '328'=>'F7CC',    '329'=>'F7CD',    '330'=>'F7CE',
            '331'=>'F7CF',    '332'=>'F7D0',    '333'=>'F7D1',    '334'=>'F7E5',    '335'=>'F7E6',
            '336'=>'F7E7',    '337'=>'F7E8',    '338'=>'F7E9',    '339'=>'F7EA',    '340'=>'F7EB',
            '341'=>'F7EC',    '342'=>'F7ED',    '343'=>'F7EE',    '344'=>'F7EF',    '345'=>'F7F0',
            '346'=>'F7F1',    '347'=>'F7F2',    '348'=>'F7F3',    '349'=>'F7F4',    '350'=>'F7F5',
            '351'=>'F7F6',    '352'=>'F7F7',    '353'=>'F7F8',    '354'=>'F7F9',    '355'=>'F7FA',
            '356'=>'F7FB',    '357'=>'F7FC',    '358'=>'F340',    '359'=>'F341',    '360'=>'F342',
            '361'=>'F343',    '362'=>'F344',    '363'=>'F345',    '364'=>'F346',    '365'=>'F347',
            '366'=>'F348',    '367'=>'F349',    '368'=>'F34A',    '369'=>'F34B',    '370'=>'F34C',
            '371'=>'F34D',    '372'=>'F34E',    '373'=>'F34F',    '374'=>'F350',    '375'=>'F351',
            '376'=>'F352',    '377'=>'F353',    '378'=>'F354',    '379'=>'F355',    '380'=>'F356',
            '381'=>'F357',    '382'=>'F358',    '383'=>'F359',    '384'=>'F35A',    '385'=>'F35B',
            '386'=>'F35C',    '387'=>'F35D',    '388'=>'F35E',    '389'=>'F35F',    '390'=>'F360',
            '391'=>'F361',    '392'=>'F362',    '393'=>'F363',    '394'=>'F364',    '395'=>'F365',
            '396'=>'F366',    '397'=>'F367',    '398'=>'F368',    '399'=>'F369',    '400'=>'F36A',
            '401'=>'F36B',    '402'=>'F36C',    '403'=>'F36D',    '404'=>'F36E',    '405'=>'F36F',
            '406'=>'F370',    '407'=>'F371',    '408'=>'F372',    '409'=>'F373',    '410'=>'F374',
            '411'=>'F375',    '412'=>'F376',    '413'=>'F377',    '414'=>'F378',    '415'=>'F379',
            '416'=>'F37A',    '417'=>'F37B',    '418'=>'F37C',    '419'=>'F37D',    '420'=>'F37E',
            '421'=>'F380',    '422'=>'F381',    '423'=>'F382',    '424'=>'F383',    '425'=>'F384',
            '426'=>'F385',    '427'=>'F386',    '428'=>'F387',    '429'=>'F388',    '430'=>'F389',
            '431'=>'F38A',    '432'=>'F38B',    '433'=>'F38C',    '434'=>'F38D',    '435'=>'F38E',
            '436'=>'F38F',    '437'=>'F390',    '438'=>'F391',    '439'=>'F392',    '440'=>'F393',
            '441'=>'F394',    '442'=>'F395',    '443'=>'F396',    '444'=>'F397',    '445'=>'F398',
            '446'=>'F399',    '447'=>'F39A',    '448'=>'F39B',    '449'=>'F39C',    '450'=>'F39D',
            '451'=>'F39E',    '452'=>'F39F',    '453'=>'F3A0',    '454'=>'F3A1',    '455'=>'F3A2',
            '456'=>'F3A3',    '457'=>'F3A4',    '458'=>'F3A5',    '459'=>'F3A6',    '460'=>'F3A7',
            '461'=>'F3A8',    '462'=>'F3A9',    '463'=>'F3AA',    '464'=>'F3AB',    '465'=>'F3AC',
            '466'=>'F3AD',    '467'=>'F3AE',    '468'=>'F3AF',    '469'=>'F3B0',    '470'=>'F3B1',
            '471'=>'F3B2',    '472'=>'F3B3',    '473'=>'F3B4',    '474'=>'F3B5',    '475'=>'F3B6',
            '476'=>'F3B7',    '477'=>'F3B8',    '478'=>'F3B9',    '479'=>'F3BA',    '480'=>'F3BB',
            '481'=>'F3BC',    '482'=>'F3BD',    '483'=>'F3BE',    '484'=>'F3BF',    '485'=>'F3C0',
            '486'=>'F3C1',    '487'=>'F3C2',    '488'=>'F3C3',    '489'=>'F3C4',    '490'=>'F3C5',
            '491'=>'F3C6',    '492'=>'F3C7',    '493'=>'F3C8',    '494'=>'F3C9',    '495'=>'F3CA',
            '496'=>'F3CB',    '497'=>'F3CC',    '498'=>'F3CD',    '499'=>'F3CE',    '500'=>'F7D2',
            '501'=>'F7D3',    '502'=>'F7D4',    '503'=>'F7D5',    '504'=>'F7D6',    '505'=>'F7D7',
            '506'=>'F7D8',    '507'=>'F7D9',    '508'=>'F7DA',    '509'=>'F7DB',    '510'=>'F7DC',
            '511'=>'F7DD',    '512'=>'F7DE',    '513'=>'F7DF',    '514'=>'F7E0',    '515'=>'F7E1',
            '516'=>'F7E2',    '517'=>'F7E3',    '518'=>'F7E4',    '700'=>'F3CF',    '701'=>'F3D0',
            '702'=>'F3D1',    '703'=>'F3D2',    '704'=>'F3D3',    '705'=>'F3D4',    '706'=>'F3D5',
            '707'=>'F3D6',    '708'=>'F3D7',    '709'=>'F3D8',    '710'=>'F3D9',    '711'=>'F3DA',
            '712'=>'F3DB',    '713'=>'F3DC',    '714'=>'F3DD',    '715'=>'F3DE',    '716'=>'F3DF',
            '717'=>'F3E0',    '718'=>'F3E1',    '719'=>'F3E2',    '720'=>'F3E3',    '721'=>'F3E4',
            '722'=>'F3E5',    '723'=>'F3E6',    '724'=>'F3E7',    '725'=>'F3E8',    '726'=>'F3E9',
            '727'=>'F3EA',    '728'=>'F3EB',    '729'=>'F3EC',    '730'=>'F3ED',    '731'=>'F3EE',
            '732'=>'F3EF',    '733'=>'F3F0',    '734'=>'F3F1',    '735'=>'F3F2',    '736'=>'F3F3',
            '737'=>'F3F4',    '738'=>'F3F5',    '739'=>'F3F6',    '740'=>'F3F7',    '741'=>'F3F8',
            '742'=>'F3F9',    '743'=>'F3FA',    '744'=>'F3FB',    '745'=>'F3FC',    '746'=>'F440',
            '747'=>'F441',    '748'=>'F442',    '749'=>'F443',    '750'=>'F444',    '751'=>'F445',
            '752'=>'F446',    '753'=>'F447',    '754'=>'F448',    '755'=>'F449',    '756'=>'F44A',
            '757'=>'F44B',    '758'=>'F44C',    '759'=>'F44D',    '760'=>'F44E',    '761'=>'F44F',
            '762'=>'F450',    '763'=>'F451',    '764'=>'F452',    '765'=>'F453',    '766'=>'F454',
            '767'=>'F455',    '768'=>'F456',    '769'=>'F457',    '770'=>'F458',    '771'=>'F459',
            '772'=>'F45A',    '773'=>'F45B',    '774'=>'F45C',    '775'=>'F45D',    '776'=>'F45E',
            '777'=>'F45F',    '778'=>'F460',    '779'=>'F461',    '780'=>'F462',    '781'=>'F463',
            '782'=>'F464',    '783'=>'F465',    '784'=>'F466',    '785'=>'F467',    '786'=>'F468',
            '787'=>'F469',    '788'=>'F46A',    '789'=>'F46B',    '790'=>'F46C',    '791'=>'F46D',
            '792'=>'F46E',    '793'=>'F46F',    '794'=>'F470',    '795'=>'F471',    '796'=>'F472',
            '797'=>'F473',    '798'=>'F474',    '799'=>'F475',    '800'=>'F476',    '801'=>'F477',
            '802'=>'F478',    '803'=>'F479',    '804'=>'F47A',    '805'=>'F47B',    '806'=>'F47C',
            '807'=>'F47D',    '808'=>'F47E',    '809'=>'F480',    '810'=>'F481',    '811'=>'F482',
            '812'=>'F483',    '813'=>'F484',    '814'=>'F485',    '815'=>'F486',    '816'=>'F487',
            '817'=>'F488',    '818'=>'F489',    '819'=>'F48A',    '820'=>'F48B',    '821'=>'F48C',
            '822'=>'F48D',    '823'=>'F48E',    '824'=>'F48F',    '825'=>'F490',    '826'=>'F491',
            '827'=>'F492',    '828'=>'F493',    
        );
        return empty($map[$dec])?'':pack('H4',$map[$dec]);
    }

    /**
     * 独自タグからVodafoneへ変換
     *
     * @access public
     * @param string $dec
     * @return string
     */
    function tag2vodafone($dec)
    {
        $map = array(
              '1'=>'$Fr',            '2'=>'$GA',                '3'=>'$G@',                '4'=>'[Q]',                  '5'=>'$F[',
              '6'=>'$FZ',            '7'=>'$F]',                '8'=>'$F\',                '9'=>'$F;',               '10'=>'$F:',
             '11'=>'[i]',             '12'=>'$Gd',               '13'=>'$Ea',               '14'=>'$EO',               '15'=>'$Gl',
             '16'=>'$E]',           '17'=>'$F;',               '18'=>'$F:',               '19'=>'$F;',               '20'=>'$F;',
             '21'=>'$F;',           '22'=>'$F:',               '23'=>'$F9',               '24'=>'$F9',               '25'=>'[腕時計]',
             '26'=>'＋',              '27'=>'－',                  '28'=>'＊',                  '29'=>'$FR',               '30'=>'$FS',
             '31'=>'[禁止]',          '32'=>'▼',                  '33'=>'▲',                  '34'=>'▼',                  '35'=>'▲',
             '36'=>'$F;',           '37'=>'$F;',               '38'=>'$F;',               '39'=>'$F:',               '40'=>'$F9',
             '41'=>'$F9',           '42'=>'$FW',               '43'=>'$FX',               '44'=>'$Gj',               '45'=>'$G6',
             '46'=>'$GM',           '47'=>'$Gl',               '48'=>'$OE',               '49'=>'φ',                  '50'=>'$G"',
             '51'=>'$GB',           '52'=>'$Gd',               '53'=>'$E0',               '54'=>'$QW',               '55'=>'$OS',
             '56'=>'$O!',           '57'=>'[砂時計]',            '58'=>'[砂時計]',            '59'=>'$O6',               '60'=>'[雪結晶]',
             '61'=>'$OS',           '62'=>'$OS',               '63'=>'$FT',               '64'=>'$FU',               '65'=>'$Gg',
             '66'=>'÷',              '67'=>'[カレンダー]',        '68'=>'$Gv',               '69'=>'$OO',               '70'=>'$FV',
             '71'=>'$FY',           '72'=>'$GT',               '73'=>'[チェックマーク]',    '74'=>'$Gr',               '75'=>'☆彡',
             '76'=>'$ON',           '77'=>'$E/',               '78'=>'$QC',               '79'=>'[フォルダ]',          '80'=>'$G!',
             '81'=>'$Fn',           '82'=>'$Fo',               '83'=>'$OC',               '84'=>'[フォルダ]',          '85'=>'$G)',
             '86'=>'[フキダシ]',      '87'=>'[カード]',            '88'=>'▲',                  '89'=>'▼',                  '90'=>'$Q,',
             '91'=>'$Eh',           '92'=>'$O!',               '93'=>'$Ge',               '94'=>'$G(',               '95'=>'$Gk',
             '96'=>'$PK',           '97'=>'$Eh',               '98'=>'$EW',               '99'=>'$En',              '100'=>'$Eh',
            '101'=>'$Eh',          '102'=>'$Eh',              '103'=>'$O!',              '104'=>'$O3',              '105'=>'[カレンダー]',
            '106'=>'$EE',          '107'=>'$Gi',              '108'=>'$E#',              '109'=>'￥',                 '110'=>'$G]',
            '111'=>'$G]',          '112'=>'$GV',              '113'=>'$O$',              '114'=>'[包丁]',             '115'=>'$EI',
            '116'=>'[メガネ]',       '117'=>'└→',               '118'=>'←┘',               '119'=>'$E4',              '120'=>'$G_',
            '121'=>'$Eh',          '122'=>'$Eh',              '123'=>'[ネジ]',             '124'=>'$E^',              '125'=>'$G;',
            '126'=>'$O6',          '127'=>'$Ej',              '128'=>'$Ej',              '129'=>'$E!',              '130'=>'[懐中電灯]',
            '131'=>'$Eh',          '132'=>'[チェックマーク]',   '133'=>'$E8',              '134'=>'$Gr',              '135'=>'[電池]',
            '136'=>'[スクロール]',   '137'=>'[画びょう]',         '138'=>'$Ed',              '139'=>'$EO',              '140'=>'$FP',
            '141'=>'$FQ',          '142'=>'$Eh',              '143'=>'[クリップ]',         '144'=>'$E2',              '145'=>'[名札]',
            '146'=>'$Gc',          '147'=>'$Eh',              '148'=>'$PO',              '149'=>'$O!',              '150'=>'[PDC]',
            '151'=>'$E#',          '152'=>'[レンチ]',           '153'=>'[送信BOX]',          '154'=>'[受信BOX]',          '155'=>'$G)',
            '156'=>'$GX',          '157'=>'[定規]',             '158'=>'[三角定規]',         '159'=>'[グラフ]',           '160'=>'[肉]',
            '161'=>'$G*',          '162'=>'[コンセント]',       '163'=>'[家族]',             '164'=>'[リンク]',           '165'=>'$E2',
            '166'=>'$G+',          '167'=>'$Gj',              '168'=>'$G=',              '169'=>'$G<',              '170'=>'[サイコロ]',
            '171'=>'[新聞]',         '172'=>'$G>',              '173'=>'　',                 '174'=>'',                   '175'=>'',
            '176'=>'$O.',          '177'=>'$F(',              '178'=>'$F*',              '179'=>'$F)',              '180'=>'$F<',
            '181'=>'$F=',          '182'=>'$F>',              '183'=>'$F?',              '184'=>'$F@',              '185'=>'$FA',
            '186'=>'$FB',          '187'=>'$FC',              '188'=>'$FD',              '189'=>'[10]',               '190'=>'$Pc',
            '191'=>'$Gh',          '192'=>'$F_',              '193'=>'$F`',              '194'=>'$Fa',              '195'=>'$Fb',
            '196'=>'$Fc',          '197'=>'$Fd',              '198'=>'$Fe',              '199'=>'$Ff',              '200'=>'$Fg',
            '201'=>'$Fh',          '202'=>'$Fi',              '203'=>'$Fj',              '204'=>'$Fk',              '205'=>'$Et',
            '206'=>'$Ev',          '207'=>'$Eq',              '208'=>'$Eo',              '209'=>'$Ep',              '210'=>'$Ek',
            '211'=>'$F"',          '212'=>'$Em',              '213'=>'$GZ',              '214'=>'[地図]',             '215'=>'$EV',
            '216'=>'$Ey',          '217'=>'$G?',              '218'=>'$E5',              '219'=>'$G8',              '220'=>'$G5',
            '221'=>'[スノボ]',       '222'=>'$ER',              '223'=>'$ED',              '224'=>'$EC',              '225'=>'$O+',
            '226'=>'$OD',          '227'=>'$Pk',              '228'=>'$Q)',              '229'=>'$ES',              '230'=>'[オメデトウ]',
            '231'=>'$EP',          '232'=>'[ゲーム]',           '233'=>'$EO',              '234'=>'$GS',              '235'=>'$GP',
            '236'=>'$E;',          '237'=>'$Q+',              '238'=>'$Oh',              '239'=>'$Gf',              '240'=>'$Eg',
            '241'=>'[さくらんぼ]',   '242'=>'$G9',              '243'=>'$Og',              '244'=>'$Ob',              '245'=>'$E@',
            '246'=>'$Gt',          '247'=>'$QL',              '248'=>'$G:',              '249'=>'$E)',              '250'=>'$QQ',
            '251'=>'$Go',          '252'=>'$Gu',              '253'=>'[アリ]',             '254'=>'$E+',              '255'=>'$O'."'".'',
            '256'=>'$O%',          '257'=>'$Gw',              '258'=>'$Gy',              '259'=>'$P1',              '260'=>'$P&',
            '261'=>'$E\',          '262'=>'$OT',              '263'=>'$OQ',              '264'=>'$E%',              '265'=>'$GC',
            '266'=>'$OG',          '267'=>'$ON',              '268'=>'$O1',              '269'=>'$E=',              '270'=>'[SOS]',
            '271'=>'$El',          '272'=>'$OI',              '273'=>'$G#',              '274'=>'$E,',              '275'=>'[なると]',
            '276'=>'$QV',          '277'=>'$E:',              '278'=>'[花丸]',             '279'=>'$O5',              '280'=>'[100点]',
            '281'=>'$G-',          '282'=>'$OP',              '283'=>'$Gz',              '284'=>'$G/',              '285'=>'$FF',
            '286'=>'$E<',          '287'=>'$G.',              '288'=>'$EJ',              '289'=>'$G\',              '290'=>'[財布]',
            '291'=>'$OF',          '292'=>'$Ga',              '293'=>'[バイオリン]',       '294'=>'$O*',              '295'=>'$O<',
            '296'=>'$E3',          '297'=>'$O>',              '298'=>'[EZ]',               '299'=>'[FREE]',             '300'=>'$EF',
            '301'=>'$G&',          '302'=>'$E,',              '303'=>'$F3',              '304'=>'$E[',              '305'=>'[霧]',
            '306'=>'$G4',          '307'=>'$PJ',              '308'=>'[ポケベル]',         '309'=>'$Q"',              '310'=>'$Q#',
            '311'=>'[イベント]',     '312'=>'$O4',              '313'=>'$Ok',              '314'=>'$F.',              '315'=>'$F-',
            '316'=>'$F/',          '317'=>'$P9',              '318'=>'$P;',              '319'=>'$G1',              '320'=>'$G2',
            '321'=>'●',             '322'=>'$Gl',              '323'=>'$Gl',              '324'=>'[CL]',               '325'=>'$FE',
            '326'=>'$Fm',          '327'=>'$P&',              '328'=>'$OG',              '329'=>'[ドンッ]',           '330'=>'$OQ',
            '331'=>'[ezplus]',       '332'=>'[地球]',             '333'=>'$O`',              '334'=>'$F2',              '335'=>'$G&',
            '336'=>'$G'."'".'',    '337'=>'$G,',              '338'=>'$EH',              '339'=>'$GR',              '340'=>'$GW',
            '341'=>'$PT',          '342'=>'$G[',              '343'=>'$G^',              '344'=>'$Gn',              '345'=>'$Gp',
            '346'=>'$Gq',          '347'=>'$Gs',              '348'=>'$P%',              '349'=>'$E&',              '350'=>'$P0',
            '351'=>'$E(',          '352'=>'$E*',              '353'=>'$E-',              '354'=>'$E.',              '355'=>'$E1',
            '356'=>'$E6',          '357'=>'$E7',              '358'=>'$E9',              '359'=>'$E>',              '360'=>'$EA',
            '361'=>'$EB',          '362'=>'$EM',              '363'=>'$EN',              '364'=>'$EQ',              '365'=>'[カメ]',
            '366'=>'$Q1',          '367'=>'$Q2',              '368'=>'$EW',              '369'=>'$E_',              '370'=>'$Ec',
            '371'=>'$Ef',          '372'=>'$QC',              '373'=>'$Ej',              '374'=>'$Er',              '375'=>'$Es',
            '376'=>'$Eu',          '377'=>'$Ew',              '378'=>'$Ex',              '379'=>'$F"',              '380'=>'$F'."'".'',
            '381'=>'$F+',          '382'=>'$F4',              '383'=>'$FG',              '384'=>'$FH',              '385'=>'$FI',
            '386'=>'$FJ',          '387'=>'$FK',              '388'=>'$FL',              '389'=>'$FM',              '390'=>'$FN',
            '391'=>'$FO',          '392'=>'$F^',              '393'=>'$Fp',              '394'=>'$Fq',              '395'=>'$O!',
            '396'=>'$O"',          '397'=>'$O#',              '398'=>'$O&',              '399'=>'$O(',              '400'=>'$O+',
            '401'=>'$O,',          '402'=>'$O-',              '403'=>'$O/',              '404'=>'$O0',              '405'=>'$O2',
            '406'=>'[EZナビ]',       '407'=>'$O8',              '408'=>'$O;',              '409'=>'$O=',              '410'=>'$O?',
            '411'=>'$O@',          '412'=>'$OA',              '413'=>'$OB',              '414'=>'$F,',              '415'=>'$OG',
            '416'=>'$OJ',          '417'=>'$OK',              '418'=>'$OL',              '419'=>'$OM',              '420'=>'$ON',
            '421'=>'$G3',          '422'=>'$OR',              '423'=>'$OX',              '424'=>'$OY',              '425'=>'$OZ',
            '426'=>'$O[',          '427'=>'$O\',              '428'=>'$O]',              '429'=>'$O^',              '430'=>'$O_',
            '431'=>'$Oa',          '432'=>'$Oc',              '433'=>'$Od',              '434'=>'$Oe',              '435'=>'$Of',
            '436'=>'$Oi',          '437'=>'$Oj',              '438'=>'$Ol',              '439'=>'$Om',              '440'=>'$P"',
            '441'=>'$P#',          '442'=>'$P$',              '443'=>'$P&',              '444'=>'$P'."'".'',        '445'=>'$P(',
            '446'=>'$P*',          '447'=>'$P+',              '448'=>'$P,',              '449'=>'$P-',              '450'=>'$P.',
            '451'=>'$P0',          '452'=>'$P/',              '453'=>'$OF',              '454'=>'$Gv',              '455'=>'$P7',
            '456'=>'$P8',          '457'=>'$P:',              '458'=>'$P<',              '459'=>'$P=',              '460'=>'$P?',
            '461'=>'$P@',          '462'=>'$PA',              '463'=>'$P>',              '464'=>'$PC',              '465'=>'$PD',
            '466'=>'$PF',          '467'=>'$PE',              '468'=>'$PI',              '469'=>'$Gb',              '470'=>'$PL',
            '471'=>'$PM',          '472'=>'$PP',              '473'=>'$PQ',              '474'=>'$PR',              '475'=>'$PS',
            '476'=>'$PV',          '477'=>'$PX',              '478'=>'$PY',              '479'=>'$PZ',              '480'=>'$P[',
            '481'=>'$P\',          '482'=>'[花嫁]',             '483'=>'$P_',              '484'=>'$P`',              '485'=>'$Pa',
            '486'=>'$Pb',          '487'=>'$Pe',              '488'=>'$Pf',              '489'=>'$Ph',              '490'=>'$Pk',
            '491'=>'$Pl',          '492'=>'$Q!',              '493'=>'$Pi',              '494'=>'$Q#',              '495'=>'$Q$',
            '496'=>'$Q%',          '497'=>'$Q&',              '498'=>'$Q(',              '499'=>'$Q-',              '500'=>'[オープンウェブ]',
            '501'=>'$Ed',          '502'=>'[ABCD]',             '503'=>'[abcd]',             '504'=>'[1234]',             '505'=>'[記号]',
            '506'=>'[可]',           '507'=>'[チェックマーク]',   '508'=>'[ペン]',             '509'=>'[ラジオボタン]',     '510'=>'$E4',
            '511'=>'$FU',          '512'=>'[ブックマーク]',     '513'=>'$E$',              '514'=>'$GV',              '515'=>'$E!',
            '516'=>'$O!',          '517'=>'$Ed',              '518'=>'↑↓',               '700'=>'$Q.',              '701'=>'$Q/',
            '702'=>'$Q0',          '703'=>'$Q3',              '704'=>'$Q4',              '705'=>'$Q5',              '706'=>'$Q6',
            '707'=>'$Q7',          '708'=>'$Q8',              '709'=>'$Q9',              '710'=>'$Q:',              '711'=>'$Q;',
            '712'=>'$Q<',          '713'=>'$Q@',              '714'=>'$Q?',              '715'=>'$QB',              '716'=>'$QE',
            '717'=>'$QF',          '718'=>'$QG',              '719'=>'$QK',              '720'=>'$QM',              '721'=>'$QN',
            '722'=>'$QO',          '723'=>'$QP',              '724'=>'$QR',              '725'=>'$QS',              '726'=>'$QU',
            '727'=>'$QT',          '728'=>'$QV',              '729'=>'$G'."'".'',        '730'=>'[旗]',               '731'=>'$FV',
            '732'=>'$FX',          '733'=>'！？',               '734'=>'！！',               '735'=>'～',                 '736'=>'[メロン]',
            '737'=>'[パイナップル]', '738'=>'[ブドウ]',           '739'=>'[バナナ]',           '740'=>'[とうもろこし]',     '741'=>'[キノコ]',
            '742'=>'[栗]',           '743'=>'[モモ]',             '744'=>'[やきいも]',         '745'=>'[ピザ]',             '746'=>'[チキン]',
            '747'=>'[七夕]',         '748'=>'$Gd',              '749'=>'[辰]',               '750'=>'[ピアノ]',           '751'=>'$G7',
            '752'=>'$G9',          '753'=>'[ボーリング]',       '754'=>'[なまはげ]',         '755'=>'[天狗]',             '756'=>'[パンダ]',
            '757'=>'$P)',          '758'=>'$E+',              '759'=>'$O%',              '760'=>'[アイスクリーム]',   '761'=>'[ドーナツ]',
            '762'=>'[クッキー]',     '763'=>'[チョコ]',           '764'=>'[キャンディ]',       '765'=>'[キャンディ]',       '766'=>'(/_＼)',
            '767'=>'(・×・)',       '768'=>'|(・×・)|',         '769'=>'[火山]',             '770'=>'$OH',              '771'=>'[ABC]',
            '772'=>'[プリン]',       '773'=>'[ミツバチ]',         '774'=>'[てんとう虫]',       '775'=>'[ハチミツ]',         '776'=>'$Oe',
            '777'=>'[飛んでいく金]', '778'=>'$P'."'".'',        '779'=>'$P6',              '780'=>'$P6',              '781'=>'$Pk',
            '782'=>'$P8',          '783'=>'$Gw',              '784'=>'$E#',              '785'=>'$P2',              '786'=>'$P2',
            '787'=>'$E&',          '788'=>'$P#',              '789'=>'$P#',              '790'=>'$P3',              '791'=>'$P3',
            '792'=>'$P$',          '793'=>'$O9',              '794'=>'[モアイ]',           '795'=>'$GY',              '796'=>'[花札]',
            '797'=>'[ジョーカー]',   '798'=>'[エビフライ]',       '799'=>'$E#',              '800'=>'$F!',              '801'=>'$PR',
            '802'=>'[EZムービー]',   '803'=>'$OG',              '804'=>'$QC',              '805'=>'[ジーンズ]',         '806'=>'$E#',
            '807'=>'↑↓',           '808'=>'⇔',                 '809'=>'↑↓',               '810'=>'$P^',              '811'=>'$E0',
            '812'=>'[カタツムリ]',   '813'=>'$P$',              '814'=>'$P$',              '815'=>'[Cメール]',          '816'=>'$E0',
            '817'=>'$G0',          '818'=>'$F0',              '819'=>'$G2',              '820'=>'$PG',              '821'=>'$P#',
            '822'=>'$P6',
        );
        return empty($map[$dec])?'':$map[$dec];
    }
} // emoji_Tag
?>