<?php
/* ========================================================================
 - [htdocs/exec.php]
 -      rktSNS実行処理
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/05/27] フロントコントローラを携帯用と共有
 -      [2006/09/11] 日記からPDFを作成するページ追加
 -      [2006/09/04] コンテンツ一覧、最近の一覧を追加
 -      [2006/08/27] ベーステンプレート読み込みを各クラス内に変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once LIB_DIR.'rkt_session.php';
require_once LIB_DIR.'OpenPNE/KtaiUA.php';

// ------------------------------------------------
// rktSNS実行関数
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function __main()
{
    /* セッションハンドル設定 */
    RKT_session::setSaveHandler();

    /* 携帯判定 */
    $ktaiUA = new OpenPNE_KtaiUA();

    /* 携帯ページ */
    if ($ktaiUA->is_ktai()){
        include_once DOCUMENT_DIR.'mobile.php';
    } else {
        include_once DOCUMENT_DIR.'pc.php';
    }

    /* フロントコントローラ実行 */
    __controller();
}
__main();    // rktSNS実行
?>
