<?php
/* ========================================================================
 - [modules/public/content/browse.php]
 -      コンテンツ記事閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * ページ名
     * @var string
     */
    var $origin = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/content/browse.tpl');
        
        /* PathInfoによる引数の取得 */
        $this->setPathInfo('origin',0,'string');
        $this->Assign('origin', $this->origin);

        $this->set_content();
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     **/
    function set_content()
    {
        $now = date('Y-m-d');
        $sql = 
            'SELECT '.
                'id,'.
                'modify,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "open_date <= '".$now."' AND ".
                "origin='".$this->origin."' ";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $subject = empty($result['subject'])?'コンテンツ':$result['subject'];
        $this->baseAssign('title', $result['subject']);
        $this->Assign('item', $result);
    }
} // webapp
?>
