<?php
/* ========================================================================
 - [modules/friend/review/review.php]
 -      投稿レビュー一覧表示
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('friend/show/review.tpl');

        $this->set_review();
        $this->set_category();
        $this->set_list();

        $this->doFootprint();
    }

    /**
     * レビュー情報の設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $sql=
            'SELECT '.
                'count(id) as post,'.
                'sum(point) as total '.
            'FROM '.
                DB_PREFIX.'rev_review '.
            'WHERE '.
                'ref_account = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (!empty($result['post'])){
            $result['avg'] = $result['total']/$result['post'];
            $result['point'] = round($result['avg'],0);
        }

        $this->Assign('review', $result);
    }

    /**
     * カテゴリリストの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'rev_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys', $list);
    }

    /**
     * レビューリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = empty($_REQUEST['offset'])?0:$_REQUEST['offset'];
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_REVIEW);

        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.url as url,'.
                'itm.asin as asin,'.
                'itm.name as name,'.
                'itm.ref_category as ref_category,'.
                'itm.creator as creator,'.
                'itm.manufacturer as manufacturer,'.
                'itm.imagemedium as imagemedium,'.
                'itm.listprice as listprice,'.
                'itm.post as post,'.
                'cat.category as category,'.
                'rev.modify as modify,'.
                'rev.ref_account as ref_account,'.
                'rev.point as point,'.
                'rev.comment as comment '.
            'FROM '.
                DB_PREFIX.'rev_category cat,'.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'cat.id = itm.ref_category AND '.
                'itm.id = rev.ref_item AND '.
                'rev.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'rev.modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $result = empty($result)?array():$result;

        $this->Assign('list', $result);
    }
} // webapp
?>
