<?php
/* ========================================================================
 - [webapp/libs/sendmail.php]
 -      WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * sendmailクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_webapp
 * @access public
 * @version 1.0
 */
class sendmail
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * コード
     * @var string
     */
    var $code = '';

    /**
     * メール本文
     * @var string
     */
    var $body = '';

    /**
     * 置換変数
     * @var array
     */
    var $assign = array();

    /**
     * コンストラクタ
     *
     * @access public
     */
    function sendmail($code)
    {
        $this->objdb = RKT_db::getInstance();
        
        $this->code = $code;
        
        if (defined('WAP_SYSTEM_NAME')){
            $this->assign['site_name'] = WAP_SYSTEM_NAME;
            $this->assign['footer'] = 
                '============================================'."\n".
                '「'.WAP_SYSTEM_NAME.'」事務局'."\n".
                'このメールに心当たりのない方はお手数ですが'."\n".
                '本メールを破棄してください。'."\n".
                "\n".
                'お問い合わせ先'."\n".
                '  '.WAP_ADMINISTRATOR."\n".
                '  '.BASE_URL.' '."\n".
                '============================================'."\n";
        }
        $this->setMailInfo($this->code);
    }

    /**
     * フッター情報の設定
     *
     * @access public
     * @param string $system_name
     * @param string $email
     * @param string $base_url
     * @return array
     */
    function setFooter($system_name,$email,$base_url)
    {
        $this->assign['site_name'] = $system_name;
        $this->assign['footer'] = 
            '============================================'."\n".
            '「'.$system_name.'」事務局'."\n".
            'このメールに心当たりのない方はお手数ですが'."\n".
            '本メールを破棄してください。'."\n".
            "\n".
            'お問い合わせ先'."\n".
            '  '.$email."\n".
            '  '.$base_url.' '."\n".
            '============================================'."\n";
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param string $key
     * @param mixed $value
     * @return void
     */
    function Assign($key,$value)
    {
        $this->assign[$key] = $value;
    }

    /**
     * 会員登録用メール設定の取得
     *
     * @access public
     * @return array
     */
    function setMailInfo($code)
    {
        $sql=
            'SELECT '.
                'email,'.
                'name,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'sys_mailtpl '.
            'WHERE '.
                "code = '".$this->code."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->mails = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
    }

    /**
     * 会員登録用メール設定の取得
     *
     * @access private
     * @return string
     */
    function id2email($id)
    {
        $sql=
            'SELECT '.
                'email '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['email'])?'':sql_query::decrypt($result['email']);
    }

    /**
     * メール本文の作成・取得
     *
     * @access private
     * @return string  メール本文
     */
    function build_body()
    {
        $body = $this->mails['body'];

        /* 変数の設定  2次元配列まで有効 */
        $body = preg_replace('/{\$(\w+)\.(\w+)\}/', "<?php echo \$this->assign['\\1']['\\2']; ?>", $body);
        $body = preg_replace('/{\$(\w+)\}/', "<?php echo \$this->assign['\\1']; ?>", $body);

        /* foreachの設定 変数のキーは「_row」で決めうち */
        $body = preg_replace('/{foreach \$(\w+)}/', "<?php \$_ary = \$this->assign['\\1'];\r\nforeach (\$_ary as \$this->assign['_row']): ?>", $body);
        $body = preg_replace('/{\/foreach}/', "<?php endforeach; unset(\$_ary); ?>", $body);

        /* emptyによるif文の設定 */
        $body = preg_replace('/{empty \$(\w+)}/', "<?php if (!empty(\$this->assign['\\1'])): ?>", $body);
        $body = preg_replace('/{\/empty}/', "<?php endif; ?>", $body);

		ob_start();
        @eval('?>'. $body);
		$this->body = ob_get_contents();
		ob_end_clean();
    }

    /**
     * メール送信実行
     *
     * @access public
     * @param integer|string $to
     * @return integer  送信結果
     */
    function send($to, $subject=null)
    {
        if (is_integer($to)){
            $to = $this->id2email($to);
        }
        $subject   = empty($subject)?$this->mails['subject']:$subject;
        $subject   = '['.WAP_SYSTEM_NAME.']'.$subject;
        $from      = $this->mails['email'];
        $from_name = $this->mails['name'];

        // 送信元ヘッダー作成
        $from_name = mb_convert_encoding($from_name, 'ISO-2022-JP', ENCODE_TYPE);
        $from_name = mb_encode_mimeheader($from_name,'ISO-2022-JP', 'Q');

        // ヘッダー追加
        $header  = "From: \"".$from_name."\" <".$from.">\n";
        $header .= 'Return-Path: <'.$from.'>'."\n";

        // メール本文の構築
        $this->build_body();

        // メール送信
        return mb_send_mail($to, $subject, $this->body, $header);
    }
}
// sendmailの終了
?>
