<?php
/* ========================================================================
 - [htdocs/mobile.php]
 -      携帯用のFront Controller
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/22] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
include_once BASE_DIR.'mobapp'.DIRECTORY_SEPARATOR.'wap_config.php';

define('WAP_DEFAULT_NUMBER', 5);

/**
 * セッションの開始
 *
 * @access public
 * @return void
 */
function __session_start()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args   = explode('/',$path_info);
    $session_id = empty($args[4])?null:$args[4];

    if (!preg_match('/'.SESSION_ID_PREFIX.'\w+/',$session_id)){
        $session_id = null;
    }
    if (empty($session_id)){
        $session_id = SESSION_ID_PREFIX.md5(time().$_SERVER['HTTP_USER_AGENT']);
    }

    include_once RKT_INCLUDE_ACCOUNT;
    $func = array(RKT_ACCOUNT_CLASS, 'getInstance');
    $objact = call_user_func($func, $session_id);
}

/**
 * ログイン処理
 *
 * @access public
 * @param reference $group
 * @param reference $module
 * @param reference $page
 * @return boolean
 */
function __login_action(&$group,&$module,&$page)
{
    if ($page != 'login'){
        return true;
    }
    include_once LIB_DIR.'rkt_auth.php';

    $objauth = new RKT_auth();
    if (!$objauth->logIn()){
        $group  = 'public';
        $module = 'login';
        $page   = 'entrance';
        $_GET['mismatch'] = 1;
        return false;
    }

    $group  = 'private';
    $module = 'home';
    $page   = 'menu';

    if (!empty($_REQUEST['url'])){
        header('Location: '.$_REQUEST['url']);
        exit();
    }
    
    return true;
}

// ------------------------------------------------
// フロントコントローラー
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function __controller()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

    $args   = explode('/',$path_info);
    $group  = empty($args[1])?'public':$args[1];
    $module = empty($args[2])?'content':$args[2];
    $page   = empty($args[3])?$module:$args[3];

    __session_start();                      // セッションの開始
    __login_action($group,$module,$page);   // ログイン処理

    $titles = array (
        'admin'=>   array(
            'account'=>     array(      // アカウント管理
                'exit'=>        '退会処理',
                'mails'=>       'メール配信',
                'profile'=>     'プロフィール',
                'result'=>      '会員検索結果',
                'search'=>      '会員検索',
                'sendmail'=>    '配信メール送信',
            ),
            'design'=>      array(      // デザイン設定
                'css'=>         'スタイルシート編集',
                'design'=>      'デザイン設定',
                'list'=>        'テーマ一覧',
                'preview'=>     'デザイン画像表示',
                'theme'=>       'デザインテーマ編集',
                'upload'=>      'テーマ素材アップロード',
            ),
            'environment'=> array(      // 環境設定
                'account'=>     'スタイルシート編集',
                'config'=>      'デザイン設定',
            ),
            'inquire'=>     array(      // お問合せ
                'list'=>        '問合せ一覧',
                'sendmail'=>    '問合せ返信メール',
            ),
            'item'=>        array(      // コンテンツ記事
                'category'=>    'コンテンツカテゴリ',
                'image_list'=>  'TinyMCE用画像リスト',
                'item'=>        'コンテンツ記事編集',
                'link_list'=>   'TinyMCE用リンクリスト',
                'list'=>        'コンテンツ記事一覧',
                'options'=>     '質問選択肢',
                'upload'=>      'コンテンツ添付ファイルアップロード',
            ),
            'mail'=>        array(      // 配信メールテンプレート
                'list'=>        '自動メール定型文一覧',
                'mail'=>        '自動メール定型文'
             ),
            'master'=>      array(      // マスターテーブル
                'com_category'=>'コミュニティカテゴリ',
                'com_genre'=>   'コミュニティジャンル',
                'frm_category'=>'フォーラムカテゴリ',
                'frm_genre'=>   'フォーラムジャンル',
                'inquire'=>     '問合せカテゴリ',
                'married'=>     '結婚マスター',
                'review'=>      'レビューカテゴリ',
                'sys_sort'=>    '各一覧ページ並び順(ORDER BY句)定義'
             ),
            'profile'=>     array(      // プロフィール
                'enquete'=>     'プロフィール追加項目編集',
                'enquetes'=>    'プロフィール項目一覧',
                'items'=>       'アンケート選択肢一覧',
            ),
            'sponsor'=>     array(      // スポンサー
                'list'=>        'スポンサーバナー一覧',
                'sponsor'=>     'スポンサーバナー編集',
            ),
        ), /* 管理者ページ */
        'community'=>   array(
            'bbs'=>         array(      // トピック、イベント
                'browse'=>      'トピック参照',
                'comment'=>     'コメントを書き込む',
                'entrys'=>      'イベント参加メンバー一覧',
                'event'=>       '新しいイベントを作成する',
                'list'=>        'トピック一覧',
                'send'=>        'イベント参加者へメッセージ送信',
                'topic'=>       '新しいトピックを作成する',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   'コミュニティ基礎情報',
                'entry'=>       'コミュニティに参加',
                'exit'=>        'コミュニティの退会',
                'intro'=>       '友達に紹介する',
                'names'=>       'コミュニティ参加名簿',
            ),
            'search'=>      array(      // コミュニティ検索
                'event'=>       'イベント検索結果',
                'result'=>      'コミュニティ検索結果',
                'schedule'=>    'イベント検索',
                'search'=>      'コミュニティ検索',
            ),
            'show'=>        array(      // コミュニティ情報閲覧
                'calendar'=>    'コミュニティイベントカレンダー',
                'community'=>   'コミュニティ情報',
                'member'=>      'メンバー一覧',
                'menu'=>        'コミュニティメニュー',
            ),
        ), /* コミュニティページ */
        'friend'=>   array(
            'diary'=>       array(      // 友達日記
                'comment'=>     'コメントを書く',
                'comments'=>    'コメント一覧',
                'entry'=>       '記事閲覧',
                'list'=>        '日記一覧',
                'result'=>      '日記検索結果',
                'search'=>      '日記検索',
            ),
            'edit'=>        array(      // 各種編集
                'favorite'=>    'お気に入り追加',
                'intro'=>       '紹介文編集',
                'message'=>     'メッセージを送る',
                'relation'=>    '友達追加',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'トピック参照',
                'comment'=>     'コメントを書き込む',
                'list'=>        'トピック一覧',
                'result'=>      'トピック検索結果',
                'search'=>      'トピック検索',
            ),
            'search'=>      array(      // 友達検索
                'result'=>      '友達検索結果',
                'search'=>      '友達検索',
            ),
            'show'=>        array(      // 友達情報閲覧
                'community'=>   'コミュニティ一覧',
                'friends'=>     '友達一覧',
                'intro'=>       '紹介文一覧',
                'menu'=>        'お友達メニュー',
                'photo'=>       '写真一覧',
                'profile'=>     'プロフィール',
                'recent'=>      '各種一覧表示',
                'review'=>      '投稿レビュー一覧表示',
            ),
         ), /* 友達ページ */
        'private'=>   array(
            'account'=>     array(      // 会員情報
                'account'=>     '会員基礎情報',
                'autologin'=>   '自動ログイン登録',
                'exit'=>        '退会処理',
                'passwd'=>      'パスワード変更',
            ),
            'content'=>     array(      // コンテンツ閲覧
                'browse'=>      'コンテンツ記事閲覧',
                'inquire'=>     '問合せフォーム',
                'list'=>        'お知らせ一覧',
                'question'=>    'アンケート結果',
            ),
            'diary'=>       array(      // 日記
                'category'=>    'カテゴリ',
                'comment'=>     'コメントを書く',
                'comments'=>    'コメント一覧',
                'diary'=>       '日記設定',
                'entry'=>       '記事閲覧',
                'list'=>        '日記一覧',
                'post'=>        '日記記事投稿',
            ),
            'edit'=>        array(      // 各種編集
                'community'=>   '参加コミュニティ一覧',
                'friend'=>      '友達リスト管理',
                'photo'=>       '写真編集',
                'profile'=>     'プロフィール編集',
                'relation'=>    '各種認証',
                'schedule'=>    'スケジュール編集',
            ),
            'forum'=>       array(      // フォーラム
                'browse'=>      'トピック閲覧',
                'comment'=>     'コメントを書き込む',
                'list'=>        'トピック一覧',
                'response'=>    '返事を書く',
                'topic'=>       'トピック編集',
            ),
            'home'=>        array(      // Myホーム
                'home'=>        'Myホーム',
                'menu'=>        'Myホーム',
                'invite'=>      '友達招待フォーム',
                'search'=>      '各種検索',
            ),
            'message'=>     array(      // メッセージ
                'browse'=>      'メッセージ閲覧',
                'list'=>        'メッセージボックス',
                'send'=>        'メッセージを送る',
            ),
            'review'=>      array(      // レビュー
                'browse'=>      '商品レビュー閲覧',
                'item'=>        'レビュー対象商品検索',
                'list'=>        '投稿レビュー一覧表示',
                'post'=>        'レビュー投稿',
                'search'=>      '投稿レビュー検索',
            ),
            'show'=>        array(      // 各種閲覧
                'calendar'=>    'カレンダー',
                'favorite'=>    'お気に入り',
                'footprint'=>   'あしあと',
                'friends'=>     '友達一覧',
                'intro'=>       '紹介文一覧',
                'profile'=>     'プロフィール確認',
                'schedule'=>    'スケジュール確認',
            ),
        ), /* プライベートページ */
        'public'=>   array(
            'content'=>     array(      // コンテンツ記事
                'browse'=>      'コンテンツ記事閲覧',
                'default'=>     WAP_SYSTEM_NAME,
                'inquire'=>     '問合せフォーム',
            ),
            'login'=>       array(      // ログイン
                'entrance'=>    'ログインフォーム',
                'exit'=>        '退会ページ',
                'login'=>       'ログイン',
                'logout'=>      'ログアウト',
                'reissue'=>     'パスワードの再発行',
            ),
            'registry'=>    array(      // 会員登録
                'account'=>     '会員登録フォーム',
                'confirm'=>     '入力内容確認',
                'invite'=>      '自動招待フォーム',
                'registry'=>    '会員登録',
                'sendmail'=>    '会員登録確認メール発送',
            ),
        ), /* 一般公共ページ */
    );

    /* デフォルト読み込みモジュール */
    $include = 'public/content/default.php';
    /* テンプレートファイルの読み込み */
    if (empty($titles[$group][$module][$page])){
        $group  = 'public';
        $module = 'content';
        $page   = 'default';
    }
    $include = $group.'/'.$module.'/'.$page.'.php';

    include_once MODULE_DIR.$include;

    header('Content-Type: text/html; charset=Shift_JIS');
    $obj_webapp = new webapp();
    $obj_webapp->setTemplateBase('base.tpl');
    $obj_webapp->baseAssign('title', $titles[$group][$module][$page]);
    $obj_webapp->execute();
    $obj_webapp->display();

    if (DEBUG_ENV == 1){
        echo "<div id=\"left\">\n";
        echo "<pre style=\"text-align:left;\">".print_r($_REQUEST,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_SESSION,true)."</pre>";
        echo "<pre style=\"text-align:left;\">".print_r($_COOKIE,true)."</pre>";
        echo "</div>\n";
    }
}
?>
