-- ========================================================================
-- [sqls/sqlite.sql]
-- 		SQLite用テーブル定義
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--      [2007/02/02] 日記の未読コメントflagを追加
--      [2007/01/30] メッセージの添付画像(sns_fri_picture)を追加
--      [2007/01/21] お友達のお友達名簿を修正
--      [2007/01/21] お友達の招待名簿を追加
--      [2006/09/17] インデックスの記述を消去
--      [2006/09/16] デザインテーマの修正 背景の追加
--      [2006/09/11] 印刷用テーブルの追加
--      [2006/07/10] 作成
-- ========================================================================

BEGIN TRANSACTION;

-- --------------------------------------------------------
-- 
-- セッション管理
-- 
CREATE TABLE 'sns_sys_sessions' (
  'id' varchar(128) NOT NULL,
  'life_time' integer unsigned,
  'sess_data' text,
  PRIMARY KEY (id)
);

-- 
-- メール設定
-- 
CREATE TABLE 'sns_sys_mail' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'status' integer NOT NULL,
  'mailing' integer NOT NULL,
  'from_mail' varchar(128) NOT NULL,
  'from_name' varchar(128) NOT NULL,
  'subject' varchar(255) NOT NULL,
  'body' text NOT NULL,
  'condition' text,
  PRIMARY KEY  ('id')
);

-- 
-- 返信メールのテンプレート設定
-- 
CREATE TABLE 'sns_sys_mailtpl' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'code' varchar(128) NOT NULL,
  'subject' varchar(128) NOT NULL,
  'email' varchar(128) NOT NULL,
  'name' varchar(128) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('code')
);

-- 
-- 各種一覧のソート設定
-- 
CREATE TABLE 'sns_sys_sort' (
  'id' integer NOT NULL,
  'ref_category' integer NOT NULL,
  'sort' integer NOT NULL,
  'label' varchar(64) NOT NULL,
  'direction' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- スポンサー設定
-- 
CREATE TABLE 'sns_sys_sponsor' (
  'id' integer NOT NULL,
  'avail' integer NOT NULL,
  'position' integer NOT NULL,
  'sponsor' varchar(128) NOT NULL,
  'html' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- システムデザイン
-- 
CREATE TABLE 'sns_sys_design' (
  'id' integer NOT NULL,
  'ref_common' integer NOT NULL,
  'ref_admin' integer NOT NULL,
  'ref_private' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_public' integer NOT NULL,
  'frame_width' integer NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- デザインテーマ
-- 
CREATE TABLE 'sns_des_theme' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'theme' varchar(128) NOT NULL,
  'round' varchar(6) NOT NULL,
  'box' varchar(6) NOT NULL,
  'border' varchar(6) NOT NULL,
  'text' varchar(6) NOT NULL,
  'column' varchar(6) NOT NULL,
  'button' varchar(6) NOT NULL,
  'focus' varchar(6) NOT NULL,
  'header' varchar(6) NOT NULL,
  'background' varchar(6) NOT NULL,
  PRIMARY KEY  ('id')
);

-- --------------------------------------------------------
-- 
-- 地域情報
-- 
CREATE TABLE 'sns_ara_area' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'area' varchar(32) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 都道府県マスター情報
-- 
CREATE TABLE 'sns_ara_prefecture' (
  'id' integer NOT NULL,
  'ref_area' integer NOT NULL,
  'sort' integer NOT NULL,
  'prefecture' varchar(16) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 市区町村情報
-- 
CREATE TABLE 'sns_ara_local' (
  'id' integer NOT NULL,
  'ref_prefecture' integer NOT NULL,
  'sort' integer NOT NULL,
  'local' varchar(64) NOT NULL,
  PRIMARY KEY  ('id')
);

-- --------------------------------------------------------
-- 
-- 会員アカウント情報
-- 
CREATE TABLE 'sns_act_account' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'last_login' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'avail' integer,
  'status' integer NOT NULL,
  'password' varchar(32) NOT NULL,
  'email' blob NOT NULL,
  'email_hash' varchar(32),
  'cellular' blob,
  'cellular_hash' varchar(32),
  'news' integer,
  'mailing' integer,
  'footprint' integer default '0',
  'total' integer default '0',
  'friend_number' integer default '0',
  'block' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('email_hash'),
  UNIQUE ('cellular_hash')
);

-- 
-- 会員自動ログイン
-- 
CREATE TABLE 'sns_act_autologin' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'loginkey' varchar(32),
  PRIMARY KEY  ('id'),
  UNIQUE ('loginkey')
);

-- 
-- 会員退会情報
-- 
CREATE TABLE 'sns_act_exit' (
  'id' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'reason' text,
  PRIMARY KEY  ('id')
);

-- 
-- 血液型マスター情報
-- 
CREATE TABLE 'sns_act_blood' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'blood' varchar(16) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 結婚マスター情報
-- 
CREATE TABLE 'sns_act_married' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'married' varchar(64) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 性別マスター情報
-- 
CREATE TABLE 'sns_act_sex' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'sex' varchar(16) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 会員プロフィール
-- 
CREATE TABLE 'sns_act_profile' (
  'id' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'first_name' blob NOT NULL,
  'second_name' blob NOT NULL,
  'name_flag' integer NOT NULL,
  'nickname' varchar(128) NOT NULL,
  'visibility' integer NOT NULL,
  'ref_prefecture' integer NOT NULL,
  'ref_local' integer,
  'prefecture_flag' integer NOT NULL,
  'ref_sex' integer NOT NULL,
  'sex_flag' integer NOT NULL,
  'ref_blood' integer NOT NULL,
  'blood_flag' integer NOT NULL,
  'birthday' date NOT NULL,
  'birthday_flag' integer NOT NULL,
  'age_flag' integer NOT NULL,
  'ref_married' integer NOT NULL,
  'married_flag' integer,
  'ref_hometown' integer,
  'ref_homelocal' integer,
  'hometown_flag' integer,
  'publicity' text,
  PRIMARY KEY  ('id')
);

-- 
-- 会員アンケート
-- 
CREATE TABLE 'sns_act_enquete' (
  'id' integer NOT NULL,
  'required' integer NOT NULL,
  'visibility' integer NOT NULL,
  'form_type' integer NOT NULL,
  'validate'  varchar(32) NOT NULL,
  'format'  varchar(64),
  'max_length' integer,
  'min_length' integer,
  'sort' integer NOT NULL,
  'enquete' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- アンケート項目
-- 
CREATE TABLE 'sns_act_item' (
  'id' integer NOT NULL,
  'ref_enquete' integer NOT NULL,
  'sort' integer NOT NULL,
  'item' varchar(255) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- アンケートの入力内容
-- 
CREATE TABLE 'sns_act_content' (
  'id' integer NOT NULL,
  'ref_enquete' integer NOT NULL,
  'ref_item' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'visibility' integer,
  'content' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_enquete','ref_item','ref_account')
);

-- 
-- アンケートの選択
-- 
CREATE TABLE 'sns_act_select' (
  'ref_enquete' integer NOT NULL,
  'ref_item' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'visibility' integer,
  UNIQUE ('ref_enquete','ref_item','ref_account')
);

-- 
-- 会員写真
-- 
CREATE TABLE 'sns_act_photo' (
  'id' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'status' integer,
  'subject' varchar(255),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);

-- --------------------------------------------------------
-- 
-- カレンダースケジュール
-- 
CREATE TABLE 'sns_cal_schedule' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'schedule' varchar(255) NOT NULL,
  'start_date' date,
  'end_date' date,
  'start_hour' varchar(4),
  'start_minute' varchar(4),
  'end_hour' varchar(4),
  'end_minute' varchar(4),
  'comment' text,
  'mail_flag' integer,
  PRIMARY KEY  ('id')
);


-- --------------------------------------------------------
-- 
-- 日記基礎情報
-- 
CREATE TABLE 'sns_dia_diary' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'visibility' integer,
  'type' integer,
  'url' varchar(255),
  'rss' varchar(255),
  PRIMARY KEY  ('id')
);

-- 
-- 日記の投稿記事
-- 
CREATE TABLE 'sns_dia_entry' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_diary' integer NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'visibility' integer NOT NULL,
  'format' integer NOT NULL,
  'post' integer default '0',
  'link' varchar(255),
  'subject' varchar(255) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_diary','link')
);

-- 
-- 日記カテゴリ
-- 
CREATE TABLE 'sns_dia_category' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_diary' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'sort' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 日記カテゴリ選択
-- 
CREATE TABLE 'sns_dia_select' (
  'ref_diary' integer NOT NULL,
  'ref_category' integer NOT NULL,
  'ref_entry' integer NOT NULL,
  UNIQUE ('ref_diary','ref_category','ref_entry')
);

-- 
-- 日記へのコメント
-- 
CREATE TABLE 'sns_dia_comment' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_diary' integer NOT NULL,
  'ref_entry' integer NOT NULL,
  'ref_account' integer,
  'flag' integer default '1',  
  'subject' varchar(255) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 日記の添付画像
-- 
CREATE TABLE 'sns_dia_picture' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_entry' integer,
  'title' varchar(255),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);

-- 
-- 色パレット
-- 
CREATE TABLE 'sns_dia_color' (
  'id' integer NOT NULL,
  'color' varchar(32),
  'rgb' varchar(6),
  PRIMARY KEY  ('id')
);

-- 
-- フォント
-- 
CREATE TABLE 'sns_dia_font' (
  'id' integer NOT NULL,
  'font' varchar(32),
  'label' varchar(64),
  PRIMARY KEY  ('id')
);

-- 
-- 本・印刷
-- 
CREATE TABLE 'sns_dia_book' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_diary' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_font' integer NOT NULL,
  'ref_subject_color' integer NOT NULL,
  'ref_body_color' integer NOT NULL,
  'ref_line_color' integer NOT NULL,
  'start_date' date,
  'end_date' date,
  'comment_flag' integer NOT NULL,
  'created' integer default '0',
  'subject' varchar(255) NOT NULL,
  'comment' text,
  PRIMARY KEY  ('id')
);

-- 
-- 本カテゴリ選択
-- 
CREATE TABLE 'sns_dia_bookselect' (
  'ref_diary' integer NOT NULL,
  'ref_category' integer NOT NULL,
  'ref_book' integer NOT NULL,
  UNIQUE ('ref_diary','ref_category','ref_book')
);

-- --------------------------------------------------------
-- 
-- お友達のお友達名簿
-- 
CREATE TABLE 'sns_fri_friends' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'avail' integer,
  'status' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  'comment' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_account','ref_friend')
);

-- 
-- お友達の招待名簿
-- 
CREATE TABLE 'sns_fri_invite' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer,
  'email' blob  NOT NULL,
  'email_hash' varchar(32),
  'comment' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('email_hash')
);

-- 
-- お友達のアクセスログ
-- 
CREATE TABLE 'sns_fri_accesslog' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  'unique_flag' integer NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- お友達の足跡
-- 
CREATE TABLE 'sns_fri_footprint' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- お友達のお気に入り
-- 
CREATE TABLE 'sns_fri_favorite' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_account','ref_friend')
);

-- 
-- お友達の紹介
-- 
CREATE TABLE 'sns_fri_intro' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_friend' integer NOT NULL,
  'relation' varchar(128),
  'comment' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_account','ref_friend')
);

-- 
-- お友達からのメッセージ
-- 
CREATE TABLE 'sns_fri_message' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'status' integer,
  'ref_account' integer NOT NULL,
  'ref_to' integer NOT NULL,
  'ref_from' integer NOT NULL,
  'ref_message' integer,
  'flag' integer,
  'subject' varchar(128) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- メッセージの添付画像
-- 
CREATE TABLE 'sns_fri_picture' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_message' integer,
  'title' varchar(255),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);

-- --------------------------------------------------------
-- 
-- フォーラムトピック
-- 
CREATE TABLE 'sns_frm_topic' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'visibility' integer,
  'deadline' date,
  'ref_prefecture' integer,
  'ref_sex' integer,
  'ref_blood' integer,
  'low_age' integer,
  'high_age' integer,
  'ref_married' integer,
  'ref_hometown' integer,
  'post' integer default '0',
  'topic' varchar(255) NOT NULL,
  'comment' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- フォーラムのジャンル
-- 
CREATE TABLE 'sns_frm_genre' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'genre' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- フォーラムのカテゴリ
-- 
CREATE TABLE 'sns_frm_category' (
  'id' integer NOT NULL,
  'ref_genre' integer NOT NULL,
  'sort' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- フォーラムの選択内容
-- 
CREATE TABLE 'sns_frm_select' (
  'ref_topic' integer NOT NULL,
  'ref_category' integer NOT NULL,
  'number' integer,
  UNIQUE ('ref_topic','ref_category')
);

-- 
-- フォーラムコメント
-- 
CREATE TABLE 'sns_frm_comment' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_topic' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'comment' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- フォーラムのコメント返信
-- 
CREATE TABLE 'sns_frm_response' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_topic' integer NOT NULL,
  'ref_comment' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'point' integer,
  'comment' text NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_topic','ref_comment','ref_account')
);

-- 
-- フォーラム用画像
-- 
CREATE TABLE 'sns_frm_picture' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_relation' integer,
  'status' integer,
  'title' varchar(255),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);


-- --------------------------------------------------------
-- 
-- コミュニティのジャンル
-- 
CREATE TABLE 'sns_com_genre' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'genre' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- コミュニティのカテゴリ
-- 
CREATE TABLE 'sns_com_category' (
  'id' integer NOT NULL,
  'ref_genre' integer NOT NULL,
  'sort' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- コミュニティの情報
-- 
CREATE TABLE 'sns_com_community' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'avail' integer,
  'visibility' integer NOT NULL,
  'topic_flag' integer NOT NULL,
  'community' varchar(128) NOT NULL,
  'ref_prefecture' integer NOT NULL,
  'url' varchar(128),
  'publicity' text NOT NULL,
  'total' integer,
  PRIMARY KEY  ('id')
);

-- 
-- 選択カテゴリ
-- 
CREATE TABLE 'sns_com_select' (
  'ref_category' integer NOT NULL,
  'ref_community' integer NOT NULL,
  UNIQUE ('ref_category','ref_community')
);

-- 
-- コミュニティの名簿
-- 
CREATE TABLE 'sns_com_names' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'status' integer,
  'comment' text,
  PRIMARY KEY  ('id')
);

-- 
-- コミュニティのトピック
-- 
CREATE TABLE 'sns_com_topic' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_community' integer NOT NULL,
  'start_date' date NOT NULL,
  'deadline' date,
  'start_hour' varchar(4),
  'start_minute' varchar(4),
  'status' integer,
  'ref_account' integer NOT NULL,
  'ref_prefecture' integer NOT NULL,
  'ref_local' integer,
  'sub_locale' varchar(255),
  'topic' varchar(255) NOT NULL,
  'comment' text NOT NULL,
  'post' integer default '0',
  PRIMARY KEY  ('id')
);

-- 
-- コミュニティのコメント
-- 
CREATE TABLE 'sns_com_comment' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_topic' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'comment' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- コミュニティのイベント参加
-- 
CREATE TABLE 'sns_com_entry' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_topic' integer NOT NULL,
  'ref_account' integer NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_community','ref_topic','ref_account')
);

-- 
-- アンケートオプション
-- 
CREATE TABLE 'sns_com_option' (
  'id' integer NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_topic' integer NOT NULL,
  'sort' integer NOT NULL,
  'item' varchar(255) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- アンケートの選択結果
-- 
CREATE TABLE 'sns_com_itmselect' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_community' integer NOT NULL,
  'ref_topic' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_option' integer NOT NULL,
  'comment' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_topic','ref_account','ref_option')
);

-- 
-- コミュニティの画像
-- 
CREATE TABLE 'sns_com_picture' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_community' integer,
  'ref_account' integer NOT NULL,
  'ref_relation' integer,
  'status' integer,
  'title' varchar(255),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);


-- --------------------------------------------------------
-- 
-- 問合せカテゴリのマスター情報
-- 
CREATE TABLE 'sns_inq_category' (
  'id' integer NOT NULL,
  'sort' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- 問合せ内容
-- 
CREATE TABLE 'sns_inq_inquire' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_category' integer,
  'ref_account' integer,
  'status' integer NOT NULL,
  'name' varchar(128) NOT NULL,
  'url' varchar(128),
  'email' blob,
  'comment' text NOT NULL,
  'subject' varchar(255) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id')
);

-- --------------------------------------------------------
-- 
-- システムからの記事　カテゴリマスター情報
-- 
CREATE TABLE 'sns_itm_category' (
  'id' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  'sort' integer,
  PRIMARY KEY  ('id')
);

-- 
-- システムからの記事
-- 
CREATE TABLE 'sns_itm_item' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'avail' integer NOT NULL,
  'ref_category' integer NOT NULL,
  'open_date' date NOT NULL,
  'close_date' date,
  'deadline' date,
  'origin' varchar(64),
  'subject' varchar(255) NOT NULL,
  'body' text NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('origin')
);

-- 
-- アンケートオプション
-- 
CREATE TABLE 'sns_itm_option' (
  'id' integer NOT NULL,
  'ref_item' integer NOT NULL,
  'sort' integer NOT NULL,
  'item' varchar(255) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- アンケートの選択結果
-- 
CREATE TABLE 'sns_itm_select' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'regist_date' timestamp NOT NULL,
  'ref_item' integer NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_option' integer NOT NULL,
  'comment' text,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_item','ref_account','ref_option')
);

-- 
-- システムからの記事　ファイルアップ
-- 
CREATE TABLE 'sns_itm_fileinfo' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_category' integer NOT NULL,
  'subject' varchar(255) NOT NULL,
  'mimetype' varchar(64),
  'filename' varchar(255),
  'width' integer,
  'height' integer,
  'thumbnail' varchar(255),
  't_width' integer,
  't_height' integer,
  PRIMARY KEY  ('id')
);


-- --------------------------------------------------------
-- 
-- レビュー　カテゴリマスター情報
-- 
CREATE TABLE 'sns_rev_category' (
  'id' integer NOT NULL,
  'type' integer NOT NULL,
  'sort' integer NOT NULL,
  'category' varchar(128) NOT NULL,
  'code' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- レビューの対象商品
-- 
CREATE TABLE 'sns_rev_item' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_category' integer NOT NULL,
  'total' float,
  'post' integer default '0',
  'url' varchar(255) NOT NULL,
  'asin' varchar(128) NOT NULL,
  'name' text NOT NULL,
  'creator' text NOT NULL,
  'release' varchar(32) NOT NULL,
  'manufacturer' varchar(255) NOT NULL,
  'imagesmall' varchar(255) NOT NULL,
  'imagemedium' varchar(255) NOT NULL,
  'imagelarge' varchar(255) NOT NULL,
  'listprice' varchar(64) NOT NULL,
  'ourprice' varchar(64) NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('asin')
);

-- 
-- レビューの結果ポイントマスター情報
-- 
CREATE TABLE 'sns_rev_point' (
  'id' integer NOT NULL,
  'point' integer NOT NULL,
  'sort' integer NOT NULL,
  'label' varchar(128) NOT NULL,
  PRIMARY KEY  ('id')
);

-- 
-- レビュー内容
-- 
CREATE TABLE 'sns_rev_review' (
  'id' integer NOT NULL,
  'modify' timestamp NOT NULL,
  'ref_account' integer NOT NULL,
  'ref_item' integer NOT NULL,
  'comment' text,
  'point' integer NOT NULL,
  PRIMARY KEY  ('id'),
  UNIQUE ('ref_account','ref_item')
);

COMMIT;