-- ========================================================================
-- [works/sqls/mysql.sql]
-- 		MySQL4用テーブル定義
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--      [2007/02/02] 日記の未読コメントflagを追加
--      [2007/01/30] メッセージの添付画像(sns_fri_picture)を追加
--      [2007/01/21] お友達のお友達名簿を修正
--      [2007/01/21] お友達の招待名簿を追加
--      [2006/09/17] 印刷用テーブルの追加
--      [2006/09/16] デザインテーマの修正 背景の追加
--      [2006/09/05] 作成
-- ========================================================================

-- --------------------------------------------------------
-- 
-- Binary Large OBject
-- 
CREATE TABLE `sns_sys_blob` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `origin` varchar(64) NOT NULL,
  `name` varchar(128) NOT NULL,
  `mime_type` varchar(128) NOT NULL,
  `uid` int(11) NOT NULL,
  `gid` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `buffer` mediumblob NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`origin`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- セッション管理
-- 
CREATE TABLE `sns_sys_sessions` (
  `id` varchar(128) NOT NULL,
  `life_time` int(11) unsigned,
  `sess_data` text,
  PRIMARY KEY (id)
) TYPE=MyISAM;

-- 
-- メール設定
-- 
CREATE TABLE `sns_sys_mail` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `status` int(11) NOT NULL,
  `mailing` int(11) NOT NULL,
  `from_mail` varchar(128) NOT NULL,
  `from_name` varchar(128) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `condition` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 返信メールのテンプレート設定
-- 
CREATE TABLE `sns_sys_mailtpl` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `code` varchar(128) NOT NULL,
  `subject` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `name` varchar(128) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`code`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 各種一覧のソート設定
-- 
CREATE TABLE `sns_sys_sort` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_category` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `label` varchar(64) NOT NULL,
  `direction` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- スポンサー設定
-- 
CREATE TABLE `sns_sys_sponsor` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `avail` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `sponsor` varchar(128) NOT NULL,
  `html` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- システムデザイン
-- 
CREATE TABLE `sns_sys_design` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_common` int(11) NOT NULL,
  `ref_admin` int(11) NOT NULL,
  `ref_private` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_public` int(11) NOT NULL,
  `frame_width` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- デザインテーマ
-- 
CREATE TABLE `sns_des_theme` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `theme` varchar(128) NOT NULL,
  `round` varchar(6) NOT NULL,
  `box` varchar(6) NOT NULL,
  `border` varchar(6) NOT NULL,
  `text` varchar(6) NOT NULL,
  `column` varchar(6) NOT NULL,
  `button` varchar(6) NOT NULL,
  `focus` varchar(6) NOT NULL,
  `header` varchar(6) NOT NULL,
  `background` varchar(6) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- 地域情報
-- 
CREATE TABLE `sns_ara_area` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `area` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 都道府県マスター情報
-- 
CREATE TABLE `sns_ara_prefecture` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_area` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `prefecture` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 市区町村情報
-- 
CREATE TABLE `sns_ara_local` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_prefecture` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `local` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- 会員アカウント情報
-- 
CREATE TABLE `sns_act_account` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `last_login` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `avail` int(11),
  `status` int(11) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` blob NOT NULL,
  `email_hash` varchar(32),
  `cellular` blob,
  `cellular_hash` varchar(32),
  `news` int(11),
  `mailing` int(11),
  `footprint` int(11) default '0',
  `total` int(11) default '0',
  `friend_number` int(11) default '0',
  `block` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`email_hash`),
  UNIQUE (`cellular_hash`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 会員自動ログイン
-- 
CREATE TABLE `sns_act_autologin` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `loginkey` varchar(32),
  PRIMARY KEY  (`id`),
  UNIQUE (`loginkey`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 会員退会情報
-- 
CREATE TABLE `sns_act_exit` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modify` timestamp NOT NULL,
  `reason` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 血液型マスター情報
-- 
CREATE TABLE `sns_act_blood` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `blood` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 結婚マスター情報
-- 
CREATE TABLE `sns_act_married` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `married` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 性別マスター情報
-- 
CREATE TABLE `sns_act_sex` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `sex` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 会員プロフィール
-- 
CREATE TABLE `sns_act_profile` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modify` timestamp NOT NULL,
  `first_name` blob NOT NULL,
  `second_name` blob NOT NULL,
  `name_flag` int(11) NOT NULL,
  `nickname` varchar(128) NOT NULL,
  `visibility` int(11) NOT NULL,
  `ref_prefecture` int(11) NOT NULL,
  `ref_local` int(11),
  `prefecture_flag` int(11) NOT NULL,
  `ref_sex` int(11) NOT NULL,
  `sex_flag` int(11) NOT NULL,
  `ref_blood` int(11) NOT NULL,
  `blood_flag` int(11) NOT NULL,
  `birthday` date NOT NULL,
  `birthday_flag` int(11) NOT NULL,
  `age_flag` int(11) NOT NULL,
  `ref_married` int(11) NOT NULL,
  `married_flag` int(11),
  `ref_hometown` int(11),
  `ref_homelocal` int(11),
  `hometown_flag` int(11),
  `publicity` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 会員アンケート
-- 
CREATE TABLE `sns_act_enquete` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `required` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `form_type` int(11) NOT NULL,
  `validate`  varchar(32) NOT NULL,
  `format`  varchar(64),
  `max_length` int(11),
  `min_length` int(11),
  `sort` int(11) NOT NULL,
  `enquete` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケート項目
-- 
CREATE TABLE `sns_act_item` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_enquete` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `item` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートの入力内容
-- 
CREATE TABLE `sns_act_content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_enquete` int(11) NOT NULL,
  `ref_item` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11),
  `content` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_enquete`,`ref_item`,`ref_account`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートの選択
-- 
CREATE TABLE `sns_act_select` (
  `ref_enquete` int(11) NOT NULL,
  `ref_item` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11),
  UNIQUE (`ref_enquete`,`ref_item`,`ref_account`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 会員写真
-- 
CREATE TABLE `sns_act_photo` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_account` int(11) NOT NULL,
  `modify` timestamp NOT NULL,
  `status` int(11),
  `subject` varchar(255),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- カレンダースケジュール
-- 
CREATE TABLE `sns_cal_schedule` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `schedule` varchar(255) NOT NULL,
  `start_date` date,
  `end_date` date,
  `start_hour` varchar(4),
  `start_minute` varchar(4),
  `end_hour` varchar(4),
  `end_minute` varchar(4),
  `comment` text,
  `mail_flag` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- 日記基礎情報
-- 
CREATE TABLE `sns_dia_diary` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11),
  `type` int(11),
  `url` varchar(255),
  `rss` varchar(255),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 日記の投稿記事
-- 
CREATE TABLE `sns_dia_entry` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_diary` int(11) NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `format` int(11) NOT NULL,
  `post` int(11) default '0',
  `link` varchar(255),
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_diary`,`link`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 日記カテゴリ
-- 
CREATE TABLE `sns_dia_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_diary` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 日記カテゴリ選択
-- 
CREATE TABLE `sns_dia_select` (
  `ref_diary` int(11) NOT NULL,
  `ref_category` int(11) NOT NULL,
  `ref_entry` int(11) NOT NULL,
  UNIQUE (`ref_diary`,`ref_category`,`ref_entry`)
);

-- 
-- 日記へのコメント
-- 
CREATE TABLE `sns_dia_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_diary` int(11) NOT NULL,
  `ref_entry` int(11) NOT NULL,
  `ref_account` int(11),
  `flag` int(11) default '0',
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 日記の添付画像
-- 
CREATE TABLE `sns_dia_picture` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_entry` int(11),
  `title` varchar(255),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 色パレット
-- 
CREATE TABLE `sns_dia_color` (
  `id` int(11) unsigned NOT NULL,
  `color` varchar(32),
  `rgb` varchar(6),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- 
-- フォント
-- 
CREATE TABLE `sns_dia_font` (
  `id` int(11) unsigned NOT NULL,
  `font` varchar(32),
  `label` varchar(64),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

-- 
-- 本・印刷
-- 
CREATE TABLE `sns_dia_book` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_diary` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_font` int(11) NOT NULL,
  `ref_subject_color` int(11) NOT NULL,
  `ref_body_color` int(11) NOT NULL,
  `ref_line_color` int(11) NOT NULL,
  `start_date` date,
  `end_date` date,
  `comment_flag` int(11) NOT NULL,
  `created` int(11) default '0',
  `subject` varchar(255) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 本カテゴリ選択
-- 
CREATE TABLE `sns_dia_bookselect` (
  `ref_diary` int(11) NOT NULL,
  `ref_category` int(11) NOT NULL,
  `ref_book` int(11) NOT NULL,
  UNIQUE (`ref_diary`,`ref_category`,`ref_book`)
) TYPE=MyISAM;

-- --------------------------------------------------------
-- 
-- お友達のお友達名簿
-- 
CREATE TABLE `sns_fri_friends` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `avail` int(11),
  `status` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_account`,`ref_friend`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達の招待名簿
-- 
CREATE TABLE `sns_fri_invite` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11),
  `email` blob NOT NULL,
  `email_hash` varchar(32),
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`email_hash`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達のアクセスログ
-- 
CREATE TABLE `sns_fri_accesslog` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `unique_flag` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達の足跡
-- 
CREATE TABLE `sns_fri_footprint` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達のお気に入り
-- 
CREATE TABLE `sns_fri_favorite` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_account`,`ref_friend`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達の紹介
-- 
CREATE TABLE `sns_fri_intro` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_friend` int(11) NOT NULL,
  `relation` varchar(128),
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_account`,`ref_friend`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- お友達からのメッセージ
-- 
CREATE TABLE `sns_fri_message` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `status` int(11),
  `ref_account` int(11) NOT NULL,
  `ref_to` int(11) NOT NULL,
  `ref_from` int(11) NOT NULL,
  `ref_message` int(11),
  `flag` int(11),
  `subject` varchar(128) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- メッセージの添付画像
-- 
CREATE TABLE `sns_fri_picture` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_message` int(11),
  `title` varchar(255),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- フォーラムトピック
-- 
CREATE TABLE `sns_frm_topic` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `visibility` int(11),
  `deadline` date,
  `ref_prefecture` int(11),
  `ref_sex` int(11),
  `ref_blood` int(11),
  `low_age` int(11),
  `high_age` int(11),
  `ref_married` int(11),
  `ref_hometown` int(11),
  `post` int(11) default '0',
  `topic` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- フォーラムのジャンル
-- 
CREATE TABLE `sns_frm_genre` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `genre` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- フォーラムのカテゴリ
-- 
CREATE TABLE `sns_frm_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_genre` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- フォーラムの選択内容
-- 
CREATE TABLE `sns_frm_select` (
  `ref_topic` int(11) NOT NULL,
  `ref_category` int(11) NOT NULL,
  `number` int(11),
  UNIQUE (`ref_topic`,`ref_category`)
);

-- 
-- フォーラムコメント
-- 
CREATE TABLE `sns_frm_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- フォーラムのコメント返信
-- 
CREATE TABLE `sns_frm_response` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_comment` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `point` int(11),
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_topic`,`ref_comment`,`ref_account`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- フォーラム用画像
-- 
CREATE TABLE `sns_frm_picture` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_relation` int(11),
  `status` int(11),
  `title` varchar(255),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- コミュニティのジャンル
-- 
CREATE TABLE `sns_com_genre` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `genre` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティのカテゴリ
-- 
CREATE TABLE `sns_com_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_genre` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティの情報
-- 
CREATE TABLE `sns_com_community` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `avail` int(11),
  `visibility` int(11) NOT NULL,
  `topic_flag` int(11) NOT NULL,
  `community` varchar(128) NOT NULL,
  `ref_prefecture` int(11) NOT NULL,
  `url` varchar(128),
  `publicity` text NOT NULL,
  `total` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 選択カテゴリ
-- 
CREATE TABLE `sns_com_select` (
  `ref_category` int(11) NOT NULL,
  `ref_community` int(11) NOT NULL,
  UNIQUE (`ref_category`,`ref_community`)
);

-- 
-- コミュニティの名簿
-- 
CREATE TABLE `sns_com_names` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `status` int(11),
  `comment` text,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティのトピック
-- 
CREATE TABLE `sns_com_topic` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_community` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `deadline` date,
  `start_hour` varchar(4),
  `start_minute` varchar(4),
  `status` int(11),
  `ref_account` int(11) NOT NULL,
  `ref_prefecture` int(11) NOT NULL,
  `ref_local` int(11),
  `sub_locale` varchar(255),
  `topic` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  `post` int(11) default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティのコメント
-- 
CREATE TABLE `sns_com_comment` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティのイベント参加
-- 
CREATE TABLE `sns_com_entry` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_community`,`ref_topic`,`ref_account`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートオプション
-- 
CREATE TABLE `sns_com_option` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_community` int(11) NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `item` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートの選択結果
-- 
CREATE TABLE `sns_com_itmselect` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_community` int(11) NOT NULL,
  `ref_topic` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_option` int(11) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_topic`,`ref_account`,`ref_option`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- コミュニティの画像
-- 
CREATE TABLE `sns_com_picture` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_community` int(11),
  `ref_account` int(11) NOT NULL,
  `ref_relation` int(11),
  `status` int(11),
  `title` varchar(255),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- 問合せカテゴリのマスター情報
-- 
CREATE TABLE `sns_inq_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- 問合せ内容
-- 
CREATE TABLE `sns_inq_inquire` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_category` int(11),
  `ref_account` int(11),
  `status` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `url` varchar(128),
  `email` blob,
  `comment` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- システムからの記事　カテゴリマスター情報
-- 
CREATE TABLE `sns_itm_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `category` varchar(128) NOT NULL,
  `sort` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- システムからの記事
-- 
CREATE TABLE `sns_itm_item` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `avail` int(11) NOT NULL,
  `ref_category` int(11) NOT NULL,
  `open_date` date NOT NULL,
  `close_date` date,
  `deadline` date,
  `origin` varchar(64),
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`origin`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートオプション
-- 
CREATE TABLE `sns_itm_option` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `ref_item` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `item` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- アンケートの選択結果
-- 
CREATE TABLE `sns_itm_select` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `regist_date` timestamp NOT NULL,
  `ref_item` int(11) NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_option` int(11) NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_item`,`ref_account`,`ref_option`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- システムからの記事　ファイルアップ
-- 
CREATE TABLE `sns_itm_fileinfo` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_category` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `mimetype` varchar(64),
  `filename` varchar(255),
  `width` int(11),
  `height` int(11),
  `thumbnail` varchar(255),
  `t_width` int(11),
  `t_height` int(11),
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- --------------------------------------------------------
-- 
-- レビュー　カテゴリマスター情報
-- 
CREATE TABLE `sns_rev_category` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `type` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `category` varchar(128) NOT NULL,
  `code` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- レビューの対象商品
-- 
CREATE TABLE `sns_rev_item` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_category` int(11) NOT NULL,
  `total` float,
  `post` int(11) default '0',
  `url` varchar(255) NOT NULL,
  `asin` varchar(128) NOT NULL,
  `name` text NOT NULL,
  `creator` text NOT NULL,
  `release` varchar(32) NOT NULL,
  `manufacturer` varchar(255) NOT NULL,
  `imagesmall` varchar(255) NOT NULL,
  `imagemedium` varchar(255) NOT NULL,
  `imagelarge` varchar(255) NOT NULL,
  `listprice` varchar(64) NOT NULL,
  `ourprice` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`asin`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- レビューの結果ポイントマスター情報
-- 
CREATE TABLE `sns_rev_point` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `point` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

-- 
-- レビュー内容
-- 
CREATE TABLE `sns_rev_review` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `modify` timestamp NOT NULL,
  `ref_account` int(11) NOT NULL,
  `ref_item` int(11) NOT NULL,
  `comment` text,
  `point` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`ref_account`,`ref_item`)
) TYPE=MyISAM AUTO_INCREMENT=1;
