-- ========================================================================
-- [works/sqls/index.sql]
-- 		INDEX定義
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--      [2007/01/18] 各種ORDER部分のインデックス追加
--      [2006/09/17] 印刷用インデックスの追加
--      [2006/09/05] 作成
-- ========================================================================

BEGIN TRANSACTION;

-- 
-- 市区町村情報
-- 
CREATE INDEX sns_local_prefecture ON sns_ara_local (ref_prefecture);

-- --------------------------------------------------------
-- 
-- 会員自動ログイン
-- 
CREATE INDEX sns_autologin_account ON sns_act_autologin (ref_account);

-- 
-- 会員アカウント情報
-- 
CREATE INDEX sns_account_login ON sns_act_account (last_login);
CREATE INDEX sns_account_number ON sns_act_account (friend_number);

-- 
-- 会員プロフィール
-- 
CREATE INDEX sns_profile_account ON sns_act_profile (ref_account);
CREATE INDEX sns_profile_nickname ON sns_act_profile (nickname);
CREATE INDEX sns_profile_birthday ON sns_act_profile (birthday);

-- 
-- アンケートの入力内容
-- 
CREATE INDEX sns_content_account ON sns_act_content (ref_account);

-- 
-- アンケートの選択
-- 
CREATE INDEX sns_select_account ON sns_act_select (ref_account);

-- 
-- 会員写真
-- 
CREATE INDEX sns_photo_account ON sns_act_photo (ref_account);

-- --------------------------------------------------------
-- 
-- カレンダースケジュール
-- 
CREATE INDEX sns_schedule_start ON sns_cal_schedule (ref_account,start_date);
CREATE INDEX sns_schedule_end ON sns_cal_schedule (ref_account,end_date);


-- --------------------------------------------------------
-- 
-- 日記基礎情報
-- 
CREATE INDEX sns_diary_account ON sns_dia_diary (ref_account);

-- 
-- 日記の投稿記事
-- 
CREATE INDEX sns_entry_diary ON sns_dia_entry (ref_diary,ref_account,regist_date);
CREATE INDEX sns_entry_account ON sns_dia_entry (ref_account);
CREATE INDEX sns_entry_date ON sns_dia_entry (regist_date);
CREATE INDEX sns_entry_subject ON sns_dia_entry (subject);

-- 
-- 日記カテゴリ
-- 
CREATE INDEX sns_category_diary ON sns_dia_category (ref_diary,ref_account);

-- 
-- 日記へのコメント
-- 
CREATE INDEX sns_comment_count ON sns_dia_comment (ref_entry,ref_account);
CREATE INDEX sns_comment_diary ON sns_dia_comment (ref_diary);
CREATE INDEX sns_comment_entry ON sns_dia_comment (ref_entry);
CREATE INDEX sns_comment_account ON sns_dia_comment (ref_account);
CREATE INDEX sns_comment_modify ON sns_dia_comment (modify);

-- 
-- 日記の添付画像
-- 
CREATE INDEX sns_picture_entry ON sns_dia_picture (ref_account,ref_entry);

-- 
-- 本・印刷
-- 
CREATE INDEX sns_book_diary ON sns_dia_book (ref_diary);
CREATE INDEX sns_book_account ON sns_dia_book (ref_account);

-- --------------------------------------------------------
-- 
-- お友達のアクセスログ
-- 
CREATE INDEX sns_accesslog_account ON sns_fri_accesslog (ref_account,ref_friend);

-- 
-- お友達の足跡
-- 
CREATE INDEX sns_footprint_account ON sns_fri_footprint (ref_account,ref_friend);

-- 
-- お友達の紹介
-- 
CREATE INDEX sns_intro_modify ON sns_fri_intro (modify);

-- 
-- お友達からのメッセージ
-- 
CREATE INDEX sns_message_account ON sns_fri_message (ref_account);
CREATE INDEX sns_message_to ON sns_fri_message (ref_account,ref_to);
CREATE INDEX sns_message_from ON sns_fri_message (ref_account,ref_from);
CREATE INDEX sns_message_date ON sns_fri_message (regist_date);

-- --------------------------------------------------------
-- 
-- フォーラムトピック
-- 
CREATE INDEX sns_topic_account ON sns_frm_topic (ref_account);
CREATE INDEX sns_topic_frm_modify ON sns_frm_topic (modify);
CREATE INDEX sns_topic_frm_post ON sns_frm_topic (post);
CREATE INDEX sns_topic_frm_date ON sns_frm_topic (regist_date);

-- 
-- フォーラムコメント
-- 
CREATE INDEX sns_comment_topic ON sns_frm_comment (ref_topic,ref_account);

-- 
-- フォーラム用画像
-- 
CREATE INDEX sns_picture_topic ON sns_frm_picture (ref_account,ref_relation);


-- --------------------------------------------------------
-- 
-- コミュニティの情報
-- 
CREATE INDEX sns_com_genre_sort ON sns_com_genre (sort);
CREATE INDEX sns_com_category_sort ON sns_com_category (sort);


CREATE INDEX sns_community_admin ON sns_com_community (ref_account);
CREATE INDEX sns_community_modify ON sns_com_community (modify);
CREATE INDEX sns_community_name ON sns_com_community (community);
CREATE INDEX sns_community_total ON sns_com_community (total);
CREATE INDEX sns_community_date ON sns_com_community (regist_date);

-- 
-- コミュニティの名簿
-- 
CREATE INDEX sns_names_account ON sns_com_names (ref_community,ref_account);

-- 
-- コミュニティのトピック
-- 
CREATE INDEX sns_topic_community ON sns_com_topic (ref_community,ref_account);
CREATE INDEX sns_topic_com_modify ON sns_com_topic (modify);
CREATE INDEX sns_topic_com_topic ON sns_com_topic (topic);
CREATE INDEX sns_topic_com_date ON sns_com_topic (start_date);

-- 
-- コミュニティのコメント
-- 
CREATE INDEX sns_comment_community ON sns_com_comment (ref_community,ref_topic,ref_account);
CREATE INDEX sns_comment_com_count ON sns_com_comment (ref_topic,ref_account);
CREATE INDEX sns_comment_com_date ON sns_com_comment (regist_date);
CREATE INDEX sns_comment_com_modify ON sns_com_comment (modify);

-- 
-- コミュニティの画像
-- 
CREATE INDEX sns_picture_community ON sns_com_picture (ref_community,ref_account,ref_relation);

-- --------------------------------------------------------
-- 
-- 問合せ内容
-- 
CREATE INDEX sns_inquire_account ON sns_inq_inquire (ref_account);



-- --------------------------------------------------------
-- 
-- レビュー対象商品
-- 
CREATE INDEX sns_rev_item_total ON sns_rev_item (total);
CREATE INDEX sns_rev_item_post ON sns_rev_item (post);
CREATE INDEX sns_rev_item_modify ON sns_rev_item (modify);

-- 
-- レビュー内容
-- 
CREATE INDEX sns_review_modify ON sns_rev_review (modify);


COMMIT;
