<?php
/* ========================================================================
 - [modules/private/forum/browse.php]
 -      トピック参照
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/08/28] コメント一覧に投稿者画像追加
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * トピック情報格納
     * @var integer
     */
    var $topic = array();


    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/forum/browse.tpl');
        $this->addJavas('common.js');

        /* PathInfo引数の設定 */
        $this->setPathInfo('id', 1);
        $this->Assign('id', $this->id);
        $this->setSafety('delete');

        $this->set_topic();
        /* 閲覧権限があるか？ */
        if (empty($this->visibility & $this->topic['visibility'])){
            header('Location: '.HTTP_ACTION.'friend/forum/list/'.$this->ref_friend.'/');
            exit();
        }

        /* コメントの削除処理 */
        if ($this->delete_comment()){
            $this->update_topic();
            header('Location: '.HTTP_ACTION.'friend/forum/browse/'.$this->ref_friend.'/'.$this->id.'/');
            exit();
        }

        $this->set_category();
        $this->set_prefecture();
        $this->set_sex();
        $this->set_blood();
        $this->set_married();
        
        $this->set_comment();
        
        $this->Assign('edit_form', $this->check_condition());

        $visibilitys = array(
            VISIBILITY_PROTECTED=> VISIBILITY_LABEL_PROTECTED,
            VISIBILITY_FRIEND=>    VISIBILITY_LABEL_FRIEND,
            VISIBILITY_HIDDEN=>    VISIBILITY_LABEL_HIDDEN,
        );
        $this->Assign('visibilitys', $visibilitys);
    }

    /**
     * トピック情報の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->topic = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('topic', $this->topic);

        $pictures = $this->get_picture($this->topic['id'],STATUS_PICTURE_TOPIC);
        $this->Assign('pictures', $pictures);
    }

    /**
     * 書き込み権限があるか？
     *
     * @access private
     * @return boolean
     **/
    function check_condition()
    {
        $sql=
            'SELECT '.
                'ref_prefecture,'.
                'ref_sex,'.
                'ref_blood,'.
                'birthday,'.
                'ref_married,'.
                'ref_hometown '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $age = sql_query::getAge($result['birthday']);
        
        if (!empty($this->topic['ref_prefecture'])){
            if ($this->topic['ref_prefecture'] != $result['ref_prefecture']){
                return false;
            }
        }

        if (!empty($this->topic['ref_sex'])){
            if ($this->topic['ref_sex'] != $result['ref_sex']){
                return false;
            }
        }

        if (!empty($this->topic['ref_blood'])){
            if ($this->topic['ref_blood'] != $result['ref_blood']){
                return false;
            }
        }

        if (!empty($this->topic['low_age'])){
            if ($this->topic['low_age'] > $age){
                return false;
            }
        }

        if (!empty($this->topic['high_age'])){
            if ($this->topic['high_age'] < $age){
                return false;
            }
        }

        if (!empty($this->topic['ref_married'])){
            if ($this->topic['ref_married'] != $result['ref_married']){
                return false;
            }
        }

        if (!empty($this->topic['ref_hometown'])){
            if ($this->topic['ref_hometown'] != $result['ref_hometown']){
                return false;
            }
        }
        return true;
    }

    /**
     * 選択肢の設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'cat.id as id,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'frm_category cat,'.
                DB_PREFIX.'frm_select sel '.
            'WHERE '.
                'cat.id = sel.ref_category AND '.
                'sel.ref_topic = '.$this->id.' '.
            'ORDER BY '.
                'ref_genre,sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        foreach ($result as $value){
            // 改行処理
            if ($column >= 4){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'label'=> $value['category'],
            );
            $column++;
        }
        $this->Assign('categorys', $list);
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sex '.
            'FROM '.
                DB_PREFIX.'act_sex '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['sex'];
        }
        
        $this->Assign('sexs',$list);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'id,'.
                'blood '.
            'FROM '.
                DB_PREFIX.'act_blood '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['blood'];
        }
        
        $this->Assign('bloods',$list);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'id,'.
                'married '.
            'FROM '.
                DB_PREFIX.'act_married '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['married'];
        }
        
        $this->Assign('marrieds',$list);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @param integer $status
     * @return mixed
     */
    function get_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * コメント一覧の設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_COMMENT);    // クラスの生成
        $sql=
            'SELECT '.
                'cmt.id as id,'.
                'pro.nickname as nickname,'.
                'cmt.ref_account as ref_account,'.
                'cmt.regist_date as regist_date,'.
                'cmt.comment as comment,'.
                'res.point as point,'.
                'res.comment as response,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'frm_comment cmt '.
                    'LEFT JOIN '.DB_PREFIX.'frm_response res '.
                    'ON cmt.id = res.ref_comment,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = cmt.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'cmt.ref_topic = '.$this->id.' '.
            'ORDER BY '.
                'cmt.regist_date DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $value){
            $value['pictures'] = $this->get_picture($value['id'],STATUS_PICTURE_COMMENT);

            $list[] = $value;
        }

        $this->Assign('comment', $list);

        $this->doFootprint();
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql=
            'SELECT '.
                'ref_topic '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'id ='.$this->delete .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['ref_topic'])){
            return false;
        }

        $this->ref_topic = $result['ref_topic'];
        $this->delete_picture();
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->id.' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access private
     * @return boolean
     */
    function delete_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.STATUS_PICTURE_COMMENT.' AND '.
                'ref_relation = '.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM);
        foreach ($result as $value){
            $objblb->unlink($value['filename']);
            $objblb->unlink($value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.STATUS_PICTURE_COMMENT.' AND '.
                'ref_relation = '.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_topic()
    {
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'frm_topic '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->id;
        $this->objdb->exec($sql);
    }
} // webapp
?>
