<?php
/* ========================================================================
 - [modules/friend/edit/relation.php]
 -      友達追加
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/28] メール送信部位、テンプレート変数変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 友達ID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/edit/relation.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        
        /* 友達判定 */
        $this->Assign('is_friend', $this->isFriend());

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/edit/relation/'.$this->ref_friend.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_friends');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->send_mail();
            header('Location: '.HTTP_ACTION.'friend/edit/relation/'.$this->ref_friend.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'friend/edit/relation/'.$this->ref_friend.'/confirm/');
            exit();
        }
        $this->set_status();
    }

    /**
     * ステータスの設定
     *
     * @access private
     * @return integer
     */
    function set_status()
    {
        $sql=
            'SELECT '.
                'status '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'ref_friend = '.$this->ref_friend;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $status = empty($result['status'])?null:$result['status'];

        $this->Assign('status', $status);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('avail', AVAIL_ENABLE);
        $this->objmnp->setValue('status', STATUS_FRIEND_THROW);
        $this->objmnp->setValue('ref_account',  $this->ref_friend);
        $this->objmnp->setValue('ref_friend', $this->account['id']);

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'ref_friend',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $comment = $this->objmnp->getRequest('comment');
        $objmail = new sendmail('relation');

        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('comment', $comment."\r\n");
        $objmail->Assign('url', HTTP_ACTION.'private/edit/relation/');

        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }
} // webapp
?>
