<?php
/* ========================================================================
 - [modules/community/item/enquete.php]
 -      コミュニティ記事を作成する
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';
require_once WEBAPP_LIB_DIR.'community/pictures.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * 表示対象年月日
     * @var string
     */
    var $date = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 選択項目
     * @var integer
     */
    var $com_option = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/item/enquete.tpl');
        $this->addCss('crosseditor.css');
        $this->addJavas('prototype.js');
        $this->addJavas('crosseditor.js');
        $this->addJavas('option.js');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('enquete');
        $this->Assign('enquete', $this->enquete);
        $this->setSafety('date', '_REQUEST', 'date');

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/item/list/'.$this->ref_community.'/');
            exit();
        }

        /* 編集権限が無い */
        if (!$this->is_editor()){
            header('Location: '.HTTP_ACTION.'community/item/list/'.$this->ref_community.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/item/enquete/'.$this->ref_community.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id.'&enquete='.$this->enquete);
            exit();
        }

        // 添付画像操作クラスの生成
        $objpic = new community_pictures($this->ref_community, $this->id, STATUS_PICTURE_TOPIC);
        $objpic->doUpload();

        // アンケート選択肢の設定
        $this->set_com_option();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_topic');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();

            // アンケート選択肢の処理
            $this->do_query_option();
            unset($_SESSION['com_option']);
            
            $this->update_topic();

            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            $_SESSION['com_option'] = $this->com_option;
            header('Location: '.HTTP_ACTION.'community/item/enquete/'.$this->ref_community.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        $this->Assign('picture', $objpic->getImgInfos());

        $this->set_crosseditor();
        $this->set_date();
        $this->set_option();
    }

    /**
     * javascriptの設定
     *
     * @access private
     * @return void
     */
    function set_crosseditor()
    {
        if (preg_match('/confirm/i',$_SERVER['REQUEST_URI'])){
            return ;
        }
        $img = BASE_URL.'resource/img/crosseditor/';

        $init = 
            "Event.observe(window, 'load', function(){".
            	"var editor = new CrossEditor('".$img."');".

            	'str = navigator.appName.toUpperCase();'.
            	'if (str.indexOf("EXPLORER") >= 0){'.
            		"$('pallete').style.position = 'static';".
            	'}'.

            '});';
        $this->baseAssign('javascript', $init);
    }

    /**
     * 日付の設定
     *
     * @access private
     * @return void
     **/
    function set_date()
    {
        $objcal = new RKT_calendar($this->date);
        $timestamp  = $objcal->getTimestamp();

    	$years = array();
    	$months = array();
    	$days = array();

    	$num = date('Y',$timestamp);
    	$max_year = $num + 3;
    	for ($num;$num<$max_year;$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}
        $sixty = array(
            '00'=>'00',
            '15'=>'15',
            '30'=>'30',
            '45'=>'45',
        );

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);
        $this->Assign('hours', $hours);
        $this->Assign('sixty', $sixty);

        
        $now_date = date('Y-m-d H:i:s',$timestamp);

        /* 開始年月日: */
        $date = $this->objmnp->getValue('start_date');
        $date = empty($date)?$this->objmnp->getInitValue('start_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('start_date', $init_date);

        /* 終了年月日: */
        $date = $this->objmnp->getValue('deadline');
        $date = empty($date)?$this->objmnp->getInitValue('deadline'):$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('deadline', $init_date);
    }

    /**
     * 本文のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function format_comment($string)
    {
        $string = preg_replace('/<p>/i', '', $string);
        $string = preg_replace('/<\/p>/i', '<br />', $string);

        $string = preg_replace('/<div>/i', '', $string);
        $string = preg_replace('/<\/div>/i', '<br />', $string);

        return $string;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
            $this->objmnp->setValue('post', 0);
            $this->objmnp->setValue('status', STATUS_TOPIC_ENQUETE);
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_prefecture', 0);
        $this->objmnp->setValue('start_date', date('Y-m-d'));

        /* 入力データの加工設定 */
        $func = array('webapp', 'format_comment');
        $this->objmnp->setInputEffect('comment', array('func'=>$func, 'key'=>'comment'));

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
            'status',
            'start_hour',
            'start_minute',
            'local',
            'post',
            'comment',
            'sub_locale',
        );

        /* 入力条件を指定 */
        $validates = array(
            'comment'=> array(
                'type'=>    'string',
                'option'=>  null,
                'required'=>true,
                'effect'=>  array('RKT_validate', 'strip_slashes'),
            ),
        );
        return $this->objmnp->execute($this,$skip,$validates);
    }

    /**
     * トピックの編集権限
     *
     * @access private
     * @return boolean
     */
    function is_editor()
    {
        if (empty($this->id)){
            return true;
        }
        if ($this->admin){
            return true;
        }

        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id = '.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['id']);
    }

    /**********************************************/
    /**********    選択項目     *******************/
    /**********************************************/
    /**
     * 選択した選択項目の取得
     *
     * @access private
     * @return array
     */
    function set_com_option()
    {
        if (isSet($_POST['com_option'])){
            $this->com_option = empty($_POST['com_option'])?array():$_POST['com_option'];
            return ;
        }
        if (isSet($_SESSION['com_option'])){
            $this->com_option = empty($_SESSION['com_option'])?array():$_SESSION['com_option'];
            return ;
        }
        
        $sql=
            'SELECT '.
                'id,'.
                'item '.
            'FROM '.
                DB_PREFIX.'com_option '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id.' '.
            'ORDER BY '.
                'ID';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $this->com_option = $result;
    }

    /**
     * 選択項目の設定
     *
     * @access private
     * @return void
     */
    function set_option()
    {        
        $list = array();
        foreach ($this->com_option as $value){
            $list[$value['id']] = $value['item'];
        }

        $this->Assign('options', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_query_option()
    {
        $list = array();
        foreach ($this->com_option as $value){
            $value['item'] = $this->objdb->quote($value['item']);

            if (empty($value['id'])){
                $value['id'] = $this->insert_option($value);
            } else {
                $this->update_option($value);
            }
            $list[$value['id']] = $value['id'];
        }

        /* 削除用の処理 */
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_option '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        foreach ($result as $value){
            if (empty($list[$value['id']])){
                $this->delete_option($value['id']);
            }
        } // foreach ($result as $value)

        return true;
    }

    /**
     * 記事の選択項目を新規登録
     *
     * @access private
     * @param array $value
     * @return boolean  真偽値
     */
    function insert_option($value)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'com_option('.
                    'ref_community,'.
                    'ref_topic,'.
                    'sort,'.
                    'item'.
                ') VALUES ('.
                    $this->ref_community.','.
                    $this->id.','.
                    '0,'.
                    $value['item'].
                ')';
        $result = $this->objdb->exec($sql);
        if ($result <= 0){
            return 0;
        }
        return $this->objdb->lastInsertId();
    }

    /**
     * 記事の選択項目を更新
     *
     * @access private
     * @param array $value
     * @return boolean  真偽値
     */
    function update_option($value)
    {
        $id = $this->objdb->quote($value['id']);
        $sql =
            'UPDATE '.
                DB_PREFIX.'com_option '.
            'SET '.
                'item = '.$value['item'].' '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id.' AND '.
                'id = '.$id;
        return $this->objdb->exec($sql);
    }

    /**
     * 記事の選択項目を削除
     *
     * @access private
     * @param integer $id  選択項目ID
     * @return boolean  真偽値
     */
    function delete_option($id)
    {
        $id = $this->objdb->quote($id);

        /* アンケートの削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_itmselect '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_option '.
            'WHERE '.
                'ref_community ='.$this->ref_community.' AND '.
                'ref_topic ='.$this->id.' AND '.
                'id ='.$id;
        return $this->objdb->exec($sql);
    }


    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_topic()
    {
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_topic '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->id;
        $this->objdb->exec($sql);
    }
} // webapp
?>
