<?php
/* ========================================================================
 - [modules/private/edit/friend.php]
 -      友達リスト管理
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 友達登録ID
     * @var object
     */
    var $id = null;

    /**
     * 友達登録削除ID
     * @var object
     */
    var $delete = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/edit/friend.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->setSafety('delete');

        $this->set_friend();

        /* 削除 */
        if ($this->delete_friends()){
            header('Location: '.HTTP_ACTION.'private/show/friends/'.$this->sid.'/'.$this->sid.'/');
            exit();
        }
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $sql=
            'SELECT '.
                'id,'.
                'ref_account,'.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->account['id'] .' '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $ref_friend = ($result['ref_account'] != $this->account['id'])
                            ?$result['ref_account']:$result['ref_friend'];
        $friend = $this->get_friend($result['id'],$ref_friend);
        
        $this->Assign('friend', $friend);
    }

    /**
     * 友達情報の取得
     *
     * @access private
     * @return void
     */
    function get_friend($id, $ref_account)
    {
        $sql=
            'SELECT '.
                '0 as id,'.
                'act.id as ref_friend,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'pro.publicity as publicity '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = '.$ref_account.' AND '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $result['id'] = $id;
        $result['src'] = empty($result['src'])?NOPHOTO_SMALL:$result['src'];
        $result['width'] = empty($result['width'])?PHOTO_SMALL_SIZE:$result['width'];
        $result['height'] = empty($result['height'])?PHOTO_SMALL_SIZE:$result['height'];

        return $result;
    }

    /**
     * 友達登録の解消
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_friends()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql=
            'SELECT '.
                'ref_friend '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'id = '.$this->delete.' AND '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['ref_friend'])){
            return false;
        }
        $ref_friend = $result['ref_friend'];

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_friends '.
            ' WHERE '.
                'id ='.$this->delete;
        $result = $this->objdb->exec($sql);
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_friends '.
            ' WHERE '.
                'ref_account = '.$ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $result = $this->objdb->exec($sql);
        
        $this->update_friend_number($this->account['id']);
        $this->update_friend_number($ref_friend);
        return $result;
    }

    /**
     * 友達数の設定
     *
     * @access private
     * @param integer $ref_account
     * @return void
     */
    function update_friend_number($ref_account)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'friend_number ='.$result['ct'].' '.
            'WHERE '.
                'id='.$ref_account;
        $this->objdb->exec($sql);
    }
} // webapp
?>
