<?php
/* ========================================================================
 - [modules/private/content/browse.php]
 -      コンテンツ記事閲覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/31] アクセス権限変更
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * アンケートID
     * @var integer
     */
    var $id = null;

    /**
     * ページ名
     * @var string
     */
    var $origin = '';

    /**
     * 記事情報ID
     * @var integer
     */
    var $ref_item = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/content/browse.tpl');
        
        /* PathInfoによる引数の取得 */
        $this->setPathInfo('origin',0,'string');
        $this->Assign('origin', $this->origin);
        $this->set_content();

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/content/browse/'.$this->sid.'/'.$this->origin.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'itm_select');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/content/browse/'.$this->sid.'/'.$this->origin.'/complete/#bar');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/content/browse/'.$this->sid.'/'.$this->origin.'/confirm/#editform');
            exit();
        }

        $this->set_option();
        $this->set_bar();
    }

    /**
     * 記事の設定
     *
     * @access private
     * @return void
     **/
    function set_content()
    {
        $now = date('Y-m-d H:i:s');
        $sql = 
            'SELECT '.
                'id,'.
                'modify,'.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'itm_item '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "open_date <= '".$now."' AND ".
                "origin='".$this->origin."' ";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_item = $result['id'];

        $subject = empty($result['subject'])?'コンテンツ':$result['subject'];
        $this->baseAssign('title', $subject);
        $this->Assign('item', $result);
    }

    /**
     * アンケート項目の設定
     *
     * @access private
     * @return void
     **/
    function set_option()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'item '.
            'FROM '.
                DB_PREFIX.'itm_option '.
            'WHERE '.
                'ref_item = '.$this->ref_item.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['item'];
        }

        $this->Assign('options', $list);
    }

    /**
     * バーリストの設定
     *
     * @access private
     * @return void
     **/
    function set_bar()
    {
        $sql = 
            'SELECT '.
                'opt.id as id,'.
                'opt.item as item,'.
                'count(sel.ref_account) as vote '.
            'FROM '.
                DB_PREFIX.'itm_option opt '.
                    'LEFT JOIN '.DB_PREFIX.'itm_select sel '.
                    'ON opt.id = sel.ref_option '.
            'WHERE '.
                'opt.ref_item = '.$this->ref_item.' '.
            'GROUP BY '.
                'opt.id '.
            'ORDER BY '.
                'vote DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $par = 200;
        if ($result[0]['vote']!=0){
            $par = 200 / $result[0]['vote'];
        }
        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=>   $value['id'],
                'item'=> $value['item'],
                'vote'=> $value['vote'],
                'bar'=>  intval($value['vote'] * $par)
            );
        }
        $this->Assign('bars', $list);        
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return void
     */
    function set_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'itm_select '.
            'WHERE '.
                'ref_item = '.$this->ref_item.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->id = empty($result['id'])?null:$result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $this->set_curid();
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_item', $this->ref_item);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this, $skip);
    }
} // webapp
?>
