<?php
/* ========================================================================
 - [modules/private/diary/post.php]
 -      日記記事投稿
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/25] sns_dia_entry.link を更新しないように変更
 -      [2006/09/17] do_query_select()のforach() Warning を除去
 -      [2006/08/29] 日記カテゴリの取得エラーを修正
 -      [2006/07/25] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'private/dia_pictures.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 記事ID
     * @var integer
     */
    var $id = null;

    /**
     * 日記ID
     * @var integer
     */
    var $ref_diary = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 添付画像操作オブジェクト
     * @var object
     */
    var $objpic = null;

    /**
     * 選択済みカテゴリ
     * @var integer
     */
    var $dia_select = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/diary/post.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->id = empty($this->id)?0:$this->id;
        $this->Assign('id', $this->id);

        /* 削除処理 */
        if ($this->delete_entry()){
            header('Location: '.HTTP_ACTION.'private/diary/list/complete/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/diary/post/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        $this->set_ref_diary();

        // 添付画像操作クラスの生成
        $objpic = new dia_pictures($this->id, STATUS_PICTURE_TOPIC);
        $objpic->doUpload();

        // 選択済みカテゴリの取得
        $this->set_dia_select();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_entry');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();
            
            // 選択済みカテゴリ処理
            $this->do_query_select();
            unset($_SESSION['dia_select']);

            header('Location: '.HTTP_ACTION.'private/diary/entry/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['dia_select'] = $this->dia_select;
            header('Location: '.HTTP_ACTION.'private/diary/post/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_category();
        $this->Assign('picture', $objpic->getImgInfos());
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * 日記IDの取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_ref_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['id'];
    }

    /**
     * 本文のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function format_body($string)
    {
        return strip_tags($string);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('ref_account', $this->account['id']);
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('visibility', VISIBILITY_PROTECTED);
        $this->objmnp->setValue('format', DIARY_FORMAT_PLAIN);

        /* 入力データの加工設定 */
        $func = array('webapp', 'format_body');
        $this->objmnp->setInputEffect('body', array('func'=>$func, 'key'=>'body'));

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'regist_date',
            'link',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 投稿記事の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_entry()
    {
        if (empty($_POST['delete'])){
            return false;
        }
        $this->delete_picture();

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_comment '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access private
     * @return boolean
     */
    function delete_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM);
        foreach ($result as $value){
            $objblb->unlink($value['filename']);
            $objblb->unlink($value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**********************************************/
    /**********    カテゴリ     *******************/
    /**********************************************/
    /**
     * 選択したカテゴリの取得
     *
     * @access private
     * @return array
     */
    function set_dia_select()
    {
        if (isSet($_POST['dia_select'])){
            $this->dia_select = empty($_POST['dia_select'])?array():$_POST['dia_select'];
            return ;
        }
        if (isSet($_SESSION['dia_select'])){
            $this->dia_select = empty($_SESSION['dia_select'])?array():$_SESSION['dia_select'];
            return ;
        }
        
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_entry = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['ref_category']] = $value['ref_category'];
        }
        
        $this->dia_select = $list;
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $is_confirm = preg_match('/confirm/',$_SERVER['REQUEST_URI']);
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(ref.ref_category) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat '.
                    'LEFT JOIN '.DB_PREFIX.'dia_select ref '.
                    'ON cat.id = ref.ref_category '.
            'WHERE '.
                'cat.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'cat.id '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        if ($is_confirm){
            foreach ($result as $value){
                if (isSet($this->dia_select[$value['id']])){
                    $list[] = array(
                        'id'=> $value['id'],
                        'value'=> $value['id'],
                        'count'=> $value['ct'],
                        'label'=> $value['category'],
                    );
                }
            } // foreach ($result as $value)
        } else {
            foreach ($result as $value){
                $list[] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'count'=> $value['ct'],
                    'label'=> $value['category'],
                    'checked'=> !empty($this->dia_select[$value['id']]),
                );
            }
        } // if ($this->confirm)


        $this->Assign('categorys', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_query_select()
    {
        $ref_entry = $this->objmnp->getCurID();
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        foreach ($result as $value){
            if (empty($this->dia_select[$value['id']])){
                $this->delete_select($value['id'], $ref_entry);
            } else {
                $this->insert_select($value['id'], $ref_entry);
            }
        } // foreach ($result as $value)

        return true;
    }

    /**
     * 記事のカテゴリを新規登録
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_entry     記事ID
     * @return boolean  真偽値
     */
    function insert_select($ref_category, $ref_entry)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'dia_select('.
                    'ref_diary,'.
                    'ref_category,'.
                    'ref_entry'.
                ') VALUES ('.
                    $this->ref_diary.','.
                    $ref_category.','.
                    $ref_entry.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 記事のカテゴリを削除
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_entry     記事ID
     * @return boolean  真偽値
     */
    function delete_select($ref_category, $ref_entry)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_select '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary.' AND '.
                'ref_category ='.$ref_category.' AND '.
                'ref_entry ='.$ref_entry;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
