<?php
/* ========================================================================
 - [modules/community/bbs/comment.php]
 -      コメントを書き込む
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';
require_once WEBAPP_LIB_DIR.'community/pictures.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * コメントID
     * @var integer
     */
    var $id = 0;

    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * イベント参加フラグ
     * @var integer
     */
    var $entry = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/comment.tpl');
        $this->addJavas('common.js');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic', 1);
        $this->Assign('ref_topic', $this->ref_topic);

        $this->setSafety('id');
        $this->Assign('id', $this->id);

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        $this->entry_flag();

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/bbs/comment/'.$this->ref_community.'/'.$this->ref_topic.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // 添付画像操作クラスの生成
        $objpic = new community_pictures($this->ref_community, $this->id, STATUS_PICTURE_COMMENT);
        $objpic->doUpload();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_comment');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            
            /* イベント参加処理 */
            $this->query_entry();
            /* トピックの更新日を最新に */            
            $this->update_topic();

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();
            header('Location: '.HTTP_ACTION.'community/bbs/browse/'.$this->ref_community.'/'.$this->ref_topic.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/bbs/comment/'.$this->ref_community.'/'.$this->ref_topic.'/confirm/'.WAP_URI_SEPARATOR.'entry='.$this->entry);
            exit();
        }

        $this->Assign('picture', $objpic->getImgInfos());
        $this->set_topic();
        $this->entry_button();
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.start_hour as start_hour,'.
                'tpc.start_minute as start_minute,'.
                'pro.nickname as nickname,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'prf.prefecture as prefecture,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = tpc.ref_prefecture,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.id = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $topic = array(
            'id'=> $result['id'],
            'regist_date'=> $result['regist_date'],
            'start_date'=> $result['start_date'],
            'deadline'=> (ereg('0000',$result['deadline']))?null:$result['deadline'],
            'start_hour'=> $result['start_hour'],
            'start_minute'=> $result['start_minute'],
            'nickname'=> $result['nickname'],
            'ref_account'=> $result['ref_account'],
            'status'=> $result['status'],
            'prefecture'=> $result['prefecture'],
            'sub_locale'=> $result['sub_locale'],
            'topic'=> $result['topic'],
            'comment'=> $result['comment'],
            'pictures'=> $this->get_picture($result['id'],STATUS_PICTURE_TOPIC),
            'count'=> $this->get_comment_num($result['id']),
            'entrys'=> $this->get_entry_num($result['id'])
        );

        $this->Assign('topic', $topic);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @param integer $status
     * @return mixed
     */
    function get_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * コメント数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return void
     */
    function get_comment_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * 参加数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return void
     */
    function get_entry_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * イベント参加ボタン
     *
     * @access private
     * @return void
     */
    function entry_button()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->ref_topic.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('entry_button', empty($result['id']));
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_topic', $this->ref_topic);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }
    
    /**
     * イベント参加フラグ
     *
     * @access private
     * @return void
     */
    function entry_flag()
    {
        if (empty($_REQUEST['entry'])){
            return ;
        }

        if (!empty($_POST['entry'])){
            $_REQUEST['validate'] = true;
        }

        $this->entry = 1;
        $this->Assign('entry', true);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return void
     */
    function query_entry()
    {
        if (empty($_POST['entry'])){
            return ;
        }

        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->ref_topic.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->insert_entry();
        } else {
            $this->delete_entry($result['id']);
        }
    }

    /**
     * イベント参加を新規登録
     *
     * @access private
     * @param integer $ref_item   選択肢ID
     * @return boolean  真偽値
     */
    function insert_entry()
    {
        $now = date('Y-m-d H:i:s');

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'com_entry('.
                    'modify,'.
                    'regist_date,'.
                    'ref_community,'.
                    'ref_topic,'.
                    'ref_account'.
                ') VALUES ('.
                    "'".$now."',".
                    "'".$now."',".
                    $this->ref_community.','.
                    $this->ref_topic.','.
                    $this->account['id'].
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * イベント参加を削除
     *
     * @access private
     * @param integer $ref_item   選択肢ID
     * @return boolean  真偽値
     */
    function delete_entry($id)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'id ='.$id;
        return $this->objdb->exec($sql);
    }

    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return boolean  真偽値
     */
    function update_topic()
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'com_topic '.
            'SET '.
                "modify = '".date('Y-m-d H:i:s')."' ".
            'WHERE '.
                'id ='.$this->ref_topic;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
