<?php
/* ========================================================================
 - [modules/admin/profile/enquete.php]
 -      プロフィール追加項目編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * アンケートID
     * @var integer
     */
    var $id = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/profile/enquete.tpl');        
        $this->addJavas('admin.js');

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_enquete');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'admin/profile/enquetes/complete/');
            exit();
        }
        if ($this->delete_enquete()){
            header('Location: '.HTTP_ACTION.'admin/profile/enquetes/complete/');
            exit();
        }

        /* フォームタイプ */
        $form_types = array(
            FORM_TYPE_TEXT=>     'テキスト',
            FORM_TYPE_TEXTAREA=> 'テキストエリア',
            FORM_TYPE_SELECT=>   '選択リスト',
            FORM_TYPE_CHECKBOX=> 'チェックボックス',
            FORM_TYPE_RADIO=>    'ラジオボタン',
            FORM_TYPE_DATE=>     '日付リスト',
        );
        $this->Assign('form_types',$form_types);
    }

    /**
     * 表示順番の取得
     *
     * @access private
     * @return interger
     */
    function get_sort()
    {
        $sql=
            'SELECT '.
                'max(sort) as sort '.
            'FROM '.
                DB_PREFIX.'act_enquete ';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        return empty($result['sort'])?1:$result['sort']+1;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('sort', $this->get_sort());
        }

        // 更新しない項目名
        $skip = array(
            'sort'
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this);
    }

    /**
     * アンケートの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_enquete()
    {
        if (empty($_POST['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_select '.
            'WHERE '.
                'ref_enquete ='.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_content '.
            'WHERE '.
                'ref_enquete ='.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_item '.
            'WHERE '.
                'ref_enquete ='.$this->id;
        $this->objdb->exec($sql);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_enquete '.
            'WHERE '.
                'id ='.$this->id;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
