<?php
/* ========================================================================
 - [modules/admin/master/com_category.php]
 -      コミュニティカテゴリ
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/02] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * カテゴリID
     * @var integer
     */
    var $id = null;

    /**
     * ジャンルID
     * @var integer
     */
    var $ref_genre = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/master/com_category.tpl');

        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('ref_genre');

        $this->set_genre();
        $this->Assign('ref_genre', $this->ref_genre);

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_category');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'admin/master/com_category/complete/'.WAP_URI_SEPARATOR.'ref_genre='.$this->ref_genre);
            exit();
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/master/com_category/complete/'.WAP_URI_SEPARATOR.'ref_genre='.$this->ref_genre);
            exit();
        }

        $this->set_list();
    }

    /**
     * ジャンルの設定
     *
     * @access private
     * @return void
     **/
    function set_genre()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'genre '.
            'FROM '.
                DB_PREFIX.'com_genre '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();        
        foreach ($result as $value){
            $list[$value['id']] = $value['genre'];
        }

        $this->ref_genre = empty($this->ref_genre)?$result[0]:$this->ref_genre;
        $this->Assign('genres', $list);
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'sort,'.
                'category '.
            'FROM '.
                DB_PREFIX.'com_category '.
            'WHERE '.
                'ref_genre = '.$this->ref_genre.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('list', $result);
    }

    /**
     * 表示順番の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function get_sort()
    {
        $sql=
            'SELECT '.
                'max(sort) as sort '.
            'FROM '.
                DB_PREFIX.'com_category '.
            'WHERE '.
                'ref_genre = '.$this->ref_genre;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        return empty($result['sort'])?1:$result['sort']+1;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('sort', $this->get_sort());
        }

        // 更新しない項目名
        $skip = array(
            'sort'
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this);
    }

    /**
     * 連続データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        foreach ($_POST['deletes'] as $values){
            $this->delete_query($values);
        }
        return true;
    }

    /**
     * 更新処理
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id   = RKT_validate::number($values['id'])?$values['id']:0;
        $sort = RKT_validate::number($values['sort'])?$values['sort']:0;
        $id   = $this->objdb->quote($id);
        $sort = $this->objdb->quote($sort);

        $sql =
            'UPDATE '.
                DB_PREFIX.'com_category '.
            'SET '.
                'sort = '.$sort.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }

    /**
     * 削除処理
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function delete_query($values)
    {
        $id   = RKT_validate::number($values['delete'])?$values['delete']:0;
        $id   = $this->objdb->quote($id);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_category '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }
} // webapp
?>
