<?php
/* ========================================================================
 - [modules/public/registry/invite.php]
 -      自動招待フォーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/21] テーブルを fri_friends から fri_invite に変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_validate.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達リストID
     * @var integer
     */
    var $id = 0;

    /**
     * データ検査オブジェクト
     * @var object
     */
    var $objvld = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/registry/invite.tpl');

        // データ操作クラスの生成
        $this->objvld = new RKT_validate('_POST');
        if ($this->do_query()){
            $this->invitation_mail();
            header('Location: '.HTTP_ACTION.'public/registry/invite/'.$this->sid.'/complete/');
            exit();
        }

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }
    }

    /**
     * 入力されたメールの人が会員か？
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_member($values)
    {
        $email = $this->objvld->getRequest('email');
        $email_hash = sql_query::hash($email);
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'email_hash = '.$this->objdb->quote($email_hash);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return !empty($result['ct']);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_validate()
    {
        if (empty($_POST['manip'])){
            return false;
        }

        $this->objvld->validate('email', 'email', null, true);
        $this->objvld->validate('email', 'confirm', null, true);

        /* 入力値の取得 */
        $values = array(
            'email'=>$this->objvld->getRequest('email'),
            'confirm'=>$this->objvld->getRequest('confirm'),
        );
        $this->Assign('value', $values);

        // 確認用メールが一致しているか
        if (!empty($values['confirm'])){
            $confirm = strstr($values['email'], $values['confirm']);
        }
        if(empty($confirm)){
            $this->objvld->setAlert('confirm');
        }

        // 既存ユーザーか
        if($this->is_member($values)){
            $this->objvld->setAlert('member');
        }


        $check = $this->objvld->getValidate();
        if (!$check){
            $this->objvld->displayAlert($this);
            return false;
        }

        return true;
    }

    /**
     * IDの取得と設定
     *
     * @access private
     * @return void
     */
    function set_curid()
    {
        $email = $this->objvld->getRequest('email');
        $email_hash = sql_query::hash($email);
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'ref_account = '.SNS_ACC_GHOST.' AND '.
                'email_hash ='.$this->objdb->quote($email_hash);
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->id = empty($result['id'])?0:$result['id'];
        
        return empty($this->id);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!$this->do_validate()){
            return false;
        }
        $email = $this->objvld->getRequest('email');

        $encrypted  = sql_query::encrypt($email);
        $email_hash = sql_query::hash($email);

        $values = array(
            'modify'=> $this->objdb->quote(date('Y-m-d H:i:s')),
            'email' => $this->objdb->quote($encrypted),
            'email_hash'=> $this->objdb->quote($email_hash)
        );
        $this->Assign('noupdate', true);
        
        $result = false;
        if ($this->set_curid()){
            $result = $this->insert_invite($values);
        } else {
            $result = $this->update_invite($values);
        }
        return $result;
    }

    /**
     * データの挿入
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function insert_invite($values)
    {
        $sql=
            'INSERT INTO '.
                DB_PREFIX.'fri_invite ('.
                    'modify,'.
                    'ref_account,'.
                    'email,'.
                    'email_hash '.
                ') VALUES ('.
                    $values['modify'].','.
                    SNS_ACC_GHOST.','.
                    $values['email'].','.
                    $values['email_hash'].
                ')';
        $result = $this->objdb->exec($sql);
        $this->id = $this->objdb->lastInsertId();
        
        return $result;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_invite($values)
    {
        $sql=
            'UPDATE '.
                DB_PREFIX.'fri_invite '.
            'SET '.
                'modify='.$values['modify'].','.
                'ref_account='.SNS_ACC_GHOST.','.
                'email='.$values['email'].','.
                'email_hash='.$values['email_hash'].' '.
            'WHERE '.
                'id = '.$this->id;
        return $this->objdb->exec($sql);
    }

    /**
     * メール本文の作成・取得
     *
     * @access private
     * @return void
     */
    function invitation_mail()
    {
        $sql=
            'SELECT '.
                'email '.
            'FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'id = '.$this->id. ' AND '.
                'ref_account = '.SNS_ACC_GHOST;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $to = sql_query::decrypt($result['email']);

    	$seed = md5(SNS_ACC_GHOST.RKT_SEED);
        $seed = substr($seed,4,6);
    	$key  = md5($seed.$to.RKT_SEED);
    	$url  = SSL_ACTION.'public/registry/account/'.$this->id.'/'.$seed.'/'.$key.'/';

        $objmail = new sendmail('auto_invite');        
        $objmail->Assign('url',   $url);

        $objmail->send($to);
    }
} // webapp
?>
