<?php
/* ========================================================================
 - [modules/friend/edit/intro.php]
 -      紹介文編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * 紹介文ID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/edit/intro.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        
        /* 友達判定 */
        $this->Assign('is_friend', $this->isFriend());

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/edit/intro/'.$this->sid.'/'.$this->ref_friend.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_intro');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->send_mail();
            header('Location: '.HTTP_ACTION.'friend/show/intro/'.$this->sid.'/'.$this->ref_friend.'/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'friend/edit/intro/'.$this->sid.'/'.$this->ref_friend.'/confirm/');
            exit();
        }

        /* 削除 */
        if ($this->delete_intro()){
            header('Location: '.HTTP_ACTION.'friend/show/intro/'.$this->sid.'/'.$this->ref_friend.'/');
            exit();
        }
    }

    /**
     * カレントIDの取得
     *
     * @access private
     * @return integer
     */
    function get_curid()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_intro '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $curid = $this->get_curid();
        // 新規登録以外の処理
        if (!empty($curid)){
            $this->objmnp->setCurID($curid);
        } else {
            $this->objmnp->setValue('ref_account', $this->ref_friend);
            $this->objmnp->setValue('ref_friend', $this->account['id']);
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'ref_friend',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail('intro');

        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'private/show/intro/');

        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }

    /**
     * 紹介文の削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_intro()
    {
        if (empty($_GET['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_intro '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account ='.$this->ref_friend.' AND '.
                'ref_friend = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

} // webapp
?>
