<?php
/* ========================================================================
 - [libs/rktPDO/drivers/rkt_pgsql.php]
 -      なんちゃってPDO pgsqlライバ
 -      Copyright (c) 2005-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/12/18]    RKT_pgsql::lastInsertId()の修正
 -      [2006/12/18]    DB接続の修正
 -      [2006/12/18]    定数定義をrkt_pdo.phpへ集中
 -      [2006/09/29]    リクエスト結果取得関連の定数宣言を追加
 -      [2005/03/19]    bindParam追加・RKT_pgsql::query()の戻り値を修正
 -      [2005/01/08]    作成
 - ======================================================================== */

/**
 * なんちゃってPDO pgsqlライバ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_pgsql
 * @access public
 * @version 1.0
 */
class RKT_pgsql
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * SQL文
     * @access private
     * @var string
     */
    var $last_query = '';

    /**
     * errmessage
     * @access private
     * @var string
     */
    var $sqlerror = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_pgsql($dsn,$arg=null)
    {
        $connection = 
            'host='.$dsn['host'].' '.
            'dbname='.$dsn['dbname'].' '.
            'user='.$dsn['username'].' '.
            'password='.$dsn['passwd'];
        $this->dbh = pg_connect($connection);
    }

    /**
     * オープンされたPostgreSQLデータベースを閉じる
     *
     * @access public
     * @return void
     */
    function db_close()
    {
        pg_close($this->dbh);
        $this->dbh = null;
    }

    /**
     * 指定Insert文からシーケンス名を取得
     *
     * @access public
     * @param string $sql
     * @return string
     */
    function sql2seqname($sql)
    {
        if (!preg_match('/INSERT/i', $sql)){
            return '';
        }
        $parse_sql = array('table'=>'');
        $sql = str_replace('"', '', $sql);
        $sql = str_replace(';', '', $sql);
        $sql = preg_replace('/INSERT INTO/i', "\$parse_sql['table']=\"", $sql, 1);
        $sql = preg_replace('/\(/i', "\";\$parse_sql['other']=\"", $sql, 1);
        $sql = preg_replace('/VALUES/i', "\";\$parse_sql['other']=\"", $sql, 1);
        $sql .= "\";";
        eval($sql);

        return 'seq_'.trim($parse_sql['table']);
    }

    /**
     * 最後に発行したIDの取得
     *
     * @access public
     * @param string $seqname
     * @return integer
     */
    function lastInsertId($seqname='')
    {
        if (empty($seqname)){
            $seqname = $this->sql2seqname($this->last_query);
        }
        $result = pg_query($this->dbh, "SELECT CURRVAL('".$seqname."')");
        $row = pg_fetch_row($result);
        return $row[0];
    }

    /**
     * プリペアドステートメントの作成
     *
     * @access public
     * @return object
     */
    function &prepare($sql)
    {
        $stmt = new RKT_pgsqlStatement($this->dbh);
        $stmt->setSql($sql);
        
        return $stmt;
    }

    /**
     * トランザクションの開始
     *
     * @access public
     * @return boolean
     */
    function beginTransaction()
    {
        $result = pg_query($this->dbh, 'BEGIN TRANSACTION');
        
        return ($result)?true:false;
    }

    /**
     * トランザクションの確証
     *
     * @access public
     * @return boolean
     */
    function commit()
    {
        $result = pg_query($this->dbh, 'COMMIT');
        
        return ($result)?true:false;
    }

    /**
     * トランザクション内のクエリ取りやめ
     *
     * @access public
     * @return boolean
     */
    function rollBack()
    {
        $result = pg_query($this->dbh, 'ROLLBACK');
        
        return ($result)?true:false;
    }

    /**
     * アトリビュート設定
     *
     * @access public
     * @param long $attribute
     * @param mixed $value
     * @return boolean
     */
    function setAttribute($attribute, $value)
    {        
        return true;
    }

    /**
     * クエリ用の文字列をクオートする
     *
     * @access public
     * @param string $query
     * @return string
     */
    function quote($query)
    {
        return "'".pg_escape_string($query)."'";
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return integer
     */
    function exec($query)
    {
        $this->last_query = $query;

		ob_start();
        $result = pg_query($this->dbh, $query);
		$this->sqlerror .= ob_get_contents();
		$cmdtuples  = pg_affected_rows($result);
		ob_end_clean();

        return $cmdtuples ;
    }

    /**
     * SQLクエリ実行
     *
     * @access public
     * @param string $query
     * @return integer
     */
    function query($query)
    {
        $this->last_query = $query;

		ob_start();
        $result = pg_query($this->dbh, $query);
		$this->sqlerror .= ob_get_contents();
		ob_end_clean();
        
        return ($result)?true:false;
    }
} // RKT_pgsqlの終了

/**
 * なんちゃってPDOStatement
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_pgsqlStatement
 * @access public
 * @version 1.1
 */
class RKT_pgsqlStatement
{
    /**
     * DBハンドル
     * @access private
     * @var object
     */
    var $dbh = null;

    /**
     * sql
     * @access private
     * @var string
     */
    var $sql = '';

    /**
     * result
     * @access private
     * @var resource
     */
    var $result = null;

    /**
     * bind_flag
     * @access private
     * @var boolean
     */
    var $bind_flag = false;
 
    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance(&$dbh)
    {
        static $__singleton;
        
        if ($__singleton == null) {
            $__singleton = new RKT_pgsqlStatement($dbh);
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_pgsqlStatement(&$dbh)
    {
        $this->dbh = $dbh;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setSql($sql)
    {
        $this->sql = $sql;
    }

    /**
     * SQLの設定
     *
     * @access public
     * @pram string $sql
     * @return void
     */
    function setBindFlag($flag)
    {
        $this->bind_flag = $flag;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function execute()
    {
        if ($this->bind_flag){
            $sql = $this->_bind($this->sql);
        } else {
            $sql = $this->sql;
        }
        $this->result = @pg_query($this->dbh, $sql);
        return ($this->result)?true:false;
    }

    /**
     * プリペアドステートメントを実行する 
     *
     * @access public
     * @return boolean
     */
    function rowCount()
    {
        return @pg_affected_rows($this->dbh);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetch($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>PGSQL_ASSOC,
                PDO_FETCH_NUM=>  PGSQL_NUM,
                PDO_FETCH_BOTH=> PGSQL_BOTH
            );
        return @pg_fetch_array($this->result, null, $result_type[$how]);
    }

    /**
     * 結果リソースの値を取得
     *
     * @access public
     * @return mixed
     */
    function fetchSingle()
    {
        $row = @pg_fetch_row($this->result);
        return $row[0];
    }

    /**
     * 結果リソースの全ての値を取得
     *
     * @access public
     * @param integer $how
     * @return array
     */
    function fetchAll($how)
    {
        $result_type = array(
                PDO_FETCH_ASSOC=>PGSQL_ASSOC,
                PDO_FETCH_NUM=>  PGSQL_NUM,
                PDO_FETCH_BOTH=> PGSQL_BOTH
            );
        $values = array();
        $row = 0;
        while ($fetch = @pg_fetch_array($this->result, null, $result_type[$how])) {
            foreach ($fetch as $key=>$value) {
                $values[$row][$key] = $value;
            }
            $row++;
        }
        return $values;
    }

    /**
     * バインド変数設定
     *
     * @access public
     * @param mixed $paramno
     * @param mixed &$param
     * @param integer $type
     * @param integer $maxlen
     * @param mixed $driverdata
     * @return boolean
     */
    function bindParam($paramno, &$param, $type=PDO_PARAM_STR, $maxlen=0, $driverdata=null)
    {
         $this->bind_flag = true;
         $this->param[$paramno] = array(
            'key'=>   $paramno,
            'param'=> &$param,
            'type'=>  $type,
            'maxlen'=>$maxlen
        );
        return true;
    }

    /**
     * カーソルを閉じる
     *
     * @access public
     * @return boolean
     */
    function closeCursor()
    {
        return true;
    }

    /**
     * バインド変数処理
     *
     * @access public
     * @return string
     */
    function _bind()
    {
        $types = array(
                PDO_PARAM_NULL=> '',
                PDO_PARAM_INT=>  '',
                PDO_PARAM_STR=>  "'",
                PDO_PARAM_LOB=>  '',
                PDO_PARAM_STMT=> ''
            );

        foreach ($this->param as $param){
            $value  = $types[$param['type']];
            $value .= pg_escape_string($param['param']);
            $value .= $types[$param['type']];

            $sql = preg_replace( '/'.$param['key'].'/', $value, $sql, 1);
        }

        return $sql;
    }
} // RKT_pgsqlStatementの終了
?>