<?php
/**
 * ブログ記事情報変更完了画面クラス
 *
 * ブログ記事情報変更完了画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class blogmod_complete extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「blogmod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current and $tmp_cage_last != 'admin.site' ) or ( $tmp_act != 'blogmod_confirm' and $tmp_act != 'uploadviewer' ) )
      {
        $this->obj_util->redirectTo( 'bloglist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッションから値を取得し、セッションを削除
      //------------------------------------------------------------------------
      $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );



      //------------------------------------------------------------------------
      // ブログ記事を更新する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              UPDATE `simpleblog_t_blog`
                 SET `mtime`         = now()
                   , `muser`         = ?
                   , `user_id`       = ?
                   , `blog_title`    = ?
                   , `blog_body`     = ?
                   , `open_datetime` = ?
                   , `end_datetime`  = ?
                   , `post_datetime` = ?
               WHERE `blog_id`       = ?

End_Of_SQL;

        // パラメタも用意する
        $tmp_myself = $this->obj_util->answerMyId();
        $param = array(
                        $tmp_myself
                      , $this->obj_sess->sessLoad( 'login_userid' )
                      , $tmp_entered[ 'errMsg' ][ 'title'     ]
                      , $tmp_entered[ 'errMsg' ][ 'body'      ]
                      , $tmp_entered[ 'errMsg' ][ 'opendate'  ]
                      , $tmp_entered[ 'errMsg' ][ 'enddate'   ]
                      , $tmp_entered[ 'errMsg' ][ 'postdate'  ]
                      , $tmp_entered[ 'errMsg' ][ 'blogid'    ]
                      );

        // Updateを実行
        $tmp_update_result = $this->obj_db->dbExecSQL( $sql, $param );
        if ( PEAR::isError( $tmp_update_result ) )
        {
          // エラーの場合はロールバックして接続を閉じ、例外を投げる
          $this->obj_db->dbRollback();
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Update Failure' );
          return false;
        } // end of if
        else
        {
          // 正常に実行できた場合はコミットして接続を閉じる
          $this->obj_db->dbCommit();
          $this->obj_db->dbDisConnect();
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage', $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',  $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',    str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'blogmod_complete.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogmod_complete

?>
