#!/bin/bash

#==============================================================================
# @package   risoluto
# @author    Risoluto Developers
# @license   http://opensource.org/licenses/bsd-license.php new BSD license
# @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
#==============================================================================

# Settings
SMARTY_VER="3.0.7"
PEAR_VER="1.8.0"

# Tests
RMCMD=`which rm 2>/dev/null`
if [ "x${RMCMD}" == "x" ];
then
  echo "Error: rm is not found."
  exit 1
fi

MVCMD=`which mv 2>/dev/null`
if [ "x${MVCMD}" == "x" ];
then
  echo "Error: mv is not found."
  exit 1
fi

TARCMD=`which tar 2>/dev/null`
if [ "x${TARCMD}" == "x" ];
then
  echo "Error: tar is not found."
  exit 1
fi

WGETCMD=`which wget 2>/dev/null`
if [ "x${WGETCMD}" == "x" ];
then
  echo "Error: wget is not found."
  exit 1
fi

PEARCMD=`which pear 2>/dev/null`
if [ "x${PEARCMD}" == "x" ];
then
  echo "Error: pear is not found."
  exit 1
else
  PEAR_INSTALLED=`${PEARCMD} version 2>&1 |grep "PEAR Version:"|sed "s/PEAR Version: //g"`
  if [ `echo ${PEAR_INSTALLED}|sed "s/\.//g"` -lt `echo ${PEAR_VER}|sed "s/\.//g"` ];
  then
    echo "Error: pear version is too old. Try '${PEARCMD} upgrade PEAR'."
    echo "[Note]If you failed, try '${PEARCMD} upgrade --force PEAR ; ${PEARCMD} upgrade-all'."
    exit 1
  fi
fi

# Delete current directories/files
${RMCMD} -fr ./.pearrc
${RMCMD} -fr ./PEAR
${RMCMD} -fr ./Smarty
${RMCMD} -fr ./pear

# Install pear
${PEARCMD} config-create `pwd` ./.pearrc
${PEARCMD} -c ./.pearrc config-set php_dir `pwd`/PEAR/
${PEARCMD} -c ./.pearrc channel-update pear.php.net
${PEARCMD} -c ./.pearrc install --alldeps -o PEAR
${PEARCMD} -c ./.pearrc install --alldeps -o MDB2
${PEARCMD} -c ./.pearrc install --alldeps -o MDB2_Driver_mysqli
${PEARCMD} -c ./.pearrc install --alldeps -o MDB2_Driver_mysql
${PEARCMD} -c ./.pearrc install --alldeps -o Pager

# Install Smarty
${WGETCMD} "http://www.smarty.net/files/Smarty-${SMARTY_VER}.tar.gz"
${TARCMD} xvzf ./Smarty-${SMARTY_VER}.tar.gz
${RMCMD} -fr ./Smarty-${SMARTY_VER}.tar.gz
${MVCMD} ./Smarty-${SMARTY_VER} ./Smarty
