<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.1
 */
class Pager{
	var $offset		= 0;
	var $limit		= 20;
	var $total		= 0;
	var $nextOffset	= 0;
	var $prevOffset	= 0;
	var $pageStart	= 0;	
	var $pageLast	= 0;
	
	function Pager($total=0,$limit=20,$offset=0){
		$this->setLimit($limit);
		$this->setOffset($offset);
		$this->setTotal($total);
	}
	function setOffset($value){
		$this->offset = intval($value);
	}
	function setLimit($value){
		if(empty($value)){
			$value = 20;
		}		
		$this->limit = intval($value);
	}
	function setTotal($total){
		$this->total = intval($total);

		if($this->total <= 0){
			$this->offset			= 0;
			$this->nextOffset		= 0;
			$this->prevOffset		= 0;
			$this->pageStart			= 0;
			$this->pageLast			= 0;
		}else{
			$this->nextOffset	= $this->offset + $this->limit;
			$this->prevOffset	= $this->offset - $this->limit;

			if($this->prevOffset < 0){
				$this->prevOffset = 0;
			}			
			if(($this->offset + $this->limit) > $this->total){
				$this->pageLast	= $this->total;
			}else{
				$this->pageLast	= $this->nextOffset;
			}
			$this->pageStart		= $this->offset + 1;
		}
	}
	function isNext(){
		if($this->nextOffset > 0 && $this->nextOffset <= $this->total){
			return true;
		}
		return false;
	}
	function isPrev(){
		if($this->offset > 0 && $this->total > $this->offset){
			return true;
		}
		return false;
	}
	function output(){
		return Message::_("Results {1} - {2} of about {3}",$this->pageStart,$this->pageLast,$this->total);
	}
	function pages($page=1,$pages=10){
		$page	= intval($page);
		$pages	= intval($pages) - 1;
		$last	= intval(@ceil($this->total / $this->limit));
		$first	= ($page > ($pages/2)) ? @ceil($page - ($pages/2)) : 1;
		$last	= ($last > ($first + $pages)) ? ($first + $pages) : $last;
		$first	= (($last - $pages) > 0) ? ($last - $pages) : $first;

		return array("first_page"=>$first,"last_page"=>$last);
	}
}