<?php
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
Rhaco::import("contribute.tag.TagContents.TagContents");
Rhaco::import("tag.data.SimpleTag");
Rhaco::import("tag.TagUtil");

class TagContentsManager{
	var $tagUtil;
	var $tagfilename;

	function TagContentsManager(){		
		$this->tagUtil		= new TagUtil();		
		$this->tagUtil->setTransaction(true);
	}
	function setDataFile($tagfilename){
		if($this->tagUtil->isTagfile($tagfilename,"data",true)){
			$this->tagfilename	= $tagfilename;
			return true;
		}
		return false;
	}
	function insert($request){
		$tag = $this->_getRequestToTag($request);
		$tag->setParameter("id",$this->_getNextId());
		$tag->setParameter("registDate",date("YmdHis"));

		if($this->tagUtil->insert($this->tagfilename,$tag)){
			$this->tagUtil->commit($this->tagfilename);
			return true;
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function update($request){
		$tag = new SimpleTag("contents");
		$tag->setParameter("id",$request["id"]);		

		if($this->tagUtil->update($this->tagfilename,$this->_getRequestToTag($request),$tag)){
			$this->tagUtil->commit($this->tagfilename);
			return true;			
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function delete($request){
		$tag = new SimpleTag("contents");
		$tag->setParameter("id",$request["id"]);

		if($this->tagUtil->delete($this->tagfilename,$tag)){
			$tag = new SimpleTag("contents");
			$tag->setParameter("parentId",$request["id"]);

			if($this->tagUtil->delete($this->tagfilename,$tag)){
				$this->tagUtil->commit($this->tagfilename);
				return true;				
			}
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function select($request=array()){
		$list = array();

		$tagList = $this->tagUtil->select($this->tagfilename,$this->_getRequestToConTag($request));
		$tagList = $this->tagUtil->sort($tagList,array("name"));

		foreach($tagList as $contents){
			$object = $this->tagUtil->toObject($contents,new TagContents());
			$object->setValue($contents->getValue());
			$list[] = $object;
		}
		return $list;
	}
	function get($request){
		$tag = new SimpleTag("contents");
		$tag->setParameter("id",$request["id"]);
		$tag = $this->tagUtil->get($this->tagfilename,$tag);

		if($tag == false){
			return false;
		}
		return $this->tagUtil->toObject($tag,new TagContents());
	}
	function getParent($request){
		$tag = new SimpleTag("contents");
		$tag->setParameter("id",$request["parentId"]);		
		$tag = $this->tagUtil->get($this->tagfilename,$tag);

		if($tag == false){
			return false;
		}
		return $this->tagUtil->toObject($tag,new TagContents());
	}
	function isParent($request){
		return !empty($request["parentId"]);
	}
	
	function _getNextId(){
		$tag	= $this->tagUtil->get($this->tagfilename,new SimpleTag("sequence"));
		if($tag){
			$next	= $tag->getParameter("current") + $tag->getParameter("increment");
			$tag->setParameter("current",$next);
			
			$this->tagUtil->update($this->tagfilename,$tag,new SimpleTag("sequence"));
			
			return $next;
		}else{
			$tag = new SimpleTag("sequence");
			$tag->setParameter("current",1);
			$tag->setParameter("increment",1);			
			
			if($this->tagUtil->insert($this->tagfilename,$tag)){
				$this->tagUtil->commit($this->tagfilename);
			}
			return 1;
		}
	}
	function _getRequestToTag($request){
		$tag = new SimpleTag("contents");

		if($this->_isRequest($request["parentId"])){
			$tag->setParameter("parentId",$request["parentId"]);
		}
		if($this->_isRequest($request["id"])){
			$tag->setParameter("id",$request["id"]);
		}
		if($this->_isRequest($request["name"])){
			$tag->setParameter("name",$request["name"]);
		}
		if($this->_isRequest($request["registDate"])){
			$tag->setParameter("registDate",$request["registDate"]);
		}
		if($this->_isRequest($request["data1"])){
			$tag->setParameter("data1",$request["data1"]);
		}
		if($this->_isRequest($request["data2"])){
			$tag->setParameter("data2",$request["data2"]);
		}
		if($this->_isRequest($request["data3"])){
			$tag->setParameter("data3",$request["data3"]);
		}
		if($this->_isRequest($request["data4"])){
			$tag->setParameter("data4",$request["data4"]);
		}
		if($this->_isRequest($request["data5"])){
			$tag->setParameter("data5",$request["data5"]);
		}
		$tag->addValue($request["value"]);

		return $tag;
	}
	function _getRequestToConTag($request){
		$contentsTag = new SimpleTag("contents");

		if($this->_isRequest($request["parentId"])){
			$contentsTag->setParameter("parentId",$request["parentId"]);
		}
		if($this->_isRequest($request["id"])){
			$contentsTag->setParameter("id",$request["id"]);
		}
		if($this->_isRequest($request["name"])){
			$contentsTag->setParameter("name",$request["name"]);
		}		
		if($this->_isRequest($request["registDate"])){
			$contentsTag->setParameter("registDate",$request["registDate"]);
		}
		if($this->_isRequest($request["data1"])){
			$contentsTag->setParameter("data1",$request["data1"]);
		}
		if($this->_isRequest($request["data2"])){
			$contentsTag->setParameter("data2",$request["data2"]);
		}
		if($this->_isRequest($request["data3"])){
			$contentsTag->setParameter("data3",$request["data3"]);
		}
		if($this->_isRequest($request["data4"])){
			$contentsTag->setParameter("data4",$request["data4"]);
		}
		if($this->_isRequest($request["data5"])){
			$contentsTag->setParameter("data5",$request["data5"]);
		}
		if($this->_isRequest($request["word"])){
			if($request["filterType"] == 1){
				$contentsTag->setParameter("name",$this->_simpleQuote("%".$request["word"]."%"));
			}else{
				$contentsTag->setValue($this->_simpleQuote("%".$request["word"]."%"));
			}
		}
		return $contentsTag;
	}
	function _isRequest($request){
		if(isset($request) && $request != ""){
			return true;
		}
		return false;
	}
	function _simpleQuote($value){
		$value = preg_quote($value,"/¥¥");
		$value = str_replace("_",".",$value);
		$value = str_replace("%",".*",$value);

		return $value;
	}
}
?>
