<?
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.DateUtil");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class TagContents extends TableObjectBase{
	var $parentId = "";
	var $id = "";
	var $name = "";
	var $value = "";
	var $registDate = null;
	var $updateDate = null;
	var $flag = false;
	
	var $data1 = "";
	var $data2 = "";
	var $data3 = "";
	var $data4 = "";
	var $data5 = "";

	function setParentId($value){
		$this->parentId = sprintf("%d",$value);;
	}
	function getParentId(){
		return $this->parentId;
	}
	function setId($value){
		$this->id = sprintf("%d",$value);;
	}
	function getId(){
		return $this->id;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setValue($value){
		$this->value = $value;
	}
	function getValue(){
		return $this->value;
	}

	function getRegistDate(){
		return $this->registDate;
	}
	function setRegistDate($value=""){
		if(!is_numeric($value)){
			$value = DateUtil::parseString($value);
		}
		$this->registDate = $value;
	}
	function formatRegistDate($format="Y/m/d H:i:s"){
		return date($format,$this->registDate);
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function setUpdateDate($value){
		if(!is_numeric($value)){
			$value = DateUtil::parseString($value);
		}
		$this->updateDate = $value;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function setFlag($flag=true){
		$this->flag = $flag;
	}
	function getFlag(){
		return $this->flag;
	}

	function setData1($value){
		$this->data1 = $value;
	}
	function getData1(){
		return $this->data1;
	}
	function setData2($value){
		$this->data2 = $value;
	}
	function getData2(){
		return $this->data2;
	}
	function setData3($value){
		$this->data3 = $value;
	}
	function getData3(){
		return $this->data3;
	}
	function setData4($value){
		$this->data4 = $value;
	}
	function getData4(){
		return $this->data4;
	}
	function setData5($value){
		$this->data5 = $value;
	}
	function getData5(){
		return $this->data5;
	}

	function columnParentId(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"PARENT_ID","ParentId","INTEGER");
	}
	function columnId(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"ID","Id","INTEGER");
	}
	function columnName(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"NAME","Name","STRING");
	}
	function columnValue(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"VALUE","Value","STRING");
	}
	function columnRegistDate(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"REGIST_DATE","RegistDate","TIMESTAMP");
	}
	function columnUpdateDate(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function columnFlag(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"FLAG","Flag","BOOLEAN");
	}
	function columnData1(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"DATA1","Data1","STRING");
	}
	function columnData2(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"DATA2","Data2","STRING");
	}
	function columnData3(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"DATA3","Data3","STRING");
	}
	function columnData4(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"DATA4","Data4","STRING");
	}
	function columnData5(){
		return new Column(new Table("RHACO_CONTENTS","CONTENTS"),"DATA5","Data5","STRING");
	}		
	function __columns(){
		return array(
				$this->columnParentId()
				,$this->columnId()
				,$this->columnName()
				,$this->columnValue()
				,$this->columnRegistDate()
				,$this->columnUpdateDate()
				,$this->columnData1()
				,$this->columnData2()
				,$this->columnData3()
				,$this->columnData4()
				,$this->columnData5()
			);
	}
}
?>