<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssItem.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssEnclosure.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssSource.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class RssItem20 extends RssItem{
	var $author = "";
	var $category = "";
	var $comments = "";
	var $pubDate = "";
	
	var $guid = "";
	var $source = "";
	var $enclosure = "";
	
	function _set($tag){
		parent::_set($tag);
		foreach($tag->getIn("author") as $intag){
			$this->setAuthor($intag->getValue());			
		}
		foreach($tag->getIn("category") as $intag){
			$this->setCategory($intag->getValue());			
		}
		foreach($tag->getIn("comments") as $intag){
			$this->setComments($intag->getValue());			
		}
		foreach($tag->getIn("pubDate") as $intag){
			$this->setPubDate($intag->getValue());			
		}
		foreach($tag->getIn("guid") as $intag){
			$this->setGuid($intag->getValue());
		}
		foreach($tag->getIn("enclosure") as $intag){
			$newtag = new RssEnclosure();
			$newtag->set($intag->get());
			$this->setEnclosure($newtag);
		}
		foreach($tag->getIn("source") as $intag){
			$newtag = new RssSource();
			$newtag->set($intag->get());
			$this->setSource($newtag);
		}		
	}
	function _get($outTag){
		$tag		= new SimpleTag("author",$this->getAuthor());		
		$outTag->addValue($tag->get());
		$tag		= new SimpleTag("category",$this->getCategory());		
		$outTag->addValue($tag->get());
		$tag		= new SimpleTag("comments",$this->getComments());		
		$outTag->addValue($tag->get());

		if(intval($this->pubDate) > 0){
			$tag		= new SimpleTag("pubDate",$this->getPubDate());
			$outTag->addValue($tag->get());
		}
		$tag		= new SimpleTag("guid",$this->getGuid());
		if(preg_match("/:\/\//",$this->getGuid())){
			$tag->setParameter("isPermaLink","true");
		}
		$outTag->addValue($tag->get());		

		if(Variable::isClassType(RssSource,$this->getSource())){
			$source		= $this->getSource();
			$tag->addValue($source->get());
		}
		if(Variable::isClassType(RssEnclosure,$this->getEnclosure())){
			$enclosure	= $this->getEnclosure();		
			$tag->addValue($enclosure->get());
		}
		return parent::_get($outTag);
	}
	function setAuthor($value){
		$this->author = $value;
	}
	function getAuthor(){
		return $this->author;
	}
	function setCategory($value){
		$this->category = $value;
	}
	function getCategory(){
		return $this->category;
	}
	function setComments($value){
		$this->comments = $value;
	}	
	function getComments(){
		return $this->comments;
	}
	function setEnclosure($value){
		if(Variable::isClassType(RssEnclosure,$value)){	
			$this->enclosure = $value;
		}
	}
	function getEnclosure(){
		return $this->enclosure;
	}
	function setGuid($value){
		$this->guid = $value;
	}
	function getGuid(){
		return $this->guid;
	}
	function setSource($value){
		if(Variable::isClassType(RssSource,$value)){	
			$this->source = $value;
		}
	}
	function getSource(){
		return $this->source;
	}
	function setPubDate($value){
		$this->pubDate = DateUtil::parseString($value);
	}
	function getPubDate(){
		return DateUtil::formatRfc2822($this->pubDate);
	}
}