<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class AtomEntry10 extends AtomEntry{
	var $author = "";
	var $updated = "";
	var $issued = "";
	var $id = "";
	var $published = "";

	function _set($tag){
		parent::_set($tag);

		foreach($tag->getIn("author") as $intag){
			$this->setAuthor($intag->get());
		}
		foreach($tag->getIn("updated") as $intag){
			$this->setUpdated($intag->getValue());
		}
		foreach($tag->getIn("issued") as $intag){
			$this->setIssued($intag->getValue());
		}
		foreach($tag->getIn("published") as $intag){
			$this->setPublished($intag->getValue());
		}		
		foreach($tag->getIn("id") as $intag){
			$this->setId($intag->getValue());
		}
	}
	function _get($outTag){
		if(intval($this->updated) > 0){
			$tag		= new SimpleTag("updated",$this->getUpdated());
			$outTag->addValue($tag->get());
		}
		if(intval($this->issued) > 0){
			$tag		= new SimpleTag("issued",$this->getIssued());
			$outTag->addValue($tag->get());
		}
		if(intval($this->published) > 0){	
			$tag		= new SimpleTag("published",$this->getPublished());
			$outTag->addValue($tag->get());
		}				
		$tag		= new SimpleTag("id",$this->getId());
		$outTag->addValue($tag->get());

		if(Variable::isClassType(AtomAuthor,$this->getAuthor())){
			$data = $this->getAuthor();
			$outTag->addValue($data->get());
		}
				
		return parent::_get($outTag);
	}
	function setUpdated($value){
		$this->updated = DateUtil::parseString($value);
	}
	function getUpdated(){
		return DateUtil::formatAtom($this->updated);
	}
	function setIssued($value){
		$this->issued = DateUtil::parseString($value);
	}
	function getIssued(){
		return DateUtil::formatAtom($this->issued);
	}
	function setPublished($value){
		$this->published = DateUtil::parseString($value);
	}
	function getPublished(){
		return DateUtil::formatAtom($this->published);
	}
	function setId($value){
		$this->id = $value;
	}
	function getId(){
		return $this->id;
	}
	function setAuthor($value){
		if(!Variable::isClassType(AtomAuthor,$value)){
			$author = new AtomAuthor();

			if(!$author->set($value)){
				$author->setName($value);
			}
			$value = $author;
		}
		$this->author = $value;
	}
	function getAuthor(){
		if(Variable::isClassType(AtomAuthor,$this->author)){
			return $this->author;
		}
		return new AtomAuthor();
	}
}