<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Atom.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomAuthor.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomLink.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.3
 */
class Atom10 extends Atom{
	var $version = "1.0";
	var $title = "";
	var $subtitle = "";	
	var $updated = "";
	var $id = "";
	var $link = array();
	var $generator;
	var $entryList = array();
	var $author = "";

	function Atom10(){
	}
	function set($src){
		$tag		= new SimpleTag();

		if(!$tag->set($src,"feed")){
			return false;
		}
		if($tag->getParameter("xmlns") != "http://www.w3.org/2005/Atom"){
			return false;
		}
		foreach($tag->getIn("entry") as $intag){
			$data = new AtomEntry10();
			$data->set($intag->get());
			$this->entryList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);
		}
		$tag->set($src,"feed");

		foreach($tag->getIn("id") as $intag){
			$this->setId($intag->getValue());
		}		
		foreach($tag->getIn("title") as $intag){
			$this->setTitle($intag->getValue());
		}
		foreach($tag->getIn("subtitle") as $intag){
			$this->setSubtitle($intag->getValue());
		}
		foreach($tag->getIn("updated") as $intag){
			$this->setUpdated($intag->getValue());
		}
		foreach($tag->getIn("generator") as $intag){
			$this->setGenerator($intag->getValue());
		}
		foreach($tag->getIn("author") as $intag){
			$this->setAuthor($intag->get());
		}
		foreach($tag->getIn("link") as $intag){
			$data = new AtomLink();
			$data->set($intag->get());
			$this->link[] = $data;
		}
		return true;
	}
	function get(){
		$outTag	= new SimpleTag("feed");
		$outTag->setParameter("xmlns","http://www.w3.org/2005/Atom");
		
		$tag = new SimpleTag("id",$this->getId());
		$outTag->addValue($tag->get());
		$tag = new SimpleTag("title",$this->getTitle());
		$outTag->addValue($tag->get());
		$tag = new SimpleTag("subtitle",$this->getSubtitle());
		$outTag->addValue($tag->get());		

		if(intval($this->updated) > 0){
			$tag = new SimpleTag("updated",$this->getUpdated());
			$outTag->addValue($tag->get());
		}
		$tag = new SimpleTag("generator",$this->getGenerator());
		$outTag->addValue($tag->get());		
		
		if(Variable::isClassType(AtomAuthor,$this->getAuthor())){
			$author = $this->getAuthor();
			$outTag->addValue($author->get());
		}
		foreach($this->link as $data){
			if(Variable::isClassType(AtomLink,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->entryList as $data){
			if(Variable::isClassType(AtomEntry10,$data)){
				$outTag->addValue($data->get());
			}
		}				
		return $outTag->get();
	}
	function setVersion($value){
		$this->version = $value;
	}
	function getVersion(){
		return $this->version;
	}
	function setId($value){
		$this->id = $value;
	}
	function getId(){
		return $this->id;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setSubtitle($value){
		$this->subtitle = $value;
	}
	function getSubtitle(){
		return $this->subtitle;
	}
	function setUpdated($value){
		$this->updated = DateUtil::parseString($value);
	}
	function getUpdated(){
		return DateUtil::formatAtom($this->updated);
	}
	function setGenerator($value){
		$this->generator = $value;
	}
	function getGenerator(){
		return $this->generator;
	}
	function setLink($href,$rel="",$type=""){
		$this->link[$href] = new AtomLink($href,$rel,$type);
	}
	function getLink(){
		return $this->link;
	}
	function getLinkHref(){
		foreach($this->link as $link){
			return $link->getHref();
		}
		return "";
	}	
	function getEntry(){
		return $this->entryList;
	}
	function setEntry(){
		if(func_num_args() > 0){
			$args	= func_get_args();
			$entry	= null;
			
			if(Variable::isClassType(AtomEntry10,$args[0])){
				$entry = $args[0];
			}else{
				$summary	= "";
				$content	= "";
	
				if(isset($args[1])){
					$summary = $args[1];
				}
				if(isset($args[2])){
					$content = $args[2];
				}			
				$entry = new AtomEntry10($args[0],$summary,$content);
			}
			$this->entryList[] = $entry;
		}
	}
	function setAuthor($value){
		if(!Variable::isClassType(AtomAuthor,$value)){
			$author = new AtomAuthor();
			$author->set($value);
			$value = $author;
		}		
		$this->author = $value;
	}
	function getAuthor(){
		if(Variable::isClassType(AtomAuthor,$this->author)){
			return $this->author;
		}
		return new AtomAuthor();
	}
}
?>