<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/CriteriaPattern.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalArgumentException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class Criterion{
	function equal($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,1);
	}
	function notEqual($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,2);
	}
	function greater($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,3);
	}
	function greaterEquals($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,4);
	}	
	function less($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,5);
	}
	function lessEquals($columnOrValueA,$columnOrValueB){
		return Criterion::add($columnOrValueA,$columnOrValueB,6);
	}
	function like($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,7);
	}
	function notLike($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,8);
	}
	function likei($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;			
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,9);
	}
	function notLikei($columnOrValueA,$columnOrValueB){
		if(!is_string($columnOrValueB) || empty($columnOrValueB)){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;			
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,10);
	}
	function in($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,11);
	}
	function notIn($columnOrValueA,$columnOrValueB){
		if(!is_array($columnOrValueB) || sizeof($columnOrValueB) <= 0){
			ExceptionTrigger::raise(new IllegalArgumentException(__FUNCTION__));			
			return null;
		}
		return Criterion::add($columnOrValueA,$columnOrValueB,12);
	}
	function add($columnOrValueA,$columnOrValueB,$pattern=1){
		if(!Variable::isClassType(Column,$columnOrValueA)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));			
			return null;
		}
		return new CriteriaPattern($columnOrValueA,$columnOrValueB,$pattern);
	}
}
?>